/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.Utils;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.AbstractEffectiveDocumentedNode;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.InputEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.OutputEffectiveStatementImpl;

public class RpcEffectiveStatementImpl
extends AbstractEffectiveDocumentedNode<QName, RpcStatement>
implements RpcDefinition {
    private final QName qname;
    private final SchemaPath path;
    private ContainerSchemaNode input;
    private ContainerSchemaNode output;
    ImmutableSet<TypeDefinition<?>> typeDefinitions;
    ImmutableSet<GroupingDefinition> groupings;
    ImmutableList<UnknownSchemaNode> unknownNodes;

    public RpcEffectiveStatementImpl(StmtContext<QName, RpcStatement, EffectiveStatement<QName, RpcStatement>> ctx) {
        super(ctx);
        this.qname = ctx.getStatementArgument();
        this.path = Utils.getSchemaPath(ctx);
        this.initSubstatements();
    }

    private void initSubstatements() {
        Collection<EffectiveStatement<?, ?>> effectiveSubstatements = this.effectiveSubstatements();
        LinkedList<UnknownSchemaNode> unknownNodesInit = new LinkedList<UnknownSchemaNode>();
        HashSet<GroupingDefinition> groupingsInit = new HashSet<GroupingDefinition>();
        HashSet<TypeDefinition> typeDefinitionsInit = new HashSet<TypeDefinition>();
        for (EffectiveStatement<?, ?> effectiveStatement : effectiveSubstatements) {
            if (effectiveStatement instanceof UnknownSchemaNode) {
                UnknownSchemaNode unknownNode = (UnknownSchemaNode)effectiveStatement;
                unknownNodesInit.add(unknownNode);
            }
            if (effectiveStatement instanceof GroupingDefinition) {
                GroupingDefinition groupingDefinition = (GroupingDefinition)effectiveStatement;
                groupingsInit.add(groupingDefinition);
            }
            if (effectiveStatement instanceof TypeDefinition) {
                TypeDefinition typeDefinition = (TypeDefinition)effectiveStatement;
                typeDefinitionsInit.add(typeDefinition);
            }
            if (this.input == null && effectiveStatement instanceof InputEffectiveStatementImpl) {
                this.input = (InputEffectiveStatementImpl)effectiveStatement;
            }
            if (this.output != null || !(effectiveStatement instanceof OutputEffectiveStatementImpl)) continue;
            this.output = (OutputEffectiveStatementImpl)effectiveStatement;
        }
        this.unknownNodes = ImmutableList.copyOf(unknownNodesInit);
        this.groupings = ImmutableSet.copyOf(groupingsInit);
        this.typeDefinitions = ImmutableSet.copyOf(typeDefinitionsInit);
    }

    public QName getQName() {
        return this.qname;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public ContainerSchemaNode getInput() {
        return this.input;
    }

    void setInput(ContainerSchemaNode input) {
        this.input = input;
    }

    public ContainerSchemaNode getOutput() {
        return this.output;
    }

    void setOutput(ContainerSchemaNode output) {
        this.output = output;
    }

    public Set<TypeDefinition<?>> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public Set<GroupingDefinition> getGroupings() {
        return this.groupings;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RpcEffectiveStatementImpl other = (RpcEffectiveStatementImpl)obj;
        if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(RpcEffectiveStatementImpl.class.getSimpleName());
        sb.append("[");
        sb.append("qname=");
        sb.append(this.qname);
        sb.append(", path=");
        sb.append(this.path);
        sb.append(", input=");
        sb.append(this.input);
        sb.append(", output=");
        sb.append(this.output);
        sb.append("]");
        return sb.toString();
    }
}

