/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.impl.util.YangModelDependencyInfo;

@Beta
public final class ASTSchemaSource
implements SchemaSourceRepresentation {
    public static final Function<ASTSchemaSource, SourceIdentifier> GET_IDENTIFIER = new Function<ASTSchemaSource, SourceIdentifier>(){

        public SourceIdentifier apply(@Nonnull ASTSchemaSource input) {
            Preconditions.checkNotNull((Object)input);
            return input.getIdentifier();
        }
    };
    public static final Function<ASTSchemaSource, YangModelDependencyInfo> GET_DEPINFO = new Function<ASTSchemaSource, YangModelDependencyInfo>(){

        public YangModelDependencyInfo apply(@Nonnull ASTSchemaSource input) {
            Preconditions.checkNotNull((Object)input);
            return input.getDependencyInformation();
        }
    };
    public static final Function<ASTSchemaSource, ParserRuleContext> GET_AST = new Function<ASTSchemaSource, ParserRuleContext>(){

        public ParserRuleContext apply(@Nonnull ASTSchemaSource input) {
            Preconditions.checkNotNull((Object)input);
            return input.getAST();
        }
    };
    private final YangModelDependencyInfo depInfo;
    private final ParserRuleContext tree;
    private final SourceIdentifier id;
    private final String text;

    private ASTSchemaSource(@Nonnull SourceIdentifier id, @Nonnull ParserRuleContext tree, @Nonnull YangModelDependencyInfo depInfo, String text) {
        this.depInfo = (YangModelDependencyInfo)Preconditions.checkNotNull((Object)depInfo);
        this.tree = (ParserRuleContext)Preconditions.checkNotNull((Object)tree);
        this.id = (SourceIdentifier)Preconditions.checkNotNull((Object)id);
        this.text = text;
    }

    public static ASTSchemaSource create(@Nonnull String name, @Nonnull ParserRuleContext tree) throws YangSyntaxErrorException {
        YangModelDependencyInfo depInfo = YangModelDependencyInfo.fromAST(name, tree);
        SourceIdentifier id = ASTSchemaSource.getSourceId(depInfo);
        return new ASTSchemaSource(id, tree, depInfo, null);
    }

    private static SourceIdentifier getSourceId(YangModelDependencyInfo depInfo) {
        String name = depInfo.getName();
        return depInfo.getFormattedRevision() == null ? new SourceIdentifier(name) : new SourceIdentifier(name, depInfo.getFormattedRevision());
    }

    @Deprecated
    public static ASTSchemaSource create(@Nonnull String name, @Nonnull ParserRuleContext tree, String text) throws YangSyntaxErrorException {
        YangModelDependencyInfo depInfo = YangModelDependencyInfo.fromAST(name, tree);
        SourceIdentifier id = ASTSchemaSource.getSourceId(depInfo);
        return new ASTSchemaSource(id, tree, depInfo, text);
    }

    public SourceIdentifier getIdentifier() {
        return this.id;
    }

    public Class<? extends SchemaSourceRepresentation> getType() {
        return ASTSchemaSource.class;
    }

    @Nonnull
    public ParserRuleContext getAST() {
        return this.tree;
    }

    @Nonnull
    public YangModelDependencyInfo getDependencyInformation() {
        return this.depInfo;
    }

    @Deprecated
    @Nonnull
    public String getYangText() {
        return this.text;
    }
}

