/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opendaylight.yangtools.yang.common.SimpleDateFormatUtil;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.util.ModuleOrModuleBuilder;
import org.opendaylight.yangtools.yang.parser.util.TopologicalSort;
import org.opendaylight.yangtools.yang.parser.util.YangValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModuleDependencySort {
    private static final Date DEFAULT_REVISION = new Date(0L);
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleDependencySort.class);
    private static final Function<TopologicalSort.Node, Module> TOPOLOGY_FUNCTION = new Function<TopologicalSort.Node, Module>(){

        public Module apply(TopologicalSort.Node input) {
            if (input == null) {
                return null;
            }
            ModuleOrModuleBuilder moduleOrModuleBuilder = ((ModuleNodeImpl)input).getReference();
            return moduleOrModuleBuilder.getModule();
        }
    };
    private static final Function<TopologicalSort.Node, ModuleBuilder> NODE_TO_MODULEBUILDER = new Function<TopologicalSort.Node, ModuleBuilder>(){

        public ModuleBuilder apply(TopologicalSort.Node input) {
            if (input == null) {
                return null;
            }
            ModuleOrModuleBuilder moduleOrModuleBuilder = ((ModuleNodeImpl)input).getReference();
            return moduleOrModuleBuilder.getModuleBuilder();
        }
    };

    private ModuleDependencySort() {
    }

    public static List<ModuleBuilder> sort(ModuleBuilder ... builders) {
        return ModuleDependencySort.sort(Arrays.asList(builders));
    }

    public static List<ModuleBuilder> sort(Collection<ModuleBuilder> builders) {
        List<TopologicalSort.Node> sorted = ModuleDependencySort.sortInternal(ModuleOrModuleBuilder.fromAll(Collections.emptySet(), builders));
        return Lists.transform(sorted, NODE_TO_MODULEBUILDER);
    }

    public static List<ModuleBuilder> sortWithContext(SchemaContext context, ModuleBuilder ... builders) {
        List<ModuleOrModuleBuilder> all = ModuleOrModuleBuilder.fromAll(context.getModules(), Arrays.asList(builders));
        List<TopologicalSort.Node> sorted = ModuleDependencySort.sortInternal(all);
        return Lists.transform(sorted, (Function)new Function<TopologicalSort.Node, ModuleBuilder>(){

            public ModuleBuilder apply(TopologicalSort.Node input) {
                if (input == null) {
                    return null;
                }
                ModuleOrModuleBuilder moduleOrModuleBuilder = ((ModuleNodeImpl)input).getReference();
                if (moduleOrModuleBuilder.isModuleBuilder()) {
                    return moduleOrModuleBuilder.getModuleBuilder();
                }
                return null;
            }
        });
    }

    public static List<Module> sort(Module ... modules) {
        List<TopologicalSort.Node> sorted = ModuleDependencySort.sortInternal(ModuleOrModuleBuilder.fromAll(Arrays.asList(modules), Collections.emptyList()));
        return Lists.transform(sorted, TOPOLOGY_FUNCTION);
    }

    private static List<TopologicalSort.Node> sortInternal(Iterable<ModuleOrModuleBuilder> modules) {
        Map<String, Map<Date, ModuleNodeImpl>> moduleGraph = ModuleDependencySort.createModuleGraph(modules);
        HashSet nodes = Sets.newHashSet();
        for (Map<Date, ModuleNodeImpl> map : moduleGraph.values()) {
            for (ModuleNodeImpl node : map.values()) {
                nodes.add(node);
            }
        }
        return TopologicalSort.sort(nodes);
    }

    @VisibleForTesting
    static Map<String, Map<Date, ModuleNodeImpl>> createModuleGraph(Iterable<ModuleOrModuleBuilder> builders) {
        HashMap moduleGraph = Maps.newHashMap();
        ModuleDependencySort.processModules(moduleGraph, builders);
        ModuleDependencySort.processDependencies(moduleGraph, builders);
        return moduleGraph;
    }

    /*
     * WARNING - void declaration
     */
    private static void processDependencies(Map<String, Map<Date, ModuleNodeImpl>> moduleGraph, Iterable<ModuleOrModuleBuilder> mmbs) {
        HashMap<URI, ModuleOrModuleBuilder> allNS = new HashMap<URI, ModuleOrModuleBuilder>();
        for (ModuleOrModuleBuilder mmb : mmbs) {
            URI ns;
            Collection<Object> imports;
            Date fromRevision;
            String fromName;
            HashMap imported = Maps.newHashMap();
            if (mmb.isModule()) {
                Module module = mmb.getModule();
                fromName = module.getName();
                fromRevision = module.getRevision();
                imports = module.getImports();
                ns = module.getNamespace();
            } else {
                ModuleBuilder moduleBuilder = mmb.getModuleBuilder();
                fromName = moduleBuilder.getName();
                fromRevision = moduleBuilder.getRevision();
                imports = moduleBuilder.getImports().values();
                ns = moduleBuilder.getNamespace();
            }
            if (allNS.containsKey(ns)) {
                void var11_15;
                ModuleOrModuleBuilder mod = (ModuleOrModuleBuilder)allNS.get(ns);
                Object var11_12 = null;
                Date revision = null;
                if (mod.isModule()) {
                    String string = mod.getModule().getName();
                    revision = mod.getModule().getRevision();
                } else if (mod.isModuleBuilder()) {
                    String string = mod.getModuleBuilder().getName();
                    revision = mod.getModuleBuilder().getRevision();
                }
                if (!fromName.equals(var11_15)) {
                    LOGGER.warn("Error while sorting module [{}, {}]: module with same namespace ({}) already loaded: [{}, {}]", new Object[]{fromName, fromRevision, ns, var11_15, revision});
                }
            } else {
                allNS.put(ns, mmb);
            }
            if (fromRevision == null) {
                fromRevision = DEFAULT_REVISION;
            }
            for (ModuleImport moduleImport : imports) {
                String toName = moduleImport.getModuleName();
                Date toRevision = moduleImport.getRevision() == null ? DEFAULT_REVISION : moduleImport.getRevision();
                ModuleNodeImpl from = moduleGraph.get(fromName).get(fromRevision);
                ModuleNodeImpl to = ModuleDependencySort.getModuleByNameAndRevision(moduleGraph, fromName, fromRevision, toName, toRevision);
                if (!(imported.get(toName) == null || ((Date)imported.get(toName)).equals(toRevision) || ((Date)imported.get(toName)).equals(DEFAULT_REVISION) || toRevision.equals(DEFAULT_REVISION))) {
                    ModuleDependencySort.ex(String.format("Module:%s imported twice with different revisions:%s, %s", toName, ModuleDependencySort.formatRevDate((Date)imported.get(toName)), ModuleDependencySort.formatRevDate(toRevision)));
                }
                imported.put(toName, toRevision);
                from.addEdge(to);
            }
        }
    }

    private static ModuleNodeImpl getModuleByNameAndRevision(Map<String, Map<Date, ModuleNodeImpl>> moduleGraph, String fromName, Date fromRevision, String toName, Date toRevision) {
        ModuleNodeImpl to = null;
        if (moduleGraph.get(toName) == null || !moduleGraph.get(toName).containsKey(toRevision)) {
            if (moduleGraph.get(toName) != null && !moduleGraph.get(toName).isEmpty() && toRevision.equals(DEFAULT_REVISION)) {
                to = moduleGraph.get(toName).values().iterator().next();
                LOGGER.trace(String.format("Import:%s:%s by module:%s:%s does not specify revision, using:%s:%s for module dependency sort", toName, ModuleDependencySort.formatRevDate(toRevision), fromName, ModuleDependencySort.formatRevDate(fromRevision), to.getName(), ModuleDependencySort.formatRevDate(to.getRevision())));
            } else {
                LOGGER.warn(String.format("Not existing module imported:%s:%s by:%s:%s", toName, ModuleDependencySort.formatRevDate(toRevision), fromName, ModuleDependencySort.formatRevDate(fromRevision)));
                LOGGER.warn("Available models: {}", moduleGraph);
                ModuleDependencySort.ex(String.format("Not existing module imported:%s:%s by:%s:%s", toName, ModuleDependencySort.formatRevDate(toRevision), fromName, ModuleDependencySort.formatRevDate(fromRevision)));
            }
        } else {
            to = moduleGraph.get(toName).get(toRevision);
        }
        return to;
    }

    private static void ex(String message) {
        throw new YangValidationException(message);
    }

    private static void processModules(Map<String, Map<Date, ModuleNodeImpl>> moduleGraph, Iterable<ModuleOrModuleBuilder> builders) {
        for (ModuleOrModuleBuilder momb : builders) {
            Date rev;
            String name;
            if (momb.isModule()) {
                name = momb.getModule().getName();
                rev = momb.getModule().getRevision();
            } else {
                name = momb.getModuleBuilder().getName();
                rev = momb.getModuleBuilder().getRevision();
            }
            if (rev == null) {
                rev = DEFAULT_REVISION;
            }
            if (moduleGraph.get(name) == null) {
                moduleGraph.put(name, Maps.newHashMap());
            }
            if (moduleGraph.get(name).get(rev) != null) {
                ModuleDependencySort.ex(String.format("Module:%s with revision:%s declared twice", name, ModuleDependencySort.formatRevDate(rev)));
            }
            moduleGraph.get(name).put(rev, new ModuleNodeImpl(name, rev, momb));
        }
    }

    private static String formatRevDate(Date rev) {
        return rev.equals(DEFAULT_REVISION) ? "default" : SimpleDateFormatUtil.getRevisionFormat().format(rev);
    }

    @VisibleForTesting
    static class ModuleNodeImpl
    extends TopologicalSort.NodeImpl {
        private final String name;
        private final Date revision;
        private final ModuleOrModuleBuilder originalObject;

        public ModuleNodeImpl(String name, Date revision, ModuleOrModuleBuilder builder) {
            this.name = name;
            this.revision = revision;
            this.originalObject = builder;
        }

        public String getName() {
            return this.name;
        }

        public Date getRevision() {
            return this.revision;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleNodeImpl other = (ModuleNodeImpl)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
        }

        public String toString() {
            return "Module [name=" + this.name + ", revision=" + ModuleDependencySort.formatRevDate(this.revision) + "]";
        }

        public ModuleOrModuleBuilder getReference() {
            return this.originalObject;
        }
    }
}

