/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.util;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;

class ModuleOrModuleBuilder {
    private final Optional<Module> maybeModule;
    private final Optional<ModuleBuilder> maybeModuleBuilder;

    ModuleOrModuleBuilder(Module module) {
        this.maybeModule = Optional.of((Object)module);
        this.maybeModuleBuilder = Optional.absent();
    }

    ModuleOrModuleBuilder(ModuleBuilder moduleBuilder) {
        this.maybeModule = Optional.absent();
        this.maybeModuleBuilder = Optional.of((Object)moduleBuilder);
    }

    boolean isModule() {
        return this.maybeModule.isPresent();
    }

    boolean isModuleBuilder() {
        return this.maybeModuleBuilder.isPresent();
    }

    Module getModule() {
        return (Module)this.maybeModule.get();
    }

    ModuleBuilder getModuleBuilder() {
        return (ModuleBuilder)this.maybeModuleBuilder.get();
    }

    static List<ModuleOrModuleBuilder> fromAll(Collection<Module> modules, Collection<ModuleBuilder> moduleBuilders) {
        ArrayList<ModuleOrModuleBuilder> result = new ArrayList<ModuleOrModuleBuilder>(modules.size() + moduleBuilders.size());
        for (Module m : modules) {
            result.add(new ModuleOrModuleBuilder(m));
        }
        for (ModuleBuilder mb : moduleBuilders) {
            result.add(new ModuleOrModuleBuilder(mb));
        }
        return result;
    }
}

