/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.util;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.opendaylight.yangtools.yang.parser.util.NamedInputStream;

public class NamedByteArrayInputStream
extends ByteArrayInputStream
implements NamedInputStream {
    private final String toString;

    public NamedByteArrayInputStream(byte[] buf, String toString) {
        super(buf);
        this.toString = toString;
    }

    public static ByteArrayInputStream create(InputStream originalIS) throws IOException {
        byte[] data = ByteStreams.toByteArray((InputStream)originalIS);
        if (originalIS instanceof NamedInputStream) {
            return new NamedByteArrayInputStream(data, originalIS.toString());
        }
        return new ByteArrayInputStream(data);
    }

    @Override
    public String toString() {
        return this.toString;
    }
}

