/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import java.io.InputStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.opendaylight.yangtools.antlrv4.code.gen.YangParser;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.repo.util.SchemaSourceTransformer;
import org.opendaylight.yangtools.yang.parser.impl.YangModelBasicValidationListener;
import org.opendaylight.yangtools.yang.parser.impl.YangParserImpl;
import org.opendaylight.yangtools.yang.parser.util.ASTSchemaSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class TextToASTTransformer
extends SchemaSourceTransformer<YangTextSchemaSource, ASTSchemaSource> {
    public static final TextToASTTransformation TRANSFORMATION = new TextToASTTransformation();
    private static final Logger LOG = LoggerFactory.getLogger(TextToASTTransformer.class);

    private TextToASTTransformer(SchemaRepository provider, SchemaSourceRegistry consumer) {
        super(provider, YangTextSchemaSource.class, consumer, ASTSchemaSource.class, (AsyncFunction)TRANSFORMATION);
    }

    public static TextToASTTransformer create(SchemaRepository provider, SchemaSourceRegistry consumer) {
        return new TextToASTTransformer(provider, consumer);
    }

    public static final class TextToASTTransformation
    implements SchemaSourceTransformer.Transformation<YangTextSchemaSource, ASTSchemaSource> {
        public CheckedFuture<ASTSchemaSource, SchemaSourceException> apply(final YangTextSchemaSource input) throws IOException, YangSyntaxErrorException {
            try (InputStream is = input.openStream();){
                YangParser.YangContext ctx = YangParserImpl.parseYangSource(is);
                LOG.debug("Model {} parsed successfully", (Object)input);
                ParseTreeWalker walker = new ParseTreeWalker();
                YangModelBasicValidationListener validator = new YangModelBasicValidationListener();
                walker.walk((ParseTreeListener)validator, (ParseTree)ctx);
                LOG.debug("Model {} validated successfully", (Object)input);
                String text = new ByteSource(){

                    public InputStream openStream() throws IOException {
                        return input.openStream();
                    }
                }.asCharSource(Charsets.UTF_8).read();
                CheckedFuture checkedFuture = Futures.immediateCheckedFuture((Object)ASTSchemaSource.create(input.getIdentifier().getName(), ctx, text));
                return checkedFuture;
            }
        }
    }
}

