/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.opendaylight.yangtools.antlrv4.code.gen.YangStatementParser;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactory;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactoryConfiguration;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaResolutionException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceFilter;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.StatementParserMode;
import org.opendaylight.yangtools.yang.parser.impl.DefaultReactors;
import org.opendaylight.yangtools.yang.parser.repo.DependencyResolver;
import org.opendaylight.yangtools.yang.parser.repo.RevisionDependencyResolver;
import org.opendaylight.yangtools.yang.parser.repo.SemVerDependencyResolver;
import org.opendaylight.yangtools.yang.parser.repo.SharedSchemaRepository;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.ASTSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangStatementStreamSource;
import org.opendaylight.yangtools.yang.parser.spi.meta.ReactorException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.CrossSourceStatementReactor;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.EffectiveSchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SharedSchemaContextFactory
implements SchemaContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SharedSchemaContextFactory.class);
    private final Cache<Collection<SourceIdentifier>, SchemaContext> revisionCache = CacheBuilder.newBuilder().weakValues().build();
    private final Cache<Collection<SourceIdentifier>, SchemaContext> semVerCache = CacheBuilder.newBuilder().weakValues().build();
    private final SchemaRepository repository;
    private final SchemaContextFactoryConfiguration config;

    @Deprecated
    SharedSchemaContextFactory(SharedSchemaRepository repository, SchemaSourceFilter filter) {
        this.repository = (SchemaRepository)Preconditions.checkNotNull((Object)((Object)repository));
        this.config = SchemaContextFactoryConfiguration.builder().setFilter(filter).build();
    }

    SharedSchemaContextFactory(SchemaRepository repository, SchemaContextFactoryConfiguration config) {
        this.repository = (SchemaRepository)Preconditions.checkNotNull((Object)repository);
        this.config = (SchemaContextFactoryConfiguration)Preconditions.checkNotNull((Object)config);
    }

    @Deprecated
    public ListenableFuture<SchemaContext> createSchemaContext(Collection<SourceIdentifier> requiredSources, StatementParserMode statementParserMode, Set<QName> supportedFeatures) {
        return this.createSchemaContext(requiredSources, statementParserMode == StatementParserMode.SEMVER_MODE ? this.semVerCache : this.revisionCache, new AssembleSources(SchemaContextFactoryConfiguration.builder().setFilter(this.config.getSchemaSourceFilter()).setStatementParserMode(statementParserMode).setSupportedFeatures(supportedFeatures).build()));
    }

    public ListenableFuture<SchemaContext> createSchemaContext(Collection<SourceIdentifier> requiredSources) {
        return this.createSchemaContext(requiredSources, this.config.getStatementParserMode() == StatementParserMode.SEMVER_MODE ? this.semVerCache : this.revisionCache, new AssembleSources(this.config));
    }

    private ListenableFuture<SchemaContext> createSchemaContext(Collection<SourceIdentifier> requiredSources, final Cache<Collection<SourceIdentifier>, SchemaContext> cache, AsyncFunction<List<ASTSchemaSource>, SchemaContext> assembleSources) {
        final List<SourceIdentifier> uniqueSourceIdentifiers = SharedSchemaContextFactory.deDuplicateSources(requiredSources);
        SchemaContext existing = (SchemaContext)cache.getIfPresent(uniqueSourceIdentifiers);
        if (existing != null) {
            LOG.debug("Returning cached context {}", (Object)existing);
            return Futures.immediateFuture((Object)existing);
        }
        ListenableFuture sf = Futures.allAsList((Iterable)Collections2.transform(uniqueSourceIdentifiers, this::requestSource));
        sf = Futures.transform((ListenableFuture)sf, (Function)new SourceIdMismatchDetector(uniqueSourceIdentifiers), (Executor)MoreExecutors.directExecutor());
        ListenableFuture cf = Futures.transformAsync((ListenableFuture)sf, assembleSources, (Executor)MoreExecutors.directExecutor());
        Futures.addCallback((ListenableFuture)cf, (FutureCallback)new FutureCallback<SchemaContext>(){

            public void onSuccess(SchemaContext result) {
                cache.put((Object)uniqueSourceIdentifiers, (Object)result);
            }

            public void onFailure(@Nonnull Throwable cause) {
                LOG.debug("Failed to assemble sources", cause);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return cf;
    }

    private ListenableFuture<ASTSchemaSource> requestSource(SourceIdentifier identifier) {
        return this.repository.getSchemaSource(identifier, ASTSchemaSource.class);
    }

    private static List<SourceIdentifier> deDuplicateSources(Collection<SourceIdentifier> requiredSources) {
        LinkedHashSet<SourceIdentifier> uniqueSourceIdentifiers = new LinkedHashSet<SourceIdentifier>(requiredSources);
        if (uniqueSourceIdentifiers.size() == requiredSources.size()) {
            return ImmutableList.copyOf(requiredSources);
        }
        LOG.warn("Duplicate sources requested for schema context, removed duplicate sources: {}", (Object)Collections2.filter(uniqueSourceIdentifiers, input -> Iterables.frequency((Iterable)requiredSources, (Object)input) > 1));
        return ImmutableList.copyOf(uniqueSourceIdentifiers);
    }

    private static final class AssembleSources
    implements AsyncFunction<List<ASTSchemaSource>, SchemaContext> {
        private final SchemaContextFactoryConfiguration config;
        private final Function<ASTSchemaSource, SourceIdentifier> getIdentifier;

        private AssembleSources(@Nonnull SchemaContextFactoryConfiguration config) {
            this.config = config;
            switch (config.getStatementParserMode()) {
                case SEMVER_MODE: {
                    this.getIdentifier = ASTSchemaSource::getSemVerIdentifier;
                    break;
                }
                default: {
                    this.getIdentifier = ASTSchemaSource::getIdentifier;
                }
            }
        }

        public ListenableFuture<SchemaContext> apply(@Nonnull List<ASTSchemaSource> sources) throws SchemaResolutionException, ReactorException {
            EffectiveSchemaContext schemaContext;
            DependencyResolver res;
            ImmutableMap srcs = Maps.uniqueIndex(sources, this.getIdentifier);
            Map deps = Maps.transformValues((Map)srcs, ASTSchemaSource::getDependencyInformation);
            LOG.debug("Resolving dependency reactor {}", (Object)deps);
            StatementParserMode statementParserMode = this.config.getStatementParserMode();
            DependencyResolver dependencyResolver = res = statementParserMode == StatementParserMode.SEMVER_MODE ? SemVerDependencyResolver.create(deps) : RevisionDependencyResolver.create(deps);
            if (!res.getUnresolvedSources().isEmpty()) {
                LOG.debug("Omitting models {} due to unsatisfied imports {}", res.getUnresolvedSources(), res.getUnsatisfiedImports());
                throw new SchemaResolutionException("Failed to resolve required models", res.getResolvedSources(), res.getUnsatisfiedImports());
            }
            CrossSourceStatementReactor.BuildAction reactor = DefaultReactors.defaultReactor().newBuild(statementParserMode);
            this.config.getSupportedFeatures().ifPresent(arg_0 -> ((CrossSourceStatementReactor.BuildAction)reactor).setSupportedFeatures(arg_0));
            this.config.getModulesDeviatedByModules().ifPresent(arg_0 -> ((CrossSourceStatementReactor.BuildAction)reactor).setModulesWithSupportedDeviations(arg_0));
            for (Map.Entry e : srcs.entrySet()) {
                ASTSchemaSource ast = (ASTSchemaSource)e.getValue();
                ParserRuleContext parserRuleCtx = ast.getAST();
                Preconditions.checkArgument((boolean)(parserRuleCtx instanceof YangStatementParser.StatementContext), (String)"Unsupported context class %s for source %s", parserRuleCtx.getClass(), e.getKey());
                reactor.addSource((StatementStreamSource)YangStatementStreamSource.create((SourceIdentifier)((SourceIdentifier)e.getKey()), (YangStatementParser.StatementContext)((YangStatementParser.StatementContext)parserRuleCtx), (String)ast.getSymbolicName().orElse(null)));
            }
            try {
                schemaContext = reactor.buildEffective();
            }
            catch (ReactorException ex) {
                throw new SchemaResolutionException("Failed to resolve required models", ex.getSourceIdentifier(), (Throwable)ex);
            }
            return Futures.immediateFuture((Object)schemaContext);
        }
    }

    private static final class SourceIdMismatchDetector
    implements Function<List<ASTSchemaSource>, List<ASTSchemaSource>> {
        private final List<SourceIdentifier> sourceIdentifiers;

        SourceIdMismatchDetector(List<SourceIdentifier> sourceIdentifiers) {
            this.sourceIdentifiers = (List)Preconditions.checkNotNull(sourceIdentifiers);
        }

        public List<ASTSchemaSource> apply(List<ASTSchemaSource> input) {
            LinkedHashMap<SourceIdentifier, ASTSchemaSource> filtered = new LinkedHashMap<SourceIdentifier, ASTSchemaSource>();
            for (int i = 0; i < input.size(); ++i) {
                ASTSchemaSource astSchemaSource;
                SourceIdentifier realSId;
                SourceIdentifier expectedSId = this.sourceIdentifiers.get(i);
                if (!expectedSId.equals(realSId = (astSchemaSource = input.get(i)).getIdentifier())) {
                    LOG.warn("Source identifier mismatch for module \"{}\", requested as {} but actually is {}. Using actual id", new Object[]{expectedSId.getName(), expectedSId, realSId});
                }
                if (filtered.containsKey(realSId)) {
                    LOG.warn("Duplicate source for module {} detected in reactor", (Object)realSId);
                }
                filtered.put(realSId, astSchemaSource);
            }
            return ImmutableList.copyOf(filtered.values());
        }
    }
}

