/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.MissingSchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactory;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaResolutionException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceFilter;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.StatementParserMode;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaListenerRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceListener;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.repo.util.InMemorySchemaSourceCache;
import org.opendaylight.yangtools.yang.parser.repo.AbstractYangTextSchemaSourceRegistration;
import org.opendaylight.yangtools.yang.parser.repo.SharedSchemaRepository;
import org.opendaylight.yangtools.yang.parser.repo.YangTextSchemaSourceRegistration;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.ASTSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.TextToASTTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YangTextSchemaContextResolver
implements AutoCloseable,
SchemaSourceProvider<YangTextSchemaSource> {
    private static final Logger LOG = LoggerFactory.getLogger(YangTextSchemaContextResolver.class);
    private static final long SOURCE_LIFETIME_SECONDS = 60L;
    private final Collection<SourceIdentifier> requiredSources = new ConcurrentLinkedDeque<SourceIdentifier>();
    private final Multimap<SourceIdentifier, YangTextSchemaSource> texts = ArrayListMultimap.create();
    private final AtomicReference<Optional<SchemaContext>> currentSchemaContext = new AtomicReference(Optional.empty());
    private final InMemorySchemaSourceCache<ASTSchemaSource> cache;
    private final SchemaListenerRegistration transReg;
    private final SchemaSourceRegistry registry;
    private final SchemaRepository repository;
    private volatile Object version;
    private volatile Object contextVersion = this.version = new Object();

    private YangTextSchemaContextResolver(SchemaRepository repository, SchemaSourceRegistry registry) {
        this.repository = (SchemaRepository)Preconditions.checkNotNull((Object)repository);
        this.registry = (SchemaSourceRegistry)Preconditions.checkNotNull((Object)registry);
        TextToASTTransformer t = TextToASTTransformer.create((SchemaRepository)repository, (SchemaSourceRegistry)registry);
        this.transReg = registry.registerSchemaSourceListener((SchemaSourceListener)t);
        this.cache = InMemorySchemaSourceCache.createSoftCache((SchemaSourceRegistry)registry, ASTSchemaSource.class, (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }

    public static YangTextSchemaContextResolver create(String name) {
        SharedSchemaRepository sharedRepo = new SharedSchemaRepository(name);
        return new YangTextSchemaContextResolver((SchemaRepository)sharedRepo, (SchemaSourceRegistry)sharedRepo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YangTextSchemaSourceRegistration registerSource(@Nonnull YangTextSchemaSource source) throws SchemaSourceException, IOException, YangSyntaxErrorException {
        YangTextSchemaSource text;
        Preconditions.checkArgument((source != null ? 1 : 0) != 0);
        ASTSchemaSource ast = TextToASTTransformer.transformText((YangTextSchemaSource)source);
        LOG.trace("Resolved source {} to source {}", (Object)source, (Object)ast);
        SourceIdentifier providedId = source.getIdentifier();
        final SourceIdentifier parsedId = ast.getIdentifier();
        if (!parsedId.equals(providedId)) {
            if (!parsedId.getName().equals(providedId.getName())) {
                LOG.info("Provided module name {} does not match actual text {}, corrected", (Object)providedId.toYangFilename(), (Object)parsedId.toYangFilename());
            } else {
                Optional sourceRev = providedId.getRevision();
                Optional astRev = parsedId.getRevision();
                if (sourceRev.isPresent()) {
                    if (!sourceRev.equals(astRev)) {
                        LOG.info("Provided module revision {} does not match actual text {}, corrected", (Object)providedId.toYangFilename(), (Object)parsedId.toYangFilename());
                    }
                } else {
                    LOG.debug("Expanded module {} to {}", (Object)providedId.toYangFilename(), (Object)parsedId.toYangFilename());
                }
            }
            text = YangTextSchemaSource.delegateForByteSource((SourceIdentifier)parsedId, (ByteSource)source);
        } else {
            text = source;
        }
        YangTextSchemaContextResolver yangTextSchemaContextResolver = this;
        synchronized (yangTextSchemaContextResolver) {
            this.texts.put((Object)parsedId, (Object)text);
            LOG.debug("Populated {} with text", (Object)parsedId);
            final SchemaSourceRegistration reg = this.registry.registerSchemaSource((SchemaSourceProvider)this, PotentialSchemaSource.create((SourceIdentifier)parsedId, YangTextSchemaSource.class, (int)PotentialSchemaSource.Costs.IMMEDIATE.getValue()));
            this.requiredSources.add(parsedId);
            this.cache.schemaSourceEncountered((SchemaSourceRepresentation)ast);
            LOG.debug("Added source {} to schema context requirements", (Object)parsedId);
            this.version = new Object();
            return new AbstractYangTextSchemaSourceRegistration(text){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void removeRegistration() {
                    YangTextSchemaContextResolver yangTextSchemaContextResolver = YangTextSchemaContextResolver.this;
                    synchronized (yangTextSchemaContextResolver) {
                        YangTextSchemaContextResolver.this.requiredSources.remove(parsedId);
                        LOG.trace("Removed source {} from schema context requirements", (Object)parsedId);
                        YangTextSchemaContextResolver.this.version = new Object();
                        reg.close();
                        YangTextSchemaContextResolver.this.texts.remove((Object)parsedId, (Object)text);
                    }
                }
            };
        }
    }

    public YangTextSchemaSourceRegistration registerSource(final @Nonnull URL url) throws SchemaSourceException, IOException, YangSyntaxErrorException {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Supplied URL must not be null");
        String path = url.getPath();
        String fileName = path.substring(path.lastIndexOf(47) + 1);
        SourceIdentifier guessedId = YangTextSchemaContextResolver.guessSourceIdentifier(fileName);
        return this.registerSource(new YangTextSchemaSource(guessedId){

            public InputStream openStream() throws IOException {
                return url.openStream();
            }

            protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
                return toStringHelper.add("url", (Object)url);
            }
        });
    }

    private static SourceIdentifier guessSourceIdentifier(String fileName) {
        try {
            return YangTextSchemaSource.identifierFromFilename((String)fileName);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid file name format in '{}'", (Object)fileName, (Object)e);
            return RevisionSourceIdentifier.create((String)fileName);
        }
    }

    public Optional<SchemaContext> getSchemaContext() {
        return this.getSchemaContext(StatementParserMode.DEFAULT_MODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<SchemaContext> getSchemaContext(StatementParserMode statementParserMode) {
        Optional<Object> sc;
        SchemaContextFactory factory = this.repository.createSchemaContextFactory(SchemaSourceFilter.ALWAYS_ACCEPT);
        while (true) {
            Object sources;
            Object ver;
            Object cv = this.contextVersion;
            sc = this.currentSchemaContext.get();
            if (this.version == cv) {
                return sc;
            }
            if (cv != this.contextVersion) continue;
            do {
                ver = this.version;
                sources = ImmutableSet.copyOf(this.requiredSources);
            } while (ver != this.version);
            while (true) {
                ListenableFuture f = factory.createSchemaContext((Collection)sources, statementParserMode);
                try {
                    sc = Optional.of(f.get());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while assembling schema context", e);
                }
                catch (ExecutionException e) {
                    LOG.info("Failed to fully assemble schema context for {}", sources, (Object)e);
                    Throwable cause = e.getCause();
                    Verify.verify((boolean)(cause instanceof SchemaResolutionException));
                    sources = ((SchemaResolutionException)cause).getResolvedSources();
                    continue;
                }
                break;
            }
            LOG.debug("Resolved schema context for {}", sources);
            YangTextSchemaContextResolver yangTextSchemaContextResolver = this;
            synchronized (yangTextSchemaContextResolver) {
                if (this.contextVersion == cv) {
                    this.currentSchemaContext.set(sc);
                    this.contextVersion = ver;
                }
            }
            if (this.version != ver) break;
        }
        return sc;
    }

    public synchronized ListenableFuture<YangTextSchemaSource> getSource(SourceIdentifier sourceIdentifier) {
        Collection ret = this.texts.get((Object)sourceIdentifier);
        LOG.debug("Lookup {} result {}", (Object)sourceIdentifier, (Object)ret);
        if (ret.isEmpty()) {
            return Futures.immediateFailedFuture((Throwable)new MissingSchemaSourceException("URL for " + sourceIdentifier + " not registered", sourceIdentifier));
        }
        return Futures.immediateFuture(ret.iterator().next());
    }

    public synchronized Set<SourceIdentifier> getAvailableSources() {
        return ImmutableSet.copyOf((Collection)this.texts.keySet());
    }

    @Beta
    public synchronized Collection<YangTextSchemaSource> getSourceTexts(SourceIdentifier sourceIdentifier) {
        return ImmutableSet.copyOf((Collection)this.texts.get((Object)sourceIdentifier));
    }

    @Beta
    public SchemaContext trySchemaContext() throws SchemaResolutionException {
        return this.trySchemaContext(StatementParserMode.DEFAULT_MODE);
    }

    @Beta
    public SchemaContext trySchemaContext(StatementParserMode statementParserMode) throws SchemaResolutionException {
        ListenableFuture future = this.repository.createSchemaContextFactory(SchemaSourceFilter.ALWAYS_ACCEPT).createSchemaContext((Collection)ImmutableSet.copyOf(this.requiredSources), statementParserMode);
        try {
            return (SchemaContext)future.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for SchemaContext assembly", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SchemaResolutionException) {
                throw (SchemaResolutionException)cause;
            }
            throw new SchemaResolutionException("Failed to assemble SchemaContext", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.transReg.close();
    }
}

