/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.parser.api.YangParser;
import org.opendaylight.yangtools.yang.model.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.model.repo.api.StatementParserMode;
import org.opendaylight.yangtools.yang.parser.impl.DefaultReactors;
import org.opendaylight.yangtools.yang.parser.impl.YangParserImpl;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.CrossSourceStatementReactor;

@Beta
public final class YangParserFactoryImpl
implements YangParserFactory {
    private static final ImmutableList<StatementParserMode> SUPPORTED_MODES = ImmutableList.of((Object)StatementParserMode.DEFAULT_MODE, (Object)StatementParserMode.SEMVER_MODE);
    private final CrossSourceStatementReactor reactor;

    public YangParserFactoryImpl() {
        this(DefaultReactors.defaultReactor());
    }

    public YangParserFactoryImpl(@NonNull CrossSourceStatementReactor reactor) {
        this.reactor = Objects.requireNonNull(reactor);
    }

    public Collection<StatementParserMode> supportedParserModes() {
        return SUPPORTED_MODES;
    }

    public YangParser createParser(StatementParserMode parserMode) {
        return new YangParserImpl(this.reactor.newBuild(parserMode));
    }
}

