/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.annotations.Beta;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.model.repo.api.EffectiveModelContextFactory;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactoryConfiguration;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.util.AbstractSchemaRepository;
import org.opendaylight.yangtools.yang.parser.repo.SharedSchemaContextFactory;

@Beta
public final class SharedSchemaRepository
extends AbstractSchemaRepository
implements Identifiable<String> {
    private final LoadingCache<SchemaContextFactoryConfiguration, EffectiveModelContextFactory> cacheByConfig = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<SchemaContextFactoryConfiguration, EffectiveModelContextFactory>(){

        public EffectiveModelContextFactory load(SchemaContextFactoryConfiguration key) {
            return new SharedSchemaContextFactory((SchemaRepository)SharedSchemaRepository.this, key);
        }
    });
    private final @NonNull String id;

    public SharedSchemaRepository(String id) {
        this.id = Objects.requireNonNull(id);
    }

    public @NonNull String getIdentifier() {
        return this.id;
    }

    public @NonNull EffectiveModelContextFactory createEffectiveModelContextFactory(@NonNull SchemaContextFactoryConfiguration config) {
        return (EffectiveModelContextFactory)this.cacheByConfig.getUnchecked((Object)config);
    }

    public String toString() {
        return "SchemaRepository: " + this.id;
    }
}

