/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.repo.api.EffectiveModelContextFactory;
import org.opendaylight.yangtools.yang.model.repo.api.MissingSchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactoryConfiguration;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaResolutionException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.StatementParserMode;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.GuavaSchemaSourceCache;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaListenerRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceListener;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.repo.AbstractYangTextSchemaSourceRegistration;
import org.opendaylight.yangtools.yang.parser.repo.SharedSchemaRepository;
import org.opendaylight.yangtools.yang.parser.repo.YangTextSchemaSourceRegistration;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.TextToIRTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YangTextSchemaContextResolver
implements AutoCloseable,
SchemaSourceProvider<YangTextSchemaSource> {
    private static final Logger LOG = LoggerFactory.getLogger(YangTextSchemaContextResolver.class);
    private static final Duration SOURCE_LIFETIME = Duration.ofSeconds(60L);
    private final Collection<SourceIdentifier> requiredSources = new ConcurrentLinkedDeque<SourceIdentifier>();
    private final Multimap<SourceIdentifier, YangTextSchemaSource> texts = ArrayListMultimap.create();
    private final AtomicReference<Optional<EffectiveModelContext>> currentSchemaContext = new AtomicReference(Optional.empty());
    private final GuavaSchemaSourceCache<IRSchemaSource> cache;
    private final SchemaListenerRegistration transReg;
    private final SchemaSourceRegistry registry;
    private final SchemaRepository repository;
    private volatile Object version;
    private volatile Object contextVersion = this.version = new Object();

    private YangTextSchemaContextResolver(SchemaRepository repository, SchemaSourceRegistry registry) {
        this.repository = Objects.requireNonNull(repository);
        this.registry = Objects.requireNonNull(registry);
        TextToIRTransformer t = TextToIRTransformer.create((SchemaRepository)repository, (SchemaSourceRegistry)registry);
        this.transReg = registry.registerSchemaSourceListener((SchemaSourceListener)t);
        this.cache = GuavaSchemaSourceCache.createSoftCache((SchemaSourceRegistry)registry, IRSchemaSource.class, (Duration)SOURCE_LIFETIME);
    }

    public static @NonNull YangTextSchemaContextResolver create(String name) {
        SharedSchemaRepository sharedRepo = new SharedSchemaRepository(name);
        return new YangTextSchemaContextResolver((SchemaRepository)sharedRepo, (SchemaSourceRegistry)sharedRepo);
    }

    public static @NonNull YangTextSchemaContextResolver create(String name, YangParserFactory factory) {
        SharedSchemaRepository sharedRepo = new SharedSchemaRepository(name, factory);
        return new YangTextSchemaContextResolver((SchemaRepository)sharedRepo, (SchemaSourceRegistry)sharedRepo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull YangTextSchemaSourceRegistration registerSource(@NonNull YangTextSchemaSource source) throws SchemaSourceException, IOException, YangSyntaxErrorException {
        YangTextSchemaSource text;
        Preconditions.checkArgument((source != null ? 1 : 0) != 0);
        IRSchemaSource ast = TextToIRTransformer.transformText((YangTextSchemaSource)source);
        LOG.trace("Resolved source {} to source {}", (Object)source, (Object)ast);
        SourceIdentifier providedId = source.getIdentifier();
        final SourceIdentifier parsedId = (SourceIdentifier)ast.getIdentifier();
        if (!parsedId.equals(providedId)) {
            if (!parsedId.getName().equals(providedId.getName())) {
                LOG.info("Provided module name {} does not match actual text {}, corrected", (Object)providedId.toYangFilename(), (Object)parsedId.toYangFilename());
            } else {
                Optional sourceRev = providedId.getRevision();
                Optional astRev = parsedId.getRevision();
                if (sourceRev.isPresent()) {
                    if (!sourceRev.equals(astRev)) {
                        LOG.info("Provided module revision {} does not match actual text {}, corrected", (Object)providedId.toYangFilename(), (Object)parsedId.toYangFilename());
                    }
                } else {
                    LOG.debug("Expanded module {} to {}", (Object)providedId.toYangFilename(), (Object)parsedId.toYangFilename());
                }
            }
            text = YangTextSchemaSource.delegateForByteSource((SourceIdentifier)parsedId, (ByteSource)source);
        } else {
            text = source;
        }
        YangTextSchemaContextResolver yangTextSchemaContextResolver = this;
        synchronized (yangTextSchemaContextResolver) {
            this.texts.put((Object)parsedId, (Object)text);
            LOG.debug("Populated {} with text", (Object)parsedId);
            final SchemaSourceRegistration reg = this.registry.registerSchemaSource((SchemaSourceProvider)this, PotentialSchemaSource.create((SourceIdentifier)parsedId, YangTextSchemaSource.class, (int)PotentialSchemaSource.Costs.IMMEDIATE.getValue()));
            this.requiredSources.add(parsedId);
            this.cache.schemaSourceEncountered((SchemaSourceRepresentation)ast);
            LOG.debug("Added source {} to schema context requirements", (Object)parsedId);
            this.version = new Object();
            return new AbstractYangTextSchemaSourceRegistration(text){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void removeRegistration() {
                    YangTextSchemaContextResolver yangTextSchemaContextResolver = YangTextSchemaContextResolver.this;
                    synchronized (yangTextSchemaContextResolver) {
                        YangTextSchemaContextResolver.this.requiredSources.remove(parsedId);
                        LOG.trace("Removed source {} from schema context requirements", (Object)parsedId);
                        YangTextSchemaContextResolver.this.version = new Object();
                        reg.close();
                        YangTextSchemaContextResolver.this.texts.remove((Object)parsedId, (Object)text);
                    }
                }
            };
        }
    }

    public @NonNull YangTextSchemaSourceRegistration registerSource(@NonNull URL url) throws SchemaSourceException, IOException, YangSyntaxErrorException {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Supplied URL must not be null");
        String path = url.getPath();
        String fileName = path.substring(path.lastIndexOf(47) + 1);
        return this.registerSource(YangTextSchemaSource.forURL((URL)url, (SourceIdentifier)YangTextSchemaContextResolver.guessSourceIdentifier(fileName)));
    }

    private static SourceIdentifier guessSourceIdentifier(@NonNull String fileName) {
        try {
            return YangTextSchemaSource.identifierFromFilename((String)fileName);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid file name format in '{}'", (Object)fileName, (Object)e);
            return RevisionSourceIdentifier.create((String)fileName);
        }
    }

    public Optional<? extends EffectiveModelContext> getEffectiveModelContext() {
        return this.getEffectiveModelContext(StatementParserMode.DEFAULT_MODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<? extends EffectiveModelContext> getEffectiveModelContext(StatementParserMode statementParserMode) {
        Optional<EffectiveModelContext> sc;
        EffectiveModelContextFactory factory = this.repository.createEffectiveModelContextFactory(YangTextSchemaContextResolver.config(statementParserMode));
        while (true) {
            Object sources;
            Object ver;
            Object cv = this.contextVersion;
            sc = this.currentSchemaContext.get();
            if (this.version == cv) {
                return sc;
            }
            if (cv != this.contextVersion) continue;
            do {
                ver = this.version;
                sources = ImmutableSet.copyOf(this.requiredSources);
            } while (ver != this.version);
            while (true) {
                ListenableFuture f = factory.createEffectiveModelContext((Collection)sources);
                try {
                    sc = Optional.of((EffectiveModelContext)f.get());
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Interrupted while assembling schema context", e);
                }
                catch (ExecutionException e) {
                    LOG.info("Failed to fully assemble schema context for {}", sources, (Object)e);
                    Throwable cause = e.getCause();
                    Verify.verify((boolean)(cause instanceof SchemaResolutionException));
                    sources = ((SchemaResolutionException)cause).getResolvedSources();
                    continue;
                }
                break;
            }
            LOG.debug("Resolved schema context for {}", sources);
            YangTextSchemaContextResolver yangTextSchemaContextResolver = this;
            synchronized (yangTextSchemaContextResolver) {
                if (this.contextVersion == cv) {
                    this.currentSchemaContext.set(sc);
                    this.contextVersion = ver;
                }
            }
            if (this.version != ver) break;
        }
        return sc;
    }

    public synchronized @NonNull FluentFuture<YangTextSchemaSource> getSource(SourceIdentifier sourceIdentifier) {
        Collection ret = this.texts.get((Object)sourceIdentifier);
        LOG.debug("Lookup {} result {}", (Object)sourceIdentifier, (Object)ret);
        if (ret.isEmpty()) {
            return FluentFutures.immediateFailedFluentFuture((Throwable)new MissingSchemaSourceException("URL for " + sourceIdentifier + " not registered", sourceIdentifier));
        }
        return FluentFutures.immediateFluentFuture((Object)((YangTextSchemaSource)ret.iterator().next()));
    }

    public synchronized Set<SourceIdentifier> getAvailableSources() {
        return ImmutableSet.copyOf((Collection)this.texts.keySet());
    }

    @Beta
    public synchronized Collection<YangTextSchemaSource> getSourceTexts(SourceIdentifier sourceIdentifier) {
        return ImmutableSet.copyOf((Collection)this.texts.get((Object)sourceIdentifier));
    }

    @Beta
    public EffectiveModelContext trySchemaContext() throws SchemaResolutionException {
        return this.trySchemaContext(StatementParserMode.DEFAULT_MODE);
    }

    @Beta
    public EffectiveModelContext trySchemaContext(StatementParserMode statementParserMode) throws SchemaResolutionException {
        ListenableFuture future = this.repository.createEffectiveModelContextFactory(YangTextSchemaContextResolver.config(statementParserMode)).createEffectiveModelContext((Collection)ImmutableSet.copyOf(this.requiredSources));
        try {
            return (EffectiveModelContext)future.get();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted while waiting for SchemaContext assembly", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SchemaResolutionException) {
                throw (SchemaResolutionException)cause;
            }
            throw new SchemaResolutionException("Failed to assemble SchemaContext", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.transReg.close();
    }

    private static SchemaContextFactoryConfiguration config(StatementParserMode statementParserMode) {
        return SchemaContextFactoryConfiguration.builder().setStatementParserMode(statementParserMode).build();
    }
}

