/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtxCompat;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.RootStmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;

public interface StmtContext<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends NamespaceStmtCtx,
BoundStmtCtxCompat<A, D> {
    public @Nullable StmtContext<?, ?, ?> getParentContext();

    default public @NonNull StmtContext<?, ?, ?> coerceParentContext() {
        return (StmtContext)Verify.verifyNotNull(this.getParentContext(), (String)"Root context %s does not have a parent", (Object[])new Object[]{this});
    }

    public @NonNull RootStmtContext<?, ?, ?> getRoot();

    public @NonNull Collection<? extends @NonNull StmtContext<?, ?, ?>> declaredSubstatements();

    public @NonNull Collection<? extends @NonNull StmtContext<?, ?, ?>> effectiveSubstatements();

    default public Iterable<? extends @NonNull StmtContext<?, ?, ?>> allSubstatements() {
        return Iterables.concat(this.declaredSubstatements(), this.effectiveSubstatements());
    }

    default public Stream<? extends @NonNull StmtContext<?, ?, ?>> allSubstatementsStream() {
        return Streams.concat((Stream[])new Stream[]{this.declaredSubstatements().stream(), this.effectiveSubstatements().stream()});
    }

    public @NonNull E buildEffective();

    public boolean isSupportedToBuildEffective();

    public boolean isSupportedByFeatures();

    public Collection<? extends StmtContext<?, ?, ?>> getEffectOfStatement();

    public Optional<StmtContext<A, D, E>> getOriginalCtx();

    public Optional<StmtContext<A, D, E>> getPreviousCopyCtx();

    public @NonNull Mutable<A, D, E> replicaAsChildOf(Mutable<?, ?, ?> var1);

    @Beta
    public @NonNull Optional<Mutable<A, D, E>> copyAsChildOf(Mutable<?, ?, ?> var1, CopyType var2, @Nullable QNameModule var3);

    public ModelProcessingPhase getCompletedPhase();

    public static interface Mutable<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
    extends StmtContext<A, D, E> {
        @Override
        public Mutable<?, ?, ?> getParentContext();

        @Override
        default public Mutable<?, ?, ?> coerceParentContext() {
            return (Mutable)Verify.verifyNotNull((Object)this.getParentContext(), (String)"Root context %s does not have a parent", (Object[])new Object[]{this});
        }

        public <K, V> void addToNs(@NonNull ParserNamespace<K, V> var1, K var2, V var3);

        @Override
        public RootStmtContext.Mutable<?, ?, ?> getRoot();

        public Mutable<?, ?, ?> childCopyOf(StmtContext<?, ?, ?> var1, CopyType var2, @Nullable QNameModule var3);

        default public Mutable<?, ?, ?> childCopyOf(StmtContext<?, ?, ?> stmt, CopyType type) {
            return this.childCopyOf(stmt, type, null);
        }

        @Override
        default public Collection<? extends @NonNull StmtContext<?, ?, ?>> declaredSubstatements() {
            return this.mutableDeclaredSubstatements();
        }

        public @NonNull Collection<? extends @NonNull Mutable<?, ?, ?>> mutableDeclaredSubstatements();

        @Override
        default public Collection<? extends @NonNull StmtContext<?, ?, ?>> effectiveSubstatements() {
            return this.mutableEffectiveSubstatements();
        }

        public @NonNull Collection<? extends @NonNull Mutable<?, ?, ?>> mutableEffectiveSubstatements();

        public @NonNull ModelActionBuilder newInferenceAction(@NonNull ModelProcessingPhase var1);

        public void setRootVersion(YangVersion var1);

        public void addRequiredSource(SourceIdentifier var1);

        public void addEffectiveSubstatement(Mutable<?, ?, ?> var1);

        public void addEffectiveSubstatements(Collection<? extends Mutable<?, ?, ?>> var1);

        @Beta
        public <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> @NonNull Mutable<X, Y, Z> createUndeclaredSubstatement(StatementSupport<X, Y, Z> var1, @Nullable X var2);

        @Beta
        public void removeStatementFromEffectiveSubstatements(StatementDefinition var1);

        @Beta
        public void removeStatementFromEffectiveSubstatements(StatementDefinition var1, String var2);

        @Beta
        public boolean hasImplicitParentSupport();

        @Beta
        public StmtContext<?, ?, ?> wrapWithImplicit(StmtContext<?, ?, ?> var1);

        public void addAsEffectOfStatement(Collection<? extends StmtContext<?, ?, ?>> var1);

        public void setRootIdentifier(SourceIdentifier var1);

        public void setUnsupported();
    }
}

