/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.Strings;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureSet;
import org.opendaylight.yangtools.yang.model.api.stmt.IfFeatureExpr;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MinElementsStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PresenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnknownStatement;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.RootStmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class StmtContextUtils {
    private StmtContextUtils() {
    }

    public static <A, D extends DeclaredStatement<A>> A firstAttributeOf(Iterable<? extends StmtContext<?, ?, ?>> contexts, Class<D> declaredType) {
        for (StmtContext<?, ?, ?> ctx : contexts) {
            if (!ctx.producesDeclared(declaredType)) continue;
            return ctx.argument();
        }
        return null;
    }

    public static <A, D extends DeclaredStatement<A>> A firstAttributeOf(StmtContext<?, ?, ?> ctx, Class<D> declaredType) {
        return ctx.producesDeclared(declaredType) ? (A)ctx.argument() : null;
    }

    public static <A, D extends DeclaredStatement<A>> A firstSubstatementAttributeOf(StmtContext<?, ?, ?> ctx, Class<D> declaredType) {
        return StmtContextUtils.firstAttributeOf(ctx.allSubstatements(), declaredType);
    }

    public static <A, D extends DeclaredStatement<A>> StmtContext<A, ?, ?> findFirstDeclaredSubstatement(StmtContext<?, ?, ?> stmtContext, Class<D> declaredType) {
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.declaredSubstatements()) {
            if (!subStmtContext.producesDeclared(declaredType)) continue;
            return subStmtContext;
        }
        return null;
    }

    @SafeVarargs
    public static StmtContext<?, ?, ?> findFirstDeclaredSubstatement(StmtContext<?, ?, ?> stmtContext, int startIndex, Class<? extends DeclaredStatement<?>> ... types) {
        if (startIndex >= types.length) {
            return null;
        }
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.declaredSubstatements()) {
            if (!subStmtContext.producesDeclared(types[startIndex])) continue;
            return startIndex + 1 == types.length ? subStmtContext : StmtContextUtils.findFirstDeclaredSubstatement(subStmtContext, ++startIndex, types);
        }
        return null;
    }

    public static <A, D extends DeclaredStatement<A>> Collection<StmtContext<A, D, ?>> findAllDeclaredSubstatements(StmtContext<?, ?, ?> stmtContext, Class<D> declaredType) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.declaredSubstatements()) {
            if (!subStmtContext.producesDeclared(declaredType)) continue;
            listBuilder.add(subStmtContext);
        }
        return listBuilder.build();
    }

    public static <A, D extends DeclaredStatement<A>> Collection<StmtContext<A, D, ?>> findAllEffectiveSubstatements(StmtContext<?, ?, ?> stmtContext, Class<D> type) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.effectiveSubstatements()) {
            if (!subStmtContext.producesDeclared(type)) continue;
            listBuilder.add(subStmtContext);
        }
        return listBuilder.build();
    }

    public static <A, D extends DeclaredStatement<A>> Collection<StmtContext<A, D, ?>> findAllSubstatements(StmtContext<?, ?, ?> stmtContext, Class<D> type) {
        return ImmutableList.builder().addAll(StmtContextUtils.findAllDeclaredSubstatements(stmtContext, type)).addAll(StmtContextUtils.findAllEffectiveSubstatements(stmtContext, type)).build();
    }

    public static <A, D extends DeclaredStatement<A>> StmtContext<A, ?, ?> findFirstEffectiveSubstatement(StmtContext<?, ?, ?> stmtContext, Class<D> declaredType) {
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.effectiveSubstatements()) {
            if (!subStmtContext.producesDeclared(declaredType)) continue;
            return subStmtContext;
        }
        return null;
    }

    public static <D extends DeclaredStatement<?>> StmtContext<?, ?, ?> findFirstDeclaredSubstatementOnSublevel(StmtContext<?, ?, ?> stmtContext, Class<? super D> declaredType, int sublevel) {
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.declaredSubstatements()) {
            StmtContext<?, ?, ?> result;
            if (sublevel == 1 && subStmtContext.producesDeclared(declaredType)) {
                return subStmtContext;
            }
            if (sublevel <= 1 || (result = StmtContextUtils.findFirstDeclaredSubstatementOnSublevel(subStmtContext, declaredType, --sublevel)) == null) continue;
            return result;
        }
        return null;
    }

    public static <D extends DeclaredStatement<?>> StmtContext<?, ?, ?> findDeepFirstDeclaredSubstatement(StmtContext<?, ?, ?> stmtContext, Class<? super D> declaredType) {
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.declaredSubstatements()) {
            if (subStmtContext.producesDeclared(declaredType)) {
                return subStmtContext;
            }
            StmtContext<?, ?, ?> result = StmtContextUtils.findDeepFirstDeclaredSubstatement(subStmtContext, declaredType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static boolean isInExtensionBody(StmtContext<?, ?, ?> stmtCtx) {
        StmtContext<?, ?, ?> current = stmtCtx;
        StmtContext<?, ?, ?> parent;
        while ((parent = current.coerceParentContext()).getParentContext() != null) {
            if (StmtContextUtils.isUnknownStatement(parent)) {
                return true;
            }
            current = parent;
        }
        return false;
    }

    public static boolean isUnknownStatement(StmtContext<?, ?, ?> stmtCtx) {
        return UnknownStatement.class.isAssignableFrom(stmtCtx.publicDefinition().getDeclaredRepresentationClass());
    }

    public static boolean evaluateIfFeatures(@NonNull StmtContext<?, ?, ?> stmt) {
        FeatureSet supportedFeatures = stmt.namespaceItem(ParserNamespaces.SUPPORTED_FEATURES, Empty.value());
        return supportedFeatures == null || StmtContextUtils.checkFeatureSupport(stmt, supportedFeatures);
    }

    public static boolean checkFeatureSupport(StmtContext<?, ?, ?> stmtContext, FeatureSet supportedFeatures) {
        boolean isSupported = false;
        boolean containsIfFeature = false;
        for (StmtContext<?, ?, ?> stmt : stmtContext.declaredSubstatements()) {
            if (!YangStmtMapping.IF_FEATURE.equals((Object)stmt.publicDefinition())) continue;
            containsIfFeature = true;
            IfFeatureExpr argument = (IfFeatureExpr)stmt.getArgument();
            if (argument.test(supportedFeatures)) {
                isSupported = true;
                continue;
            }
            isSupported = false;
            break;
        }
        return !containsIfFeature || isSupported;
    }

    public static boolean isPresenceContainer(StmtContext<?, ?, ?> stmtCtx) {
        return stmtCtx.publicDefinition() == YangStmtMapping.CONTAINER && StmtContextUtils.containsPresenceSubStmt(stmtCtx);
    }

    public static boolean isNonPresenceContainer(StmtContext<?, ?, ?> stmtCtx) {
        return stmtCtx.publicDefinition() == YangStmtMapping.CONTAINER && !StmtContextUtils.containsPresenceSubStmt(stmtCtx);
    }

    private static boolean containsPresenceSubStmt(StmtContext<?, ?, ?> stmtCtx) {
        return stmtCtx.hasSubstatement(PresenceEffectiveStatement.class);
    }

    public static boolean isMandatoryNode(StmtContext<?, ?, ?> stmtCtx) {
        StatementDefinition statementDefinition = stmtCtx.publicDefinition();
        if (statementDefinition instanceof YangStmtMapping) {
            YangStmtMapping mapping = (YangStmtMapping)statementDefinition;
            return switch (mapping) {
                case YangStmtMapping.LEAF, YangStmtMapping.CHOICE, YangStmtMapping.ANYXML -> Boolean.TRUE.equals(StmtContextUtils.firstSubstatementAttributeOf(stmtCtx, MandatoryStatement.class));
                case YangStmtMapping.LIST, YangStmtMapping.LEAF_LIST -> {
                    Integer minElements = (Integer)StmtContextUtils.firstSubstatementAttributeOf(stmtCtx, MinElementsStatement.class);
                    if (minElements != null && minElements > 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return false;
    }

    public static boolean isNotMandatoryNodeOfType(StmtContext<?, ?, ?> stmtCtx, StatementDefinition stmtDef) {
        return stmtCtx.publicDefinition().equals(stmtDef) && !StmtContextUtils.isMandatoryNode(stmtCtx);
    }

    public static boolean hasAncestorOfType(StmtContext<?, ?, ?> stmt, Collection<StatementDefinition> ancestorTypes) {
        Objects.requireNonNull(ancestorTypes);
        for (StmtContext<?, ?, ?> current = stmt.getParentContext(); current != null; current = current.getParentContext()) {
            if (!ancestorTypes.contains(current.publicDefinition())) continue;
            return true;
        }
        return false;
    }

    public static void validateNoKeylessListAncestorOf(final StmtContext.Mutable<?, ?, ?> stmt, final String name) {
        Objects.requireNonNull(stmt);
        ArrayList<StmtContext> incomplete = new ArrayList<StmtContext>(0);
        StmtContext current = stmt.coerceParentContext();
        StmtContext parent = current.getParentContext();
        while (parent != null) {
            if (YangStmtMapping.LIST == current.publicDefinition() && !current.hasSubstatement(KeyEffectiveStatement.class)) {
                if (ModelProcessingPhase.FULL_DECLARATION.isCompletedBy(current.getCompletedPhase())) {
                    throw new SourceException(stmt, "%s %s is defined within a list that has no key statement", name, stmt.argument());
                }
                incomplete.add(current);
            }
            current = parent;
            parent = current.getParentContext();
        }
        for (final StmtContext.Mutable mutable : incomplete) {
            ModelActionBuilder action = mutable.newInferenceAction(ModelProcessingPhase.FULL_DECLARATION);
            action.apply(new ModelActionBuilder.InferenceAction(){

                @Override
                public void apply(ModelActionBuilder.InferenceContext ctx) {
                    if (!mutable.hasSubstatement(KeyEffectiveStatement.class)) {
                        throw new SourceException((CommonStmtCtx)stmt, "%s %s is defined within a list that has no key statement", name, stmt.argument());
                    }
                }

                @Override
                public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                    throw new VerifyException("Should never happen");
                }
            });
        }
    }

    public static boolean hasParentOfType(StmtContext<?, ?, ?> ctx, StatementDefinition parentType) {
        Objects.requireNonNull(parentType);
        StmtContext<?, ?, ?> parentContext = ctx.getParentContext();
        return parentContext != null && parentType.equals(parentContext.publicDefinition());
    }

    public static void validateIfFeatureAndWhenOnListKeys(StmtContext<?, ?, ?> ctx) {
        if (!StmtContextUtils.isRelevantForIfFeatureAndWhenOnListKeysCheck(ctx)) {
            return;
        }
        StmtContext<?, ?, ?> listStmtCtx = ctx.coerceParentContext();
        StmtContext keyStmtCtx = StmtContextUtils.findFirstDeclaredSubstatement(listStmtCtx, KeyStatement.class);
        if (YangStmtMapping.LEAF.equals((Object)ctx.publicDefinition())) {
            if (StmtContextUtils.isListKey(ctx, keyStmtCtx)) {
                StmtContextUtils.disallowIfFeatureAndWhenOnListKeys(ctx);
            }
        } else if (YangStmtMapping.USES.equals((Object)ctx.publicDefinition())) {
            StmtContextUtils.findAllEffectiveSubstatements(listStmtCtx, LeafStatement.class).forEach(leafStmtCtx -> {
                if (StmtContextUtils.isListKey(leafStmtCtx, keyStmtCtx)) {
                    StmtContextUtils.disallowIfFeatureAndWhenOnListKeys(leafStmtCtx);
                }
            });
        }
    }

    private static boolean isRelevantForIfFeatureAndWhenOnListKeysCheck(StmtContext<?, ?, ?> ctx) {
        return YangVersion.VERSION_1_1.equals((Object)ctx.yangVersion()) && StmtContextUtils.hasParentOfType(ctx, (StatementDefinition)YangStmtMapping.LIST) && StmtContextUtils.findFirstDeclaredSubstatement(ctx.coerceParentContext(), KeyStatement.class) != null;
    }

    private static boolean isListKey(StmtContext<?, ?, ?> leafStmtCtx, StmtContext<Set<QName>, ?, ?> keyStmtCtx) {
        return ((Set)keyStmtCtx.getArgument()).contains(leafStmtCtx.argument());
    }

    private static void disallowIfFeatureAndWhenOnListKeys(StmtContext<?, ?, ?> leafStmtCtx) {
        leafStmtCtx.allSubstatements().forEach(leafSubstmtCtx -> {
            StatementDefinition statementDef = leafSubstmtCtx.publicDefinition();
            SourceException.throwIf(YangStmtMapping.IF_FEATURE.equals((Object)statementDef) || YangStmtMapping.WHEN.equals((Object)statementDef), leafStmtCtx, "%s statement is not allowed in %s leaf statement which is specified as a list key.", statementDef.getStatementName(), leafStmtCtx.argument());
        });
    }

    public static @NonNull QName qnameFromArgument(StmtContext<?, ?, ?> ctx, String value) {
        QNameModule qnameModule;
        String localName;
        if (Strings.isNullOrEmpty((String)value)) {
            return ctx.publicDefinition().getStatementName();
        }
        String[] namesParts = value.split(":");
        switch (namesParts.length) {
            case 1: {
                localName = namesParts[0];
                qnameModule = StmtContextUtils.getModuleQName(ctx);
                break;
            }
            default: {
                String prefix = namesParts[0];
                localName = namesParts[1];
                qnameModule = StmtContextUtils.getModuleQNameByPrefix(ctx, prefix);
                if (qnameModule == null && StmtContextUtils.isUnknownStatement(ctx)) {
                    localName = value;
                    qnameModule = StmtContextUtils.getModuleQName(ctx);
                }
                if (qnameModule != null || ctx.history().getLastOperation() != CopyType.ADDED_BY_AUGMENTATION) break;
                ctx = ctx.getOriginalCtx().orElse(null);
                qnameModule = StmtContextUtils.getModuleQNameByPrefix(ctx, prefix);
            }
        }
        return StmtContextUtils.internedQName(ctx, InferenceException.throwIfNull(qnameModule, ctx, "Cannot resolve QNameModule for '%s'", value), localName);
    }

    public static @NonNull QName parseIdentifier(@NonNull StmtContext<?, ?, ?> ctx, String str) {
        SourceException.throwIf(str.isEmpty(), ctx, "Identifier may not be an empty string", new Object[0]);
        return StmtContextUtils.internedQName(ctx, str);
    }

    public static @NonNull QName parseNodeIdentifier(@NonNull StmtContext<?, ?, ?> ctx, String prefix, String localName) {
        return StmtContextUtils.internedQName(ctx, InferenceException.throwIfNull(StmtContextUtils.getModuleQNameByPrefix(ctx, prefix), ctx, "Cannot resolve QNameModule for '%s'", prefix), localName);
    }

    public static @NonNull QName parseNodeIdentifier(@NonNull StmtContext<?, ?, ?> ctx, String str) {
        SourceException.throwIf(str.isEmpty(), ctx, "Node identifier may not be an empty string", new Object[0]);
        int colon = str.indexOf(58);
        if (colon == -1) {
            return StmtContextUtils.internedQName(ctx, str);
        }
        String prefix = str.substring(0, colon);
        SourceException.throwIf(prefix.isEmpty(), ctx, "String '%s' has an empty prefix", str);
        String localName = str.substring(colon + 1);
        SourceException.throwIf(localName.isEmpty(), ctx, "String '%s' has an empty identifier", str);
        return StmtContextUtils.parseNodeIdentifier(ctx, prefix, localName);
    }

    private static @NonNull QName internedQName(@NonNull StmtContext<?, ?, ?> ctx, String localName) {
        return StmtContextUtils.internedQName(ctx, StmtContextUtils.getModuleQName(ctx), localName);
    }

    private static @NonNull QName internedQName(@NonNull CommonStmtCtx ctx, QNameModule module, String localName) {
        QName template;
        try {
            template = QName.create((QNameModule)module, (String)localName);
        }
        catch (IllegalArgumentException e) {
            throw new SourceException(ctx, (Throwable)e, "Invalid identifier '%s'", localName);
        }
        return template.intern();
    }

    public static @NonNull QNameModule getModuleQName(@NonNull StmtContext<?, ?, ?> ctx) {
        return StmtContextUtils.getModuleQName(ctx.getRoot());
    }

    public static @NonNull QNameModule getModuleQName(@NonNull RootStmtContext<?, ?, ?> ctx) {
        if (ctx.producesDeclared(ModuleStatement.class)) {
            return StmtContextUtils.lookupModuleQName(ctx, ctx);
        }
        if (ctx.producesDeclared(SubmoduleStatement.class)) {
            Map<String, StmtContext<?, ?, ?>> belongsTo = ctx.namespace(ParserNamespaces.BELONGSTO_PREFIX_TO_MODULECTX);
            if (belongsTo == null || belongsTo.isEmpty()) {
                throw new IllegalArgumentException(ctx + " does not have belongs-to linkage resolved");
            }
            return StmtContextUtils.lookupModuleQName(ctx, belongsTo.values().iterator().next());
        }
        throw new IllegalArgumentException("Unsupported root " + ctx);
    }

    private static @NonNull QNameModule lookupModuleQName(NamespaceStmtCtx storage, StmtContext<?, ?, ?> module) {
        QNameModule ret = storage.namespaceItem(ParserNamespaces.MODULECTX_TO_QNAME, module);
        if (ret == null) {
            throw new IllegalArgumentException("Failed to look up QNameModule for " + module + " in " + storage);
        }
        return ret;
    }

    public static QNameModule getModuleQNameByPrefix(StmtContext<?, ?, ?> ctx, String prefix) {
        RootStmtContext<?, ?, ?> root = ctx.getRoot();
        StmtContext<?, ?, ?> importedModule = root.namespaceItem(ParserNamespaces.IMPORT_PREFIX_TO_MODULECTX, prefix);
        QNameModule qnameModule = ctx.namespaceItem(ParserNamespaces.MODULECTX_TO_QNAME, importedModule);
        if (qnameModule != null) {
            return qnameModule;
        }
        if (root.producesDeclared(SubmoduleStatement.class)) {
            return ctx.namespaceItem(ParserNamespaces.MODULE_NAME_TO_QNAME, root.namespaceItem(ParserNamespaces.BELONGSTO_PREFIX_TO_MODULE_NAME, prefix));
        }
        return null;
    }

    public static Optional<Revision> getLatestRevision(Iterable<? extends StmtContext<?, ?, ?>> subStmts) {
        Revision revision = null;
        for (StmtContext<?, ?, ?> subStmt : subStmts) {
            if (!subStmt.producesDeclared(RevisionStatement.class)) continue;
            if (revision == null && subStmt.argument() != null) {
                revision = (Revision)subStmt.argument();
                continue;
            }
            Revision subArg = (Revision)subStmt.argument();
            if (subArg == null || subArg.compareTo(revision) <= 0) continue;
            revision = subArg;
        }
        return Optional.ofNullable(revision);
    }
}

