/*
 * Copyright (c) 2020 PANTHEON.tech, s.r.o. and others.  All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import static java.util.Objects.requireNonNull;

import com.google.common.base.MoreObjects;
import java.io.Serial;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.Identifier;

/**
 * {@link ParserNamespace} serves as common superclass for namespaces used during parser operation. Each such namespace,
 * is a type-captured subclass. This type capture of namespace allows for handy type-safe reading methods such as
 * {@link NamespaceStmtCtx#namespaceItem(ParserNamespace, Object)} and still allows introduction of new namespaces
 * without need to change APIs.
 *
 * @param <K> Identifier type
 * @param <V> Value type
 */
@NonNullByDefault
public final class ParserNamespace<K, V> implements Identifier {
    @Serial
    private static final long serialVersionUID = 1L;

    private final String name;

    // FIXME: hide this constructor once we collapse the type hierarchy
    public ParserNamespace(final String name) {
        this.name = requireNonNull(name);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", name).toString();
    }
}
