/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public abstract class AbstractDeclaredStatement<A>
implements DeclaredStatement<A> {
    private final A argument;
    private final String rawArgument;
    private final ImmutableList<? extends DeclaredStatement<?>> substatements;
    private final StatementDefinition definition;
    private final StatementSource source;

    protected AbstractDeclaredStatement(StmtContext<A, ?, ?> context) {
        this.rawArgument = context.rawStatementArgument();
        this.argument = context.getStatementArgument();
        this.source = context.getStatementSource();
        this.definition = context.getPublicDefinition();
        this.substatements = ImmutableList.copyOf((Collection)Collections2.transform(context.declaredSubstatements(), StmtContext::buildDeclared));
    }

    @Deprecated
    protected final <S extends DeclaredStatement<?>> S firstDeclared(Class<S> type) {
        return (S)((DeclaredStatement)this.findFirstDeclaredSubstatement(type).orElse(null));
    }

    public String rawArgument() {
        return this.rawArgument;
    }

    public A argument() {
        return this.argument;
    }

    @Nonnull
    public StatementDefinition statementDefinition() {
        return this.definition;
    }

    @Nonnull
    public Collection<? extends DeclaredStatement<?>> declaredSubstatements() {
        return this.substatements;
    }

    @Nonnull
    public StatementSource getStatementSource() {
        return this.source;
    }

    @Deprecated
    protected final <S extends DeclaredStatement<?>> Collection<? extends S> allDeclared(Class<S> type) {
        return this.declaredSubstatements(type);
    }
}

