/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatementSupportBundle
implements Immutable,
NamespaceBehaviour.Registry {
    private static final StatementSupportBundle EMPTY = new StatementSupportBundle(null, null, ImmutableMap.of(), ImmutableMap.of(), ImmutableTable.of());
    private final StatementSupportBundle parent;
    private final ImmutableMap<QName, StatementSupport<?, ?, ?>> commonDefinitions;
    private final ImmutableTable<YangVersion, QName, StatementSupport<?, ?, ?>> versionSpecificDefinitions;
    private final ImmutableMap<Class<?>, NamespaceBehaviour<?, ?, ?>> namespaceDefinitions;
    private final Set<YangVersion> supportedVersions;

    private StatementSupportBundle(StatementSupportBundle parent, Set<YangVersion> supportedVersions, ImmutableMap<QName, StatementSupport<?, ?, ?>> commonStatements, ImmutableMap<Class<?>, NamespaceBehaviour<?, ?, ?>> namespaces, ImmutableTable<YangVersion, QName, StatementSupport<?, ?, ?>> versionSpecificStatements) {
        this.parent = parent;
        this.supportedVersions = supportedVersions;
        this.commonDefinitions = commonStatements;
        this.namespaceDefinitions = namespaces;
        this.versionSpecificDefinitions = versionSpecificStatements;
    }

    public ImmutableMap<QName, StatementSupport<?, ?, ?>> getCommonDefinitions() {
        return this.commonDefinitions;
    }

    public ImmutableMap<QName, StatementSupport<?, ?, ?>> getDefinitionsSpecificForVersion(YangVersion version) {
        return this.versionSpecificDefinitions.row((Object)version);
    }

    public ImmutableTable<YangVersion, QName, StatementSupport<?, ?, ?>> getAllVersionSpecificDefinitions() {
        return this.versionSpecificDefinitions;
    }

    public ImmutableMap<Class<?>, NamespaceBehaviour<?, ?, ?>> getNamespaceDefinitions() {
        return this.namespaceDefinitions;
    }

    public static Builder builder(Set<YangVersion> supportedVersions) {
        return new Builder(supportedVersions, EMPTY);
    }

    public static Builder derivedFrom(StatementSupportBundle parent) {
        return new Builder(parent.getSupportedVersions(), parent);
    }

    public Set<YangVersion> getSupportedVersions() {
        return this.supportedVersions;
    }

    @Override
    public <K, V, N extends IdentifierNamespace<K, V>> NamespaceBehaviour<K, V, N> getNamespaceBehaviour(Class<N> namespace) {
        NamespaceBehaviour potential = (NamespaceBehaviour)this.namespaceDefinitions.get(namespace);
        if (potential != null) {
            Preconditions.checkState((boolean)namespace.equals(potential.getIdentifier()));
            return potential;
        }
        if (this.parent != null) {
            return this.parent.getNamespaceBehaviour(namespace);
        }
        return null;
    }

    public <K, V, N extends IdentifierNamespace<K, V>> boolean hasNamespaceBehaviour(Class<N> namespace) {
        if (this.namespaceDefinitions.containsKey(namespace)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.hasNamespaceBehaviour(namespace);
        }
        return false;
    }

    public StatementSupport<?, ?, ?> getStatementDefinition(YangVersion version, QName stmtName) {
        StatementSupport<?, ?, ?> result = this.getVersionSpecificStatementDefinition(version, stmtName);
        if (result == null) {
            result = this.getCommonStatementDefinition(stmtName);
        }
        return result;
    }

    private StatementSupport<?, ?, ?> getCommonStatementDefinition(QName stmtName) {
        StatementSupport potential = (StatementSupport)this.commonDefinitions.get((Object)stmtName);
        if (potential != null) {
            return potential;
        }
        if (this.parent != null) {
            return this.parent.getCommonStatementDefinition(stmtName);
        }
        return null;
    }

    private StatementSupport<?, ?, ?> getVersionSpecificStatementDefinition(YangVersion version, QName stmtName) {
        StatementSupport potential = (StatementSupport)this.versionSpecificDefinitions.get((Object)version, (Object)stmtName);
        if (potential != null) {
            return potential;
        }
        if (this.parent != null) {
            return this.parent.getVersionSpecificStatementDefinition(version, stmtName);
        }
        return null;
    }

    public static class Builder
    implements org.opendaylight.yangtools.concepts.Builder<StatementSupportBundle> {
        private static final Logger LOG = LoggerFactory.getLogger(Builder.class);
        private final Map<QName, StatementSupport<?, ?, ?>> commonStatements = new HashMap();
        private final Table<YangVersion, QName, StatementSupport<?, ?, ?>> versionSpecificStatements = HashBasedTable.create();
        private final Map<Class<?>, NamespaceBehaviour<?, ?, ?>> namespaces = new HashMap();
        private final Set<YangVersion> supportedVersions;
        private StatementSupportBundle parent;

        Builder(Set<YangVersion> supportedVersions, StatementSupportBundle parent) {
            this.parent = Objects.requireNonNull(parent);
            this.supportedVersions = ImmutableSet.copyOf(supportedVersions);
        }

        public Builder addSupport(StatementSupport<?, ?, ?> support) {
            QName identifier = support.getStatementName();
            this.checkNoParentDefinition(identifier);
            Preconditions.checkState((!this.commonStatements.containsKey(identifier) ? 1 : 0) != 0, (String)"Statement %s already defined in common statement bundle.", (Object)identifier);
            this.commonStatements.put(identifier, support);
            return this;
        }

        public <K, V, N extends IdentifierNamespace<K, V>> Builder addSupport(NamespaceBehaviour<K, V, N> namespaceSupport) {
            Object identifier = namespaceSupport.getIdentifier();
            Preconditions.checkState((!this.namespaces.containsKey(identifier) ? 1 : 0) != 0);
            Preconditions.checkState((!this.parent.hasNamespaceBehaviour(identifier) ? 1 : 0) != 0);
            this.namespaces.put((Class<?>)identifier, namespaceSupport);
            return this;
        }

        public Builder addVersionSpecificSupport(YangVersion version, StatementSupport<?, ?, ?> definition) {
            Preconditions.checkArgument((boolean)this.supportedVersions.contains(Objects.requireNonNull(version)));
            QName identifier = definition.getStatementName();
            Preconditions.checkState((!this.commonStatements.containsKey(identifier) ? 1 : 0) != 0, (String)"Statement %s already defined in common statement bundle.", (Object)identifier);
            Preconditions.checkState((!this.versionSpecificStatements.contains((Object)version, (Object)identifier) ? 1 : 0) != 0, (String)"Statement %s already defined for version %s.", (Object)identifier, (Object)version);
            this.checkNoParentDefinition(identifier);
            Preconditions.checkState((this.parent.getVersionSpecificStatementDefinition(version, identifier) == null ? 1 : 0) != 0, (String)"Statement %s already defined for version %s in parent's statement bundle.", (Object)identifier, (Object)version);
            this.versionSpecificStatements.put((Object)version, (Object)identifier, definition);
            return this;
        }

        public Set<YangVersion> getSupportedVersions() {
            return this.supportedVersions;
        }

        public Builder setParent(StatementSupportBundle parent) {
            this.parent = parent;
            return this;
        }

        public Builder overrideSupport(StatementSupport<?, ?, ?> support) {
            QName identifier = support.getStatementName();
            this.checkNoParentDefinition(identifier);
            StatementSupport<?, ?, ?> previousSupport = this.commonStatements.replace(identifier, support);
            Preconditions.checkState((previousSupport != null ? 1 : 0) != 0, (String)"Statement %s was not previously defined", (Object)identifier);
            LOG.debug("Changed statement {} support from {} to {}", new Object[]{identifier, previousSupport, support});
            return this;
        }

        public StatementSupportBundle build() {
            Preconditions.checkState((this.parent != null ? 1 : 0) != 0, (Object)"Parent must not be null");
            return new StatementSupportBundle(this.parent, this.supportedVersions, ImmutableMap.copyOf(this.commonStatements), ImmutableMap.copyOf(this.namespaces), ImmutableTable.copyOf(this.versionSpecificStatements));
        }

        private void checkNoParentDefinition(QName identifier) {
            Preconditions.checkState((this.parent.getCommonStatementDefinition(identifier) == null ? 1 : 0) != 0, (String)"Statement %s is defined in parent's common statement bundle", (Object)identifier);
        }
    }
}

