/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyHistory;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.MutableStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementNamespace;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public interface StmtContext<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>> {
    @Nonnull
    public StatementSource getStatementSource();

    @Nonnull
    public StatementSourceReference getStatementSourceReference();

    @Nonnull
    public StatementDefinition getPublicDefinition();

    @Nullable
    public StmtContext<?, ?, ?> getParentContext();

    @Nullable
    public String rawStatementArgument();

    @Nullable
    public A getStatementArgument();

    @Nonnull
    public Optional<SchemaPath> getSchemaPath();

    public boolean isConfiguration();

    public boolean isEnabledSemanticVersioning();

    @Nonnull
    public <K, V, T extends K, N extends IdentifierNamespace<K, V>> V getFromNamespace(Class<N> var1, T var2);

    public <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAllFromNamespace(Class<N> var1);

    public <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAllFromCurrentStmtCtxNamespace(Class<N> var1);

    @Nonnull
    public StmtContext<?, ?, ?> getRoot();

    @Nonnull
    public Collection<? extends StmtContext<?, ?, ?>> declaredSubstatements();

    @Nonnull
    public Collection<? extends StmtContext<?, ?, ?>> effectiveSubstatements();

    default public Iterable<? extends StmtContext<?, ?, ?>> allSubstatements() {
        return Iterables.concat(this.declaredSubstatements(), this.effectiveSubstatements());
    }

    default public Stream<? extends StmtContext<?, ?, ?>> allSubstatementsStream() {
        return Streams.concat((Stream[])new Stream[]{this.declaredSubstatements().stream(), this.effectiveSubstatements().stream()});
    }

    public D buildDeclared();

    public E buildEffective();

    public boolean isSupportedToBuildEffective();

    public Collection<? extends StmtContext<?, ?, ?>> getEffectOfStatement();

    public CopyHistory getCopyHistory();

    public boolean isSupportedByFeatures();

    public Optional<StmtContext<?, ?, ?>> getOriginalCtx();

    public ModelProcessingPhase getCompletedPhase();

    @Nonnull
    public YangVersion getRootVersion();

    public static interface Mutable<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
    extends StmtContext<A, D, E> {
        @Override
        public Mutable<?, ?, ?> getParentContext();

        public <K, V, T extends K, U extends V, N extends IdentifierNamespace<K, V>> void addToNs(Class<N> var1, T var2, U var3);

        @Override
        @Nonnull
        public Mutable<?, ?, ?> getRoot();

        public <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> Mutable<X, Y, Z> childCopyOf(StmtContext<X, Y, Z> var1, CopyType var2, @Nullable QNameModule var3);

        default public <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> Mutable<X, Y, Z> childCopyOf(StmtContext<X, Y, Z> stmt, CopyType type) {
            return this.childCopyOf(stmt, type, null);
        }

        @Nonnull
        public Collection<? extends Mutable<?, ?, ?>> mutableDeclaredSubstatements();

        @Nonnull
        public Collection<? extends Mutable<?, ?, ?>> mutableEffectiveSubstatements();

        @Nonnull
        public ModelActionBuilder newInferenceAction(@Nonnull ModelProcessingPhase var1);

        public <K, KT extends K, N extends StatementNamespace<K, ?, ?>> void addContext(Class<N> var1, KT var2, StmtContext<?, ?, ?> var3);

        public void setRootVersion(YangVersion var1);

        public void addMutableStmtToSeal(MutableStatement var1);

        public void addRequiredSource(SourceIdentifier var1);

        public void addAsEffectOfStatement(StmtContext<?, ?, ?> var1);

        public void addAsEffectOfStatement(Collection<? extends StmtContext<?, ?, ?>> var1);

        public void setRootIdentifier(SourceIdentifier var1);

        public void setIsSupportedToBuildEffective(boolean var1);

        public void setCompletedPhase(ModelProcessingPhase var1);
    }
}

