/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BelongsToStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MinElementsStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PresenceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnknownStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnrecognizedStatement;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.QNameCacheNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.BelongsToPrefixToModuleName;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportPrefixToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNameToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class StmtContextUtils {
    private static final CharMatcher IDENTIFIER_START = CharMatcher.inRange((char)'A', (char)'Z').or(CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.is((char)'_'))).precomputed();
    private static final CharMatcher NOT_IDENTIFIER_PART = IDENTIFIER_START.or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"-.")).negate().precomputed();

    private StmtContextUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static <A, D extends DeclaredStatement<A>> A firstAttributeOf(Iterable<? extends StmtContext<?, ?, ?>> contexts, Class<D> declaredType) {
        for (StmtContext<?, ?, ?> ctx : contexts) {
            if (!StmtContextUtils.producesDeclared(ctx, declaredType)) continue;
            return (A)ctx.getStatementArgument();
        }
        return null;
    }

    public static <A, D extends DeclaredStatement<A>> A firstAttributeOf(StmtContext<?, ?, ?> ctx, Class<D> declaredType) {
        return StmtContextUtils.producesDeclared(ctx, declaredType) ? (A)ctx.getStatementArgument() : null;
    }

    public static <A, D extends DeclaredStatement<A>> A firstSubstatementAttributeOf(StmtContext<?, ?, ?> ctx, Class<D> declaredType) {
        return StmtContextUtils.firstAttributeOf(ctx.allSubstatements(), declaredType);
    }

    public static <A, D extends DeclaredStatement<A>> StmtContext<A, ?, ?> findFirstDeclaredSubstatement(StmtContext<?, ?, ?> stmtContext, Class<D> declaredType) {
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.declaredSubstatements()) {
            if (!StmtContextUtils.producesDeclared(subStmtContext, declaredType)) continue;
            return subStmtContext;
        }
        return null;
    }

    @SafeVarargs
    public static StmtContext<?, ?, ?> findFirstDeclaredSubstatement(StmtContext<?, ?, ?> stmtContext, int startIndex, Class<? extends DeclaredStatement<?>> ... types) {
        if (startIndex >= types.length) {
            return null;
        }
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.declaredSubstatements()) {
            if (!StmtContextUtils.producesDeclared(subStmtContext, types[startIndex])) continue;
            return startIndex + 1 == types.length ? subStmtContext : StmtContextUtils.findFirstDeclaredSubstatement(subStmtContext, ++startIndex, types);
        }
        return null;
    }

    public static <A, D extends DeclaredStatement<A>> Collection<StmtContext<A, D, ?>> findAllDeclaredSubstatements(StmtContext<?, ?, ?> stmtContext, Class<D> declaredType) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.declaredSubstatements()) {
            if (!StmtContextUtils.producesDeclared(subStmtContext, declaredType)) continue;
            listBuilder.add(subStmtContext);
        }
        return listBuilder.build();
    }

    public static <A, D extends DeclaredStatement<A>> Collection<StmtContext<A, D, ?>> findAllEffectiveSubstatements(StmtContext<?, ?, ?> stmtContext, Class<D> type) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.effectiveSubstatements()) {
            if (!StmtContextUtils.producesDeclared(subStmtContext, type)) continue;
            listBuilder.add(subStmtContext);
        }
        return listBuilder.build();
    }

    public static <A, D extends DeclaredStatement<A>> Collection<StmtContext<A, D, ?>> findAllSubstatements(StmtContext<?, ?, ?> stmtContext, Class<D> type) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.addAll(StmtContextUtils.findAllDeclaredSubstatements(stmtContext, type));
        listBuilder.addAll(StmtContextUtils.findAllEffectiveSubstatements(stmtContext, type));
        return listBuilder.build();
    }

    public static <A, D extends DeclaredStatement<A>> StmtContext<A, ?, ?> findFirstEffectiveSubstatement(StmtContext<?, ?, ?> stmtContext, Class<D> declaredType) {
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.effectiveSubstatements()) {
            if (!StmtContextUtils.producesDeclared(subStmtContext, declaredType)) continue;
            return subStmtContext;
        }
        return null;
    }

    public static <A, D extends DeclaredStatement<A>> StmtContext<A, ?, ?> findFirstSubstatement(StmtContext<?, ?, ?> stmtContext, Class<D> declaredType) {
        StmtContext<A, ?, ?> effectiveSubstatement = StmtContextUtils.findFirstEffectiveSubstatement(stmtContext, declaredType);
        return effectiveSubstatement != null ? effectiveSubstatement : StmtContextUtils.findFirstDeclaredSubstatement(stmtContext, declaredType);
    }

    public static <D extends DeclaredStatement<?>> StmtContext<?, ?, ?> findFirstDeclaredSubstatementOnSublevel(StmtContext<?, ?, ?> stmtContext, Class<D> declaredType, int sublevel) {
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.declaredSubstatements()) {
            StmtContext<?, ?, ?> result;
            if (sublevel == 1 && StmtContextUtils.producesDeclared(subStmtContext, declaredType)) {
                return subStmtContext;
            }
            if (sublevel <= 1 || (result = StmtContextUtils.findFirstDeclaredSubstatementOnSublevel(subStmtContext, declaredType, --sublevel)) == null) continue;
            return result;
        }
        return null;
    }

    public static <D extends DeclaredStatement<?>> StmtContext<?, ?, ?> findDeepFirstDeclaredSubstatement(StmtContext<?, ?, ?> stmtContext, Class<D> declaredType) {
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.declaredSubstatements()) {
            if (StmtContextUtils.producesDeclared(subStmtContext, declaredType)) {
                return subStmtContext;
            }
            StmtContext<?, ?, ?> result = StmtContextUtils.findDeepFirstDeclaredSubstatement(subStmtContext, declaredType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static boolean producesDeclared(StmtContext<?, ?, ?> ctx, Class<? extends DeclaredStatement<?>> type) {
        return type.isAssignableFrom(ctx.getPublicDefinition().getDeclaredRepresentationClass());
    }

    public static boolean isInExtensionBody(StmtContext<?, ?, ?> stmtCtx) {
        StmtContext<?, ?, ?> current = stmtCtx;
        while (current.getParentContext().getParentContext() != null) {
            if (!StmtContextUtils.isUnknownStatement(current = current.getParentContext())) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnknownStatement(StmtContext<?, ?, ?> stmtCtx) {
        return UnknownStatement.class.isAssignableFrom(stmtCtx.getPublicDefinition().getDeclaredRepresentationClass());
    }

    public static boolean isUnrecognizedStatement(StmtContext<?, ?, ?> stmtCtx) {
        return UnrecognizedStatement.class.isAssignableFrom(stmtCtx.getPublicDefinition().getDeclaredRepresentationClass());
    }

    public static boolean checkFeatureSupport(StmtContext<?, ?, ?> stmtContext, Set<QName> supportedFeatures) {
        boolean isSupported = false;
        boolean containsIfFeature = false;
        for (StmtContext<?, ?, ?> stmt : stmtContext.declaredSubstatements()) {
            if (!YangStmtMapping.IF_FEATURE.equals((Object)stmt.getPublicDefinition())) continue;
            containsIfFeature = true;
            if (((Predicate)stmt.getStatementArgument()).test(supportedFeatures)) {
                isSupported = true;
                continue;
            }
            isSupported = false;
            break;
        }
        return !containsIfFeature || isSupported;
    }

    public static boolean isPresenceContainer(StmtContext<?, ?, ?> stmtCtx) {
        return stmtCtx.getPublicDefinition() == YangStmtMapping.CONTAINER && StmtContextUtils.containsPresenceSubStmt(stmtCtx);
    }

    public static boolean isNonPresenceContainer(StmtContext<?, ?, ?> stmtCtx) {
        return stmtCtx.getPublicDefinition() == YangStmtMapping.CONTAINER && !StmtContextUtils.containsPresenceSubStmt(stmtCtx);
    }

    private static boolean containsPresenceSubStmt(StmtContext<?, ?, ?> stmtCtx) {
        return StmtContextUtils.findFirstSubstatement(stmtCtx, PresenceStatement.class) != null;
    }

    public static boolean isMandatoryNode(StmtContext<?, ?, ?> stmtCtx) {
        if (!(stmtCtx.getPublicDefinition() instanceof YangStmtMapping)) {
            return false;
        }
        switch ((YangStmtMapping)stmtCtx.getPublicDefinition()) {
            case LEAF: 
            case CHOICE: 
            case ANYXML: {
                return Boolean.TRUE.equals(StmtContextUtils.firstSubstatementAttributeOf(stmtCtx, MandatoryStatement.class));
            }
            case LIST: 
            case LEAF_LIST: {
                Integer minElements = (Integer)StmtContextUtils.firstSubstatementAttributeOf(stmtCtx, MinElementsStatement.class);
                return minElements != null && minElements > 0;
            }
        }
        return false;
    }

    public static boolean isNotMandatoryNodeOfType(StmtContext<?, ?, ?> stmtCtx, StatementDefinition stmtDef) {
        return stmtCtx.getPublicDefinition().equals(stmtDef) && !StmtContextUtils.isMandatoryNode(stmtCtx);
    }

    public static boolean hasAncestorOfType(StmtContext<?, ?, ?> ctx, Collection<StatementDefinition> ancestorTypes) {
        Objects.requireNonNull(ancestorTypes);
        for (StmtContext<?, ?, ?> current = ctx.getParentContext(); current != null; current = current.getParentContext()) {
            if (!ancestorTypes.contains(current.getPublicDefinition())) continue;
            return true;
        }
        return false;
    }

    public static <A, D extends DeclaredStatement<A>> boolean hasAncestorOfTypeWithChildOfType(StmtContext<?, ?, ?> ctx, StatementDefinition ancestorType, StatementDefinition ancestorChildType) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(ancestorType);
        Objects.requireNonNull(ancestorChildType);
        StmtContext<?, ?, ?> current = ctx.getParentContext();
        StmtContext<?, ?, ?> parent = current.getParentContext();
        while (parent != null) {
            Class ancestorChildTypeClass;
            if (ancestorType.equals(current.getPublicDefinition()) && StmtContextUtils.findFirstSubstatement(current, ancestorChildTypeClass = ancestorChildType.getDeclaredRepresentationClass()) == null) {
                return false;
            }
            current = parent;
            parent = current.getParentContext();
        }
        return true;
    }

    public static boolean hasParentOfType(StmtContext<?, ?, ?> ctx, StatementDefinition parentType) {
        Objects.requireNonNull(parentType);
        StmtContext<?, ?, ?> parentContext = ctx.getParentContext();
        return parentContext != null ? parentType.equals(parentContext.getPublicDefinition()) : false;
    }

    public static void validateIfFeatureAndWhenOnListKeys(StmtContext<?, ?, ?> ctx) {
        if (!StmtContextUtils.isRelevantForIfFeatureAndWhenOnListKeysCheck(ctx)) {
            return;
        }
        StmtContext<?, ?, ?> listStmtCtx = ctx.getParentContext();
        StmtContext keyStmtCtx = StmtContextUtils.findFirstDeclaredSubstatement(listStmtCtx, KeyStatement.class);
        if (YangStmtMapping.LEAF.equals((Object)ctx.getPublicDefinition())) {
            if (StmtContextUtils.isListKey(ctx, keyStmtCtx)) {
                StmtContextUtils.disallowIfFeatureAndWhenOnListKeys(ctx);
            }
        } else if (YangStmtMapping.USES.equals((Object)ctx.getPublicDefinition())) {
            StmtContextUtils.findAllEffectiveSubstatements(listStmtCtx, LeafStatement.class).forEach(leafStmtCtx -> {
                if (StmtContextUtils.isListKey(leafStmtCtx, keyStmtCtx)) {
                    StmtContextUtils.disallowIfFeatureAndWhenOnListKeys(leafStmtCtx);
                }
            });
        }
    }

    private static boolean isRelevantForIfFeatureAndWhenOnListKeysCheck(StmtContext<?, ?, ?> ctx) {
        return YangVersion.VERSION_1_1.equals((Object)ctx.getRootVersion()) && StmtContextUtils.hasParentOfType(ctx, (StatementDefinition)YangStmtMapping.LIST) && StmtContextUtils.findFirstDeclaredSubstatement(ctx.getParentContext(), KeyStatement.class) != null;
    }

    private static boolean isListKey(StmtContext<?, ?, ?> leafStmtCtx, StmtContext<Collection<SchemaNodeIdentifier>, ?, ?> keyStmtCtx) {
        for (SchemaNodeIdentifier keyIdentifier : keyStmtCtx.getStatementArgument()) {
            if (!leafStmtCtx.getStatementArgument().equals(keyIdentifier.getLastComponent())) continue;
            return true;
        }
        return false;
    }

    private static void disallowIfFeatureAndWhenOnListKeys(StmtContext<?, ?, ?> leafStmtCtx) {
        leafStmtCtx.allSubstatements().forEach(leafSubstmtCtx -> {
            StatementDefinition statementDef = leafSubstmtCtx.getPublicDefinition();
            SourceException.throwIf(YangStmtMapping.IF_FEATURE.equals((Object)statementDef) || YangStmtMapping.WHEN.equals((Object)statementDef), leafStmtCtx.getStatementSourceReference(), "%s statement is not allowed in %s leaf statement which is specified as a list key.", statementDef.getStatementName(), leafStmtCtx.getStatementArgument());
        });
    }

    public static QName qnameFromArgument(StmtContext<?, ?, ?> ctx, String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return ctx.getPublicDefinition().getStatementName();
        }
        QNameModule qnameModule = null;
        String localName = null;
        String[] namesParts = value.split(":");
        switch (namesParts.length) {
            case 1: {
                localName = namesParts[0];
                qnameModule = StmtContextUtils.getRootModuleQName(ctx);
                break;
            }
            default: {
                String prefix = namesParts[0];
                localName = namesParts[1];
                qnameModule = StmtContextUtils.getModuleQNameByPrefix(ctx, prefix);
                if (qnameModule == null && StmtContextUtils.isUnknownStatement(ctx)) {
                    localName = value;
                    qnameModule = StmtContextUtils.getRootModuleQName(ctx);
                }
                if (qnameModule != null || ctx.getCopyHistory().getLastOperation() != CopyType.ADDED_BY_AUGMENTATION) break;
                ctx = ctx.getOriginalCtx().orElse(null);
                qnameModule = StmtContextUtils.getModuleQNameByPrefix(ctx, prefix);
            }
        }
        return StmtContextUtils.internedQName(ctx, InferenceException.throwIfNull(qnameModule, ctx.getStatementSourceReference(), "Cannot resolve QNameModule for '%s'", value), localName);
    }

    public static QName parseIdentifier(StmtContext<?, ?, ?> ctx, String str) {
        SourceException.throwIf(str.isEmpty(), ctx.getStatementSourceReference(), "Identifier may not be an empty string", new Object[0]);
        StmtContextUtils.checkIdentifierString(ctx, str);
        return StmtContextUtils.internedQName(ctx, str);
    }

    public static QName parseNodeIdentifier(StmtContext<?, ?, ?> ctx, String str) {
        QNameModule origModule;
        Optional<StmtContext<?, ?, ?>> optOrigCtx;
        SourceException.throwIf(str.isEmpty(), ctx.getStatementSourceReference(), "Node identifier may not be an empty string", new Object[0]);
        int colon = str.indexOf(58);
        if (colon == -1) {
            StmtContextUtils.checkIdentifierString(ctx, str);
            return StmtContextUtils.internedQName(ctx, str);
        }
        String prefix = str.substring(0, colon);
        SourceException.throwIf(prefix.isEmpty(), ctx.getStatementSourceReference(), "String '%s' has an empty prefix", str);
        String localName = str.substring(colon + 1);
        SourceException.throwIf(localName.isEmpty(), ctx.getStatementSourceReference(), "String '%s' has an empty identifier", str);
        StmtContextUtils.checkIdentifierString(ctx, localName);
        QNameModule module = StmtContextUtils.getModuleQNameByPrefix(ctx, prefix);
        if (module != null) {
            return StmtContextUtils.internedQName(ctx, module, localName);
        }
        if (ctx.getCopyHistory().getLastOperation() == CopyType.ADDED_BY_AUGMENTATION && (optOrigCtx = ctx.getOriginalCtx()).isPresent() && (origModule = StmtContextUtils.getModuleQNameByPrefix(ctx = optOrigCtx.get(), prefix)) != null) {
            return StmtContextUtils.internedQName(ctx, origModule, localName);
        }
        throw new InferenceException(ctx.getStatementSourceReference(), "Cannot resolve QNameModule for '%s'", str);
    }

    private static void checkIdentifierString(StmtContext<?, ?, ?> ctx, String str) {
        SourceException.throwIf(!IDENTIFIER_START.matches(str.charAt(0)) || NOT_IDENTIFIER_PART.indexIn((CharSequence)str, 1) != -1, ctx.getStatementSourceReference(), "String '%s' is not a valid identifier", str);
    }

    private static QName internedQName(StmtContext<?, ?, ?> ctx, String localName) {
        return StmtContextUtils.internedQName(ctx, StmtContextUtils.getRootModuleQName(ctx), localName);
    }

    private static QName internedQName(StmtContext<?, ?, ?> ctx, QNameModule module, String localName) {
        return (QName)ctx.getFromNamespace(QNameCacheNamespace.class, QName.create((QNameModule)module, (String)localName));
    }

    public static QNameModule getRootModuleQName(StmtContext<?, ?, ?> ctx) {
        QNameModule qnameModule;
        if (ctx == null) {
            return null;
        }
        StmtContext<?, ?, ?> rootCtx = ctx.getRoot();
        if (StmtContextUtils.producesDeclared(rootCtx, ModuleStatement.class)) {
            qnameModule = (QNameModule)rootCtx.getFromNamespace(ModuleCtxToModuleQName.class, rootCtx);
        } else if (StmtContextUtils.producesDeclared(rootCtx, SubmoduleStatement.class)) {
            String belongsToModuleName = (String)StmtContextUtils.firstAttributeOf(rootCtx.declaredSubstatements(), BelongsToStatement.class);
            qnameModule = (QNameModule)rootCtx.getFromNamespace(ModuleNameToModuleQName.class, belongsToModuleName);
        } else {
            qnameModule = null;
        }
        Preconditions.checkArgument((qnameModule != null ? 1 : 0) != 0, (String)"Failed to look up root QNameModule for %s", ctx);
        return qnameModule;
    }

    public static QNameModule getModuleQNameByPrefix(StmtContext<?, ?, ?> ctx, String prefix) {
        StmtContext importedModule = (StmtContext)ctx.getRoot().getFromNamespace(ImportPrefixToModuleCtx.class, prefix);
        QNameModule qnameModule = (QNameModule)ctx.getFromNamespace(ModuleCtxToModuleQName.class, importedModule);
        if (qnameModule != null) {
            return qnameModule;
        }
        if (StmtContextUtils.producesDeclared(ctx.getRoot(), SubmoduleStatement.class)) {
            String moduleName = (String)ctx.getRoot().getFromNamespace(BelongsToPrefixToModuleName.class, prefix);
            return (QNameModule)ctx.getFromNamespace(ModuleNameToModuleQName.class, moduleName);
        }
        return null;
    }

    public static SourceIdentifier createSourceIdentifier(StmtContext<?, ?, ?> root) {
        QNameModule qNameModule = (QNameModule)root.getFromNamespace(ModuleCtxToModuleQName.class, root);
        if (qNameModule != null) {
            return RevisionSourceIdentifier.create((String)((String)root.getStatementArgument()), (Optional)qNameModule.getRevision());
        }
        Optional<Revision> revision = StmtContextUtils.getLatestRevision(root.declaredSubstatements());
        return RevisionSourceIdentifier.create((String)((String)root.getStatementArgument()), revision);
    }

    public static Optional<Revision> getLatestRevision(Iterable<? extends StmtContext<?, ?, ?>> subStmts) {
        Revision revision = null;
        for (StmtContext<?, ?, ?> subStmt : subStmts) {
            if (!subStmt.getPublicDefinition().getDeclaredRepresentationClass().isAssignableFrom(RevisionStatement.class)) continue;
            if (revision == null && subStmt.getStatementArgument() != null) {
                revision = (Revision)subStmt.getStatementArgument();
                continue;
            }
            if (subStmt.getStatementArgument() == null || ((Revision)subStmt.getStatementArgument()).compareTo(revision) <= 0) continue;
            revision = (Revision)subStmt.getStatementArgument();
        }
        return Optional.ofNullable(revision);
    }
}

