/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.ExtensionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.InvalidSubstatementException;
import org.opendaylight.yangtools.yang.parser.spi.meta.MissingSubstatementException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToModuleQName;

public final class SubstatementValidator {
    private final Map<StatementDefinition, Cardinality> cardinalityMap;
    private final Map<StatementDefinition, Cardinality> mandatoryStatements;
    private final StatementDefinition currentStatement;

    private SubstatementValidator(Builder builder) {
        this.cardinalityMap = builder.cardinalityMap.build();
        this.currentStatement = builder.currentStatement;
        this.mandatoryStatements = ImmutableMap.copyOf((Map)Maps.filterValues(this.cardinalityMap, c -> ((Cardinality)c).getMin() > 0));
    }

    public static Builder builder(StatementDefinition currentStatement) {
        return new Builder(currentStatement);
    }

    public void validate(StmtContext<?, ?, ?> ctx) {
        HashMap<StatementDefinition, Counter> stmtCounts = new HashMap<StatementDefinition, Counter>();
        for (StmtContext<?, ?, ?> stmtContext : ctx.allSubstatements()) {
            stmtCounts.computeIfAbsent(stmtContext.getPublicDefinition(), key -> new Counter()).increment();
        }
        HashMap<StatementDefinition, Cardinality> missingMandatory = new HashMap<StatementDefinition, Cardinality>(this.mandatoryStatements);
        for (Map.Entry entry : stmtCounts.entrySet()) {
            StatementDefinition key2 = (StatementDefinition)entry.getKey();
            Cardinality cardinality = this.cardinalityMap.get(key2);
            int value = ((Counter)entry.getValue()).getValue();
            if (cardinality == null) {
                if (ctx.getFromNamespace(ExtensionNamespace.class, key2.getStatementName()) != null) continue;
                throw new InvalidSubstatementException(ctx.getStatementSourceReference(), "%s is not valid for %s. Error in module %s (%s)", key2, this.currentStatement, ctx.getRoot().getStatementArgument(), ctx.getFromNamespace(ModuleCtxToModuleQName.class, ctx.getRoot()));
            }
            if (cardinality.getMin() > 0) {
                if (cardinality.getMin() > value) {
                    throw new InvalidSubstatementException(ctx.getStatementSourceReference(), "Minimal count of %s for %s is %s, detected %s. Error in module %s (%s)", key2, this.currentStatement, cardinality.getMin(), value, ctx.getRoot().getStatementArgument(), ctx.getFromNamespace(ModuleCtxToModuleQName.class, ctx.getRoot()));
                }
                missingMandatory.remove(key2);
            }
            if (cardinality.getMax() >= value) continue;
            throw new InvalidSubstatementException(ctx.getStatementSourceReference(), "Maximal count of %s for %s is %s, detected %s. Error in module %s (%s)", key2, this.currentStatement, cardinality.getMax(), value, ctx.getRoot().getStatementArgument(), ctx.getFromNamespace(ModuleCtxToModuleQName.class, ctx.getRoot()));
        }
        if (!missingMandatory.isEmpty()) {
            Map.Entry entry = missingMandatory.entrySet().iterator().next();
            StmtContext<?, ?, ?> stmtContext = ctx.getRoot();
            throw new MissingSubstatementException(ctx.getStatementSourceReference(), "%s is missing %s. Minimal count is %s. Error in module %s (%s)", this.currentStatement, entry.getKey(), ((Cardinality)entry.getValue()).getMin(), stmtContext.getStatementArgument(), ctx.getFromNamespace(ModuleCtxToModuleQName.class, stmtContext));
        }
    }

    private static final class Counter {
        private int value;

        private Counter() {
        }

        void increment() {
            ++this.value;
        }

        int getValue() {
            return this.value;
        }
    }

    private static final class Cardinality {
        private final int min;
        private final int max;

        private Cardinality(int min, int max) {
            Preconditions.checkArgument((min >= 0 ? 1 : 0) != 0, (Object)"Min %s cannot be less than 0!");
            Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (String)"Min %s can not be greater than max %s!", (int)min, (int)max);
            this.min = min;
            this.max = max;
        }

        private int getMax() {
            return this.max;
        }

        private int getMin() {
            return this.min;
        }
    }

    public static final class Builder {
        private static final Cardinality ONE_MAX = new Cardinality(1, Integer.MAX_VALUE);
        private static final Cardinality ONE_ONE = new Cardinality(1, 1);
        private static final Cardinality ZERO_MAX = new Cardinality(0, Integer.MAX_VALUE);
        private static final Cardinality ZERO_ONE = new Cardinality(0, 1);
        private final ImmutableMap.Builder<StatementDefinition, Cardinality> cardinalityMap = ImmutableMap.builder();
        private final StatementDefinition currentStatement;

        Builder(StatementDefinition currentStatement) {
            this.currentStatement = currentStatement;
        }

        private Builder add(StatementDefinition def, Cardinality card) {
            this.cardinalityMap.put((Object)def, (Object)card);
            return this;
        }

        public Builder add(StatementDefinition def, int min, int max) {
            if (max == Integer.MAX_VALUE) {
                return this.addAtLeast(def, min);
            }
            if (min == 0) {
                return this.addAtMost(def, max);
            }
            return this.add(def, new Cardinality(min, max));
        }

        public Builder addAtLeast(StatementDefinition def, int min) {
            switch (min) {
                case 0: {
                    return this.addAny(def);
                }
                case 1: {
                    return this.addMultiple(def);
                }
            }
            return this.add(def, new Cardinality(min, Integer.MAX_VALUE));
        }

        public Builder addAtMost(StatementDefinition def, int max) {
            return max == Integer.MAX_VALUE ? this.addAny(def) : this.add(def, new Cardinality(0, max));
        }

        public Builder addAny(StatementDefinition def) {
            return this.add(def, ZERO_MAX);
        }

        public Builder addMandatory(StatementDefinition def) {
            return this.add(def, ONE_ONE);
        }

        public Builder addMultiple(StatementDefinition def) {
            return this.add(def, ONE_MAX);
        }

        public Builder addOptional(StatementDefinition def) {
            return this.add(def, ZERO_ONE);
        }

        public SubstatementValidator build() {
            return new SubstatementValidator(this);
        }
    }
}

