/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.source;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModule;

@NotThreadSafe
public class PrefixToModuleMap
implements PrefixToModule {
    private final Map<String, QNameModule> prefixToModuleMap = new HashMap<String, QNameModule>();
    private final Map<URI, QNameModule> namespaceToModuleMap = new HashMap<URI, QNameModule>();
    private final boolean preLinkageMap;

    public PrefixToModuleMap() {
        this(false);
    }

    @Deprecated
    public PrefixToModuleMap(boolean preLinkageMap) {
        this.preLinkageMap = preLinkageMap;
    }

    public void put(String prefix, QNameModule module) {
        this.prefixToModuleMap.put(prefix, module);
        this.namespaceToModuleMap.put(module.getNamespace(), module);
    }

    @Override
    @Nullable
    public QNameModule get(@Nonnull String prefix) {
        return this.prefixToModuleMap.get(prefix);
    }

    @Override
    @Nullable
    public QNameModule getByNamespace(String namespace) throws URISyntaxException {
        return this.namespaceToModuleMap.get(new URI(namespace));
    }

    @Override
    @Deprecated
    public boolean isPreLinkageMap() {
        return this.preLinkageMap;
    }
}

