/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.source;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.source.QNameToStatementDefinition;

public class QNameToStatementDefinitionMap
implements QNameToStatementDefinition {
    private final Map<QName, StatementSupport<?, ?, ?>> noRevQNameToSupport;
    private final Map<QName, StatementSupport<?, ?, ?>> qnameToSupport;

    public QNameToStatementDefinitionMap() {
        this.noRevQNameToSupport = new HashMap();
        this.qnameToSupport = new HashMap();
    }

    public QNameToStatementDefinitionMap(int initialCapacity) {
        this.noRevQNameToSupport = new HashMap(initialCapacity);
        this.qnameToSupport = new HashMap(initialCapacity);
    }

    public void put(QName qname, StatementSupport<?, ?, ?> stDef) {
        this.qnameToSupport.put(Objects.requireNonNull(qname), Objects.requireNonNull(stDef));
        this.putNoRev(qname, stDef);
    }

    public void putAll(Map<QName, StatementSupport<?, ?, ?>> qnameToStmt) {
        this.qnameToSupport.putAll(qnameToStmt);
        qnameToStmt.forEach(this::putNoRev);
    }

    public StatementSupport<?, ?, ?> putIfAbsent(QName qname, StatementSupport<?, ?, ?> support) {
        StatementSupport<?, ?, ?> existing = this.qnameToSupport.putIfAbsent(qname, support);
        if (existing != null) {
            return existing;
        }
        this.putNoRev(qname, support);
        return null;
    }

    private void putNoRev(QName qname, StatementSupport<?, ?, ?> support) {
        QName norev = qname.getRevision() != null ? QName.create((URI)qname.getNamespace(), (String)qname.getLocalName()).intern() : qname;
        this.noRevQNameToSupport.put(norev, support);
    }

    @Override
    @Nullable
    public StatementSupport<?, ?, ?> get(@Nonnull QName identifier) {
        return this.qnameToSupport.get(identifier);
    }

    @Override
    @Nullable
    public StatementDefinition getByNamespaceAndLocalName(@Nonnull URI namespace, @Nonnull String localName) {
        return this.noRevQNameToSupport.get(QName.create((URI)namespace, (String)localName));
    }
}

