/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.source;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public class SourceException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final StatementSourceReference sourceRef;

    public SourceException(@Nonnull String message, @Nonnull StatementSourceReference source) {
        super(SourceException.createMessage(message, source));
        this.sourceRef = source;
    }

    public SourceException(@Nonnull String message, @Nonnull StatementSourceReference source, Throwable cause) {
        super(SourceException.createMessage(message, source), cause);
        this.sourceRef = source;
    }

    public SourceException(@Nonnull StatementSourceReference source, @Nonnull String format, Object ... args) {
        this(String.format(format, args), source);
    }

    public SourceException(@Nonnull StatementSourceReference source, Throwable cause, @Nonnull String format, Object ... args) {
        this(String.format(format, args), source, cause);
    }

    @Nonnull
    public StatementSourceReference getSourceReference() {
        return this.sourceRef;
    }

    public static void throwIf(boolean expression, @Nonnull StatementSourceReference source, @Nonnull String format, Object ... args) {
        if (expression) {
            throw new SourceException(source, format, args);
        }
    }

    @Nonnull
    public static <T> T throwIfNull(@Nullable T obj, @Nonnull StatementSourceReference source, @Nonnull String format, Object ... args) {
        SourceException.throwIf(obj == null, source, format, args);
        return obj;
    }

    @Nonnull
    public static <T> T unwrap(Optional<T> opt, @Nonnull StatementSourceReference source, @Nonnull String format, Object ... args) {
        SourceException.throwIf(!opt.isPresent(), source, format, args);
        return opt.get();
    }

    private static String createMessage(@Nonnull String message, @Nonnull StatementSourceReference source) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(source);
        return message + " [at " + source + ']';
    }
}

