/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.impl;

import java.util.Objects;
import javax.xml.xpath.XPathExpressionException;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLiteralExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLocationPath;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathExpression;
import org.opendaylight.yangtools.yang.xpath.impl.InstanceIdentifierLiteralExpr;
import org.opendaylight.yangtools.yang.xpath.impl.QNameLiteralExpr;
import org.opendaylight.yangtools.yang.xpath.impl.QNameSupport;

final class AntlrYangXPathExpression
implements YangXPathExpression {
    private final QNameSupport qnameSupport;
    private final YangExpr rootExpr;
    private final String origStr;

    AntlrYangXPathExpression(QNameSupport qnameSupport, YangExpr rootExpr, String origStr) {
        this.qnameSupport = Objects.requireNonNull(qnameSupport);
        this.rootExpr = Objects.requireNonNull(rootExpr);
        this.origStr = Objects.requireNonNull(origStr);
    }

    public YangExpr getRootExpr() {
        return this.rootExpr;
    }

    public QName interpretAsQName(YangLiteralExpr expr) throws XPathExpressionException {
        if (expr instanceof QNameLiteralExpr) {
            return ((QNameLiteralExpr)expr).getQName();
        }
        try {
            return this.qnameSupport.createQName(expr.getLiteral());
        }
        catch (IllegalArgumentException e) {
            throw new XPathExpressionException(e);
        }
    }

    public YangLocationPath interpretAsInstanceIdentifier(YangLiteralExpr expr) throws XPathExpressionException {
        if (expr instanceof InstanceIdentifierLiteralExpr) {
            return YangLocationPath.of((boolean)true, ((InstanceIdentifierLiteralExpr)expr).getSteps());
        }
        throw new XPathExpressionException("Invalid instance-identifier " + expr);
    }

    public String toString() {
        return this.origStr;
    }
}

