/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.impl;

import java.math.BigDecimal;
import java.util.Optional;
import java.util.function.Function;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangBooleanConstantExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangNumberExpr;
import org.opendaylight.yangtools.yang.xpath.impl.XPathParser;

final class BigDecimalXPathParser
extends XPathParser<YangNumberExpr.YangBigDecimal> {
    private static final YangNumberExpr.YangBigDecimal ZERO = YangNumberExpr.YangBigDecimal.of((BigDecimal)BigDecimal.ZERO);
    private static final YangNumberExpr.YangBigDecimal ONE = YangNumberExpr.YangBigDecimal.of((BigDecimal)BigDecimal.ONE);
    private static final YangNumberExpr.YangBigDecimal TEN = YangNumberExpr.YangBigDecimal.of((BigDecimal)BigDecimal.TEN);

    BigDecimalXPathParser(QNameModule implicitNamespace, Function<String, QNameModule> prefixes) {
        super(implicitNamespace, prefixes);
    }

    @Override
    YangNumberExpr.YangBigDecimal createNumber(String str) {
        switch (str) {
            case "0": {
                return ZERO;
            }
            case "1": {
                return ONE;
            }
            case "10": {
                return TEN;
            }
        }
        return YangNumberExpr.YangBigDecimal.of((BigDecimal)new BigDecimal(str));
    }

    @Override
    YangNumberExpr.YangBigDecimal negateNumber(YangNumberExpr.YangBigDecimal number) {
        return YangNumberExpr.YangBigDecimal.of((BigDecimal)number.getNumber().negate());
    }

    @Override
    Optional<YangExpr> simplifyNumbers(YangBinaryOperator operator, YangNumberExpr.YangBigDecimal left, YangNumberExpr.YangBigDecimal right) {
        BigDecimal result;
        BigDecimal l = left.getNumber();
        BigDecimal r = right.getNumber();
        switch (operator) {
            case DIV: {
                result = l.divide(r);
                break;
            }
            case EQUALS: {
                return BigDecimalXPathParser.of(l.equals(r));
            }
            case GT: {
                return BigDecimalXPathParser.of(l.compareTo(r) > 0);
            }
            case GTE: {
                return BigDecimalXPathParser.of(l.compareTo(r) >= 0);
            }
            case LT: {
                return BigDecimalXPathParser.of(l.compareTo(r) < 0);
            }
            case LTE: {
                return BigDecimalXPathParser.of(l.compareTo(r) <= 0);
            }
            case MINUS: {
                result = l.subtract(r);
                break;
            }
            case MOD: {
                result = l.remainder(r);
                break;
            }
            case MUL: {
                result = l.multiply(r);
                break;
            }
            case NOT_EQUALS: {
                return BigDecimalXPathParser.of(!l.equals(r));
            }
            case PLUS: {
                result = l.add(r);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled operator " + operator);
            }
        }
        return Optional.of(YangNumberExpr.YangBigDecimal.of((BigDecimal)result));
    }

    private static Optional<YangExpr> of(boolean value) {
        return Optional.of(YangBooleanConstantExpr.of((boolean)value));
    }
}

