/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.impl;

import java.util.Optional;
import java.util.function.Function;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangBooleanConstantExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangNumberExpr;
import org.opendaylight.yangtools.yang.xpath.impl.XPathParser;

final class DoubleXPathParser
extends XPathParser<YangNumberExpr.YangDouble> {
    DoubleXPathParser(QNameModule implicitNamespace, Function<String, QNameModule> prefixes) {
        super(implicitNamespace, prefixes);
    }

    @Override
    YangNumberExpr.YangDouble createNumber(String str) {
        return YangNumberExpr.YangDouble.of((double)Double.parseDouble(str));
    }

    @Override
    YangNumberExpr.YangDouble negateNumber(YangNumberExpr.YangDouble number) {
        return YangNumberExpr.YangDouble.of((double)(-number.getValue()));
    }

    @Override
    Optional<YangExpr> simplifyNumbers(YangBinaryOperator operator, YangNumberExpr.YangDouble left, YangNumberExpr.YangDouble right) {
        double result;
        double l = left.getValue();
        double r = right.getValue();
        switch (operator) {
            case DIV: {
                result = l / r;
                break;
            }
            case EQUALS: {
                return DoubleXPathParser.of(l == r);
            }
            case GT: {
                return DoubleXPathParser.of(l > r);
            }
            case GTE: {
                return DoubleXPathParser.of(l >= r);
            }
            case LT: {
                return DoubleXPathParser.of(l < r);
            }
            case LTE: {
                return DoubleXPathParser.of(l <= r);
            }
            case MINUS: {
                result = l - r;
                break;
            }
            case MOD: {
                result = l % r;
                break;
            }
            case MUL: {
                result = l * r;
                break;
            }
            case NOT_EQUALS: {
                return DoubleXPathParser.of(l != r);
            }
            case PLUS: {
                result = l + r;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled operator " + operator);
            }
        }
        return Optional.of(YangNumberExpr.YangDouble.of((double)result));
    }

    private static Optional<YangExpr> of(boolean value) {
        return Optional.of(YangBooleanConstantExpr.of((boolean)value));
    }
}

