/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.impl;

import com.google.common.base.Preconditions;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.xpath.api.YangBooleanConstantExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangFunction;
import org.opendaylight.yangtools.yang.xpath.api.YangFunctionCallExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLiteralExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangNumberExpr;

final class Functions {
    private static final YangFunctionCallExpr CURRENT = YangFunctionCallExpr.of((QName)YangFunction.CURRENT.getIdentifier());
    private static final YangFunctionCallExpr LAST = YangFunctionCallExpr.of((QName)YangFunction.LAST.getIdentifier());
    private static final YangFunctionCallExpr LOCAL_NAME = YangFunctionCallExpr.of((QName)YangFunction.LOCAL_NAME.getIdentifier());
    private static final YangFunctionCallExpr NAME = YangFunctionCallExpr.of((QName)YangFunction.NAME.getIdentifier());
    private static final YangFunctionCallExpr NAMESPACE_URI = YangFunctionCallExpr.of((QName)YangFunction.NAMESPACE_URI.getIdentifier());
    private static final YangFunctionCallExpr NORMALIZE_SPACE = YangFunctionCallExpr.of((QName)YangFunction.NORMALIZE_SPACE.getIdentifier());
    private static final YangFunctionCallExpr NUMBER = YangFunctionCallExpr.of((QName)YangFunction.NUMBER.getIdentifier());
    static final YangFunctionCallExpr POSITION = YangFunctionCallExpr.of((QName)YangFunction.POSITION.getIdentifier());
    private static final YangFunctionCallExpr STRING = YangFunctionCallExpr.of((QName)YangFunction.STRING.getIdentifier());
    private static final YangFunctionCallExpr STRING_LENGTH = YangFunctionCallExpr.of((QName)YangFunction.STRING_LENGTH.getIdentifier());

    private Functions() {
    }

    static YangExpr functionToExpr(YangFunction func, List<YangExpr> args) {
        switch (func) {
            case BIT_IS_SET: {
                Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (Object)"bit-is-set(node-set, string) takes two arguments");
                break;
            }
            case BOOLEAN: {
                return Functions.booleanExpr(args);
            }
            case CEILING: {
                Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (Object)"ceiling(number) takes one argument");
                break;
            }
            case CONCAT: {
                return Functions.concatExpr(args);
            }
            case CONTAINS: {
                return Functions.containsExpr(args);
            }
            case COUNT: {
                Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (Object)"count(node-set) takes one argument");
                break;
            }
            case CURRENT: {
                Preconditions.checkArgument((boolean)args.isEmpty(), (Object)"current() does not take any arguments");
                return CURRENT;
            }
            case DEREF: {
                Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (Object)"deref(node-set) takes one argument");
                break;
            }
            case DERIVED_FROM: {
                return Functions.derivedFromExpr(args);
            }
            case DERIVED_FROM_OR_SELF: {
                return Functions.derivedFromOrSelfExpr(args);
            }
            case ENUM_VALUE: {
                Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (Object)"enum-value(node-set) takes one argument");
                break;
            }
            case FALSE: {
                Preconditions.checkArgument((boolean)args.isEmpty(), (Object)"false() does not take any arguments");
                return YangBooleanConstantExpr.FALSE;
            }
            case FLOOR: {
                Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (Object)"floor(number) takes one argument");
                break;
            }
            case ID: {
                Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (Object)"id(object) takes one argument");
                break;
            }
            case LANG: {
                Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (Object)"lang(string) takes one argument");
                break;
            }
            case LAST: {
                Preconditions.checkArgument((boolean)args.isEmpty(), (Object)"last() does not take any arguments");
                return LAST;
            }
            case LOCAL_NAME: {
                Preconditions.checkArgument((args.size() <= 1 ? 1 : 0) != 0, (Object)"local-name(node-set?) takes at most one argument");
                if (!args.isEmpty()) break;
                return LOCAL_NAME;
            }
            case NAME: {
                Preconditions.checkArgument((args.size() <= 1 ? 1 : 0) != 0, (Object)"name(node-set?) takes at most one argument");
                if (!args.isEmpty()) break;
                return NAME;
            }
            case NAMESPACE_URI: {
                Preconditions.checkArgument((args.size() <= 1 ? 1 : 0) != 0, (Object)"namespace-uri(node-set?) takes at most one argument");
                if (!args.isEmpty()) break;
                return NAMESPACE_URI;
            }
            case NORMALIZE_SPACE: {
                return Functions.normalizeSpaceExpr(args);
            }
            case NOT: {
                return Functions.notExpr(args);
            }
            case NUMBER: {
                return Functions.numberExpr(args);
            }
            case POSITION: {
                Preconditions.checkArgument((boolean)args.isEmpty(), (Object)"position() does not take any arguments");
                return POSITION;
            }
            case RE_MATCH: {
                Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (Object)"re-match(string, string) takes two arguments");
                break;
            }
            case ROUND: {
                Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (Object)"round(number) takes one argument");
                break;
            }
            case STARTS_WITH: {
                return Functions.startsWithExpr(args);
            }
            case STRING: {
                return Functions.stringExpr(args);
            }
            case STRING_LENGTH: {
                return Functions.stringLengthExpr(args);
            }
            case SUBSTRING: {
                return Functions.substringExpr(args);
            }
            case SUBSTRING_AFTER: {
                return Functions.substringAfterExpr(args);
            }
            case SUBSTRING_BEFORE: {
                return Functions.substringBeforeExpr(args);
            }
            case SUM: {
                Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (Object)"sub(node-set) takes one argument");
                break;
            }
            case TRANSLATE: {
                Preconditions.checkArgument((args.size() == 3 ? 1 : 0) != 0, (Object)"translate(string, string, string) takes three arguments");
                break;
            }
            case TRUE: {
                Preconditions.checkArgument((boolean)args.isEmpty(), (Object)"true() does not take any arguments");
                return YangBooleanConstantExpr.TRUE;
            }
            default: {
                throw new IllegalStateException("Unhandled function " + func);
            }
        }
        return YangFunctionCallExpr.of((QName)func.getIdentifier(), args);
    }

    private static YangExpr booleanExpr(List<YangExpr> args) {
        Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (Object)"boolean(object) takes one argument");
        YangExpr arg = args.get(0);
        if (arg instanceof YangBooleanConstantExpr) {
            return arg;
        }
        if (arg instanceof YangLiteralExpr) {
            return YangBooleanConstantExpr.of((boolean)((YangLiteralExpr)arg).getLiteral().isEmpty());
        }
        return YangFunctionCallExpr.of((QName)YangFunction.BOOLEAN.getIdentifier(), args);
    }

    private static YangExpr concatExpr(List<YangExpr> args) {
        Preconditions.checkArgument((args.size() >= 2 ? 1 : 0) != 0, (Object)"concat(string, string, string*) takes at least two arguments");
        return YangFunctionCallExpr.of((QName)YangFunction.CONCAT.getIdentifier(), args);
    }

    private static YangExpr containsExpr(List<YangExpr> args) {
        YangExpr second;
        Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (Object)"contains(string, string) takes two arguments");
        YangExpr first = args.get(0);
        if (first instanceof YangLiteralExpr && (second = args.get(1)) instanceof YangLiteralExpr) {
            return YangBooleanConstantExpr.of((boolean)((YangLiteralExpr)first).getLiteral().contains(((YangLiteralExpr)second).getLiteral()));
        }
        return YangFunctionCallExpr.of((QName)YangFunction.CONTAINS.getIdentifier(), args);
    }

    private static YangExpr derivedFromExpr(List<YangExpr> args) {
        Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (Object)"derived-from(node-set, string) takes two arguments");
        return YangFunctionCallExpr.of((QName)YangFunction.DERIVED_FROM.getIdentifier(), args);
    }

    private static YangExpr derivedFromOrSelfExpr(List<YangExpr> args) {
        Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (Object)"derived-from-or-self(node-set, string) takes two arguments");
        return YangFunctionCallExpr.of((QName)YangFunction.DERIVED_FROM_OR_SELF.getIdentifier(), args);
    }

    private static YangExpr notExpr(List<YangExpr> args) {
        Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (Object)"not(boolean) takes one argument");
        YangExpr arg = args.get(0);
        if (arg instanceof YangBooleanConstantExpr) {
            return YangBooleanConstantExpr.of((boolean)((YangBooleanConstantExpr)arg).getValue());
        }
        return YangFunctionCallExpr.of((QName)YangFunction.NOT.getIdentifier(), args);
    }

    private static YangExpr normalizeSpaceExpr(List<YangExpr> args) {
        Preconditions.checkArgument((args.size() <= 1 ? 1 : 0) != 0, (Object)"number(object?) takes at most one argument");
        if (args.isEmpty()) {
            return NORMALIZE_SPACE;
        }
        YangExpr arg = args.get(0);
        if (arg instanceof YangLiteralExpr) {
            // empty if block
        }
        return YangFunctionCallExpr.of((QName)YangFunction.NORMALIZE_SPACE.getIdentifier(), args);
    }

    private static YangExpr numberExpr(List<YangExpr> args) {
        Preconditions.checkArgument((args.size() <= 1 ? 1 : 0) != 0, (Object)"number(object?) takes at most one argument");
        if (args.isEmpty()) {
            return NUMBER;
        }
        YangExpr arg = args.get(0);
        if (arg instanceof YangNumberExpr) {
            return arg;
        }
        return YangFunctionCallExpr.of((QName)YangFunction.NUMBER.getIdentifier(), args);
    }

    private static YangExpr startsWithExpr(List<YangExpr> args) {
        Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (Object)"starts-with(string, string) takes two arguments");
        return YangFunctionCallExpr.of((QName)YangFunction.STARTS_WITH.getIdentifier(), args);
    }

    private static YangExpr substringBeforeExpr(List<YangExpr> args) {
        Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (Object)"substring-before(string, string) takes two arguments");
        return YangFunctionCallExpr.of((QName)YangFunction.SUBSTRING_BEFORE.getIdentifier(), args);
    }

    private static YangExpr substringAfterExpr(List<YangExpr> args) {
        Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (Object)"substring-after(string, string) takes two arguments");
        return YangFunctionCallExpr.of((QName)YangFunction.SUBSTRING_AFTER.getIdentifier(), args);
    }

    private static YangExpr substringExpr(List<YangExpr> args) {
        int size = args.size();
        Preconditions.checkArgument((size == 2 || size == 3 ? 1 : 0) != 0, (Object)"substring-(string, number, number?) takes two or three arguments");
        return YangFunctionCallExpr.of((QName)YangFunction.SUBSTRING.getIdentifier(), args);
    }

    private static YangExpr stringExpr(List<YangExpr> args) {
        Preconditions.checkArgument((args.size() <= 1 ? 1 : 0) != 0, (Object)"string(object?) takes at most one argument");
        if (args.isEmpty()) {
            return STRING;
        }
        YangExpr arg = args.get(0);
        if (arg instanceof YangLiteralExpr) {
            return arg;
        }
        return YangFunctionCallExpr.of((QName)YangFunction.STRING.getIdentifier(), args);
    }

    private static YangExpr stringLengthExpr(List<YangExpr> args) {
        Preconditions.checkArgument((args.size() <= 1 ? 1 : 0) != 0, (Object)"string(object?) takes at most one argument");
        if (args.isEmpty()) {
            return STRING_LENGTH;
        }
        return YangFunctionCallExpr.of((QName)YangFunction.STRING_LENGTH.getIdentifier(), args);
    }
}

