/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.impl;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;

final class QNameSupport {
    private final Function<String, QNameModule> prefixes;
    private final QNameModule implicitNamespace;

    QNameSupport(QNameModule implicitNamespace, Function<String, QNameModule> prefixes) {
        this.implicitNamespace = Objects.requireNonNull(implicitNamespace);
        this.prefixes = Objects.requireNonNull(prefixes);
    }

    QName createQName(String localName) {
        return QName.create((QNameModule)this.implicitNamespace, (String)localName);
    }

    QName createQName(String prefix, String localName) {
        QNameModule namespace = this.prefixes.apply(prefix);
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (String)"Failed to lookup namespace for prefix %s", (Object)prefix);
        return QName.create((QNameModule)namespace, (String)localName);
    }

    Optional<QNameModule> resolvePrefix(String prefix) {
        return Optional.ofNullable(this.prefixes.apply(Objects.requireNonNull(prefix)));
    }
}

