/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.xpath.XPathExpressionException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangBooleanConstantExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangFilterExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangFunction;
import org.opendaylight.yangtools.yang.xpath.api.YangFunctionCallExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLiteralExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLocationPath;
import org.opendaylight.yangtools.yang.xpath.api.YangNaryExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangNaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangNegateExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangNumberExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangQNameExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangVariableReferenceExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathAxis;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathExpression;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathNodeType;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathParser;
import org.opendaylight.yangtools.yang.xpath.impl.AntlrYangXPathExpression;
import org.opendaylight.yangtools.yang.xpath.impl.Functions;
import org.opendaylight.yangtools.yang.xpath.impl.InstanceIdentifierLiteralExpr;
import org.opendaylight.yangtools.yang.xpath.impl.QNameLiteralExpr;
import org.opendaylight.yangtools.yang.xpath.impl.QNameSupport;
import org.opendaylight.yangtools.yang.xpath.impl.instanceIdentifierParser;
import org.opendaylight.yangtools.yang.xpath.impl.xpathLexer;
import org.opendaylight.yangtools.yang.xpath.impl.xpathParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class XPathParser<N extends YangNumberExpr<N, ?>>
implements YangXPathParser {
    private static final Logger LOG = LoggerFactory.getLogger(XPathParser.class);
    private static final Map<String, YangBinaryOperator> BINARY_OPERATORS = Maps.uniqueIndex(Arrays.asList(YangBinaryOperator.values()), YangBinaryOperator::toString);
    private static final Map<String, YangXPathNodeType> NODE_TYPES = Maps.uniqueIndex(Arrays.asList(YangXPathNodeType.values()), YangXPathNodeType::toString);
    private static final Map<String, YangXPathAxis> XPATH_AXES = Maps.uniqueIndex(Arrays.asList(YangXPathAxis.values()), YangXPathAxis::toString);
    private static final Map<QName, YangFunction> YANG_FUNCTIONS = Maps.uniqueIndex(Arrays.asList(YangFunction.values()), YangFunction::getIdentifier);
    private static final YangLocationPath.AxisStep SELF_STEP = YangXPathAxis.SELF.asStep();
    private final QNameSupport qnameSupport;

    XPathParser(QNameModule implicitNamespace, Function<String, QNameModule> prefixes) {
        this.qnameSupport = new QNameSupport(implicitNamespace, prefixes);
    }

    public YangXPathExpression parseExpression(String xpath) throws XPathExpressionException {
        xpathLexer lexer = new xpathLexer((CharStream)CharStreams.fromString((String)xpath));
        xpathParser parser = new xpathParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        final ArrayList errors = new ArrayList();
        BaseErrorListener listener = new BaseErrorListener(){

            public void syntaxError(@Nullable Recognizer<?, ?> recognizer, @Nullable Object offendingSymbol, int line, int charPositionInLine, @Nullable String msg, @Nullable RecognitionException cause) {
                XPathExpressionException ex = new XPathExpressionException(msg);
                ex.initCause((Throwable)cause);
                if (errors.isEmpty()) {
                    errors.add(ex);
                } else {
                    ((XPathExpressionException)errors.get(0)).addSuppressed(ex);
                }
            }
        };
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        YangExpr expr = this.parseExpr(parser.main().expr());
        if (!errors.isEmpty()) {
            throw (XPathExpressionException)errors.get(0);
        }
        return new AntlrYangXPathExpression(this.qnameSupport, expr, xpath);
    }

    private YangExpr parseExpr(xpathParser.ExprContext expr) {
        xpathParser.OrExprContext or = expr.orExpr();
        int size = or.getChildCount();
        if (size == 1) {
            return this.parseAnd(XPathParser.getChild((ParseTree)or, xpathParser.AndExprContext.class, 0));
        }
        ArrayList<YangExpr> tmp = new ArrayList<YangExpr>((size + 1) / 2);
        for (int i = 0; i < size; i += 2) {
            tmp.add(this.parseAnd(XPathParser.getChild((ParseTree)or, xpathParser.AndExprContext.class, i)));
        }
        return YangNaryOperator.OR.exprWith(tmp);
    }

    abstract N createNumber(String var1);

    abstract N negateNumber(N var1);

    private YangExpr parseAdditive(xpathParser.AdditiveExprContext expr) {
        Iterator<ParseTree> it = expr.children.iterator();
        YangExpr first = this.parseMultiplicative(XPathParser.nextContext(it, xpathParser.MultiplicativeExprContext.class));
        return it.hasNext() ? this.parseAdditiveExpr(first, it) : first;
    }

    private YangExpr parseAnd(xpathParser.AndExprContext expr) {
        int size = expr.getChildCount();
        if (size == 1) {
            return this.parseEquality(XPathParser.getChild((ParseTree)expr, xpathParser.EqualityExprContext.class, 0));
        }
        ArrayList<YangExpr> tmp = new ArrayList<YangExpr>((size + 1) / 2);
        for (int i = 0; i < size; i += 2) {
            tmp.add(this.parseEquality(XPathParser.getChild((ParseTree)expr, xpathParser.EqualityExprContext.class, i)));
        }
        return YangNaryOperator.AND.exprWith(tmp);
    }

    private YangExpr parseEquality(xpathParser.EqualityExprContext expr) {
        Iterator<ParseTree> it = expr.children.iterator();
        YangExpr first = this.parseRelational(XPathParser.nextContext(it, xpathParser.RelationalExprContext.class));
        return it.hasNext() ? this.parseEqualityExpr(first, it) : first;
    }

    private YangExpr parseFilter(xpathParser.FilterExprContext expr) {
        Iterator<ParseTree> it = expr.children.iterator();
        YangExpr first = this.parsePrimary(XPathParser.nextContext(it, xpathParser.PrimaryExprContext.class));
        return it.hasNext() ? YangFilterExpr.of((YangExpr)first, (Collection)ImmutableList.copyOf((Iterator)Iterators.transform(it, tree -> this.parsePredicate(XPathParser.verifyTree(xpathParser.PredicateContext.class, tree))))) : first;
    }

    private YangExpr parseFunctionCall(xpathParser.FunctionCallContext expr) {
        QName parsed;
        xpathParser.FunctionNameContext name = XPathParser.getChild((ParseTree)expr, xpathParser.FunctionNameContext.class, 0);
        switch (name.getChildCount()) {
            case 1: {
                parsed = QName.create((QNameModule)YangConstants.RFC6020_YIN_MODULE, (String)name.getChild(0).getText());
                break;
            }
            case 3: {
                parsed = this.qnameSupport.createQName(name.getChild(0).getText(), name.getChild(2).getText());
                break;
            }
            default: {
                throw XPathParser.illegalShape((ParseTree)name);
            }
        }
        ImmutableList args = ImmutableList.copyOf((Collection)Lists.transform(expr.expr(), this::parseExpr));
        YangFunction func = YANG_FUNCTIONS.get(parsed);
        if (func != null) {
            return Functions.functionToExpr(func, (List<YangExpr>)args);
        }
        Preconditions.checkArgument((!YangConstants.RFC6020_YIN_MODULE.equals((Object)parsed.getModule()) ? 1 : 0) != 0, (String)"Unknown default function %s", (Object)parsed);
        return YangFunctionCallExpr.of((QName)parsed, (List)args);
    }

    private YangLocationPath parseLocationPath(xpathParser.LocationPathContext expr) {
        XPathParser.verifyChildCount((ParseTree)expr, 1);
        ParseTree first = expr.getChild(0);
        if (first instanceof xpathParser.RelativeLocationPathContext) {
            return this.parseRelativeLocationPath((xpathParser.RelativeLocationPathContext)first);
        }
        xpathParser.AbsoluteLocationPathNorootContext abs = XPathParser.verifyTree(xpathParser.AbsoluteLocationPathNorootContext.class, first);
        XPathParser.verifyChildCount((ParseTree)abs, 2);
        Deque<YangLocationPath.Step> steps = this.parseLocationPathSteps(XPathParser.getChild((ParseTree)abs, xpathParser.RelativeLocationPathContext.class, 1));
        switch (XPathParser.getTerminalType((ParseTree)abs, 0)) {
            case 12: {
                break;
            }
            case 13: {
                steps.addFirst((YangLocationPath.Step)YangXPathAxis.DESCENDANT_OR_SELF.asStep());
                break;
            }
            default: {
                throw XPathParser.illegalShape((ParseTree)abs);
            }
        }
        return YangLocationPath.of((boolean)true, steps);
    }

    private YangExpr parseMultiplicative(xpathParser.MultiplicativeExprContext expr) {
        ParseTree first = expr.getChild(0);
        Object left = first instanceof xpathParser.UnaryExprNoRootContext ? this.parseUnary((xpathParser.UnaryExprNoRootContext)first) : YangLocationPath.root();
        if (expr.getChildCount() == 1) {
            return left;
        }
        XPathParser.verifyChildCount((ParseTree)expr, 3);
        YangBinaryOperator operator = XPathParser.parseOperator(expr.getChild(1));
        YangExpr right = this.parseMultiplicative(XPathParser.getChild((ParseTree)expr, xpathParser.MultiplicativeExprContext.class, 2));
        Optional<YangExpr> simple = this.simplifyNumbers(operator, left, right);
        return simple.isPresent() ? simple.get() : operator.exprWith((YangExpr)left, right);
    }

    private YangExpr parsePathExpr(xpathParser.PathExprNoRootContext expr) {
        ParseTree first = expr.getChild(0);
        if (first instanceof xpathParser.LocationPathContext) {
            return this.parseLocationPath((xpathParser.LocationPathContext)first);
        }
        YangExpr filter = this.parseFilter(XPathParser.verifyTree(xpathParser.FilterExprContext.class, first));
        if (expr.getChildCount() == 1) {
            return filter;
        }
        XPathParser.verifyChildCount((ParseTree)expr, 3);
        return XPathParser.parseOperator(expr.getChild(1)).exprWith(filter, (YangExpr)this.parseRelativeLocationPath(XPathParser.getChild((ParseTree)expr, xpathParser.RelativeLocationPathContext.class, 2)));
    }

    private YangExpr parsePredicate(xpathParser.PredicateContext expr) {
        XPathParser.verifyChildCount((ParseTree)expr, 3);
        return this.parseExpr(XPathParser.getChild((ParseTree)expr, xpathParser.ExprContext.class, 1));
    }

    private YangExpr parsePrimary(xpathParser.PrimaryExprContext expr) {
        if (expr.getChildCount() == 3) {
            return this.parseExpr(XPathParser.getChild((ParseTree)expr, xpathParser.ExprContext.class, 1));
        }
        XPathParser.verifyChildCount((ParseTree)expr, 1);
        ParseTree first = expr.getChild(0);
        if (first instanceof TerminalNode) {
            return this.parseTerminal((TerminalNode)first);
        }
        if (first instanceof xpathParser.FunctionCallContext) {
            return this.parseFunctionCall((xpathParser.FunctionCallContext)first);
        }
        if (first instanceof xpathParser.VariableReferenceContext) {
            return YangVariableReferenceExpr.of((QName)this.parseQName(((xpathParser.VariableReferenceContext)first).qName()));
        }
        throw XPathParser.illegalShape(first);
    }

    private YangExpr parseRelational(xpathParser.RelationalExprContext expr) {
        Iterator<ParseTree> it = expr.children.iterator();
        YangExpr first = this.parseAdditive(XPathParser.nextContext(it, xpathParser.AdditiveExprContext.class));
        return it.hasNext() ? this.parseRelationalExpr(first, it) : first;
    }

    private Deque<YangLocationPath.Step> parseLocationPathSteps(xpathParser.RelativeLocationPathContext expr) {
        ArrayDeque<YangLocationPath.Step> steps = new ArrayDeque<YangLocationPath.Step>(expr.getChildCount());
        Iterator<ParseTree> it = expr.children.iterator();
        steps.add(this.parseStep(XPathParser.nextContext(it, xpathParser.StepContext.class)));
        while (it.hasNext()) {
            YangLocationPath.Step step;
            ParseTree tree = it.next();
            switch (XPathParser.verifyTerminal(tree).getSymbol().getType()) {
                case 12: {
                    break;
                }
                case 13: {
                    steps.add((YangLocationPath.Step)YangXPathAxis.DESCENDANT_OR_SELF.asStep());
                    break;
                }
                default: {
                    throw XPathParser.illegalShape(tree);
                }
            }
            if (SELF_STEP.equals((Object)(step = this.parseStep(XPathParser.nextContext(it, xpathParser.StepContext.class))))) continue;
            steps.add(step);
        }
        return steps;
    }

    private YangLocationPath parseRelativeLocationPath(xpathParser.RelativeLocationPathContext expr) {
        return YangLocationPath.of((boolean)false, this.parseLocationPathSteps(expr));
    }

    private YangExpr parseTerminal(TerminalNode term) {
        String text = term.getText();
        switch (term.getSymbol().getType()) {
            case 34: {
                return this.parseLiteral(text.substring(1, text.length() - 1));
            }
            case 10: {
                return this.createNumber(text);
            }
        }
        throw XPathParser.illegalShape((ParseTree)term);
    }

    private YangLiteralExpr parseLiteral(String text) {
        if (text.isEmpty()) {
            return YangLiteralExpr.empty();
        }
        if (text.charAt(0) == '/') {
            return this.parseLocationLiteral(text);
        }
        return this.parseQNameLiteral(text);
    }

    private YangLiteralExpr parseLocationLiteral(String text) {
        xpathLexer lexer = new xpathLexer((CharStream)CharStreams.fromString((String)text));
        instanceIdentifierParser parser = new instanceIdentifierParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        instanceIdentifierParser.InstanceIdentifierContext id = parser.instanceIdentifier();
        int length = id.getChildCount();
        ArrayList<YangLocationPath.Step> steps = new ArrayList<YangLocationPath.Step>(length / 2);
        for (int i = 1; i < length; i += 2) {
            steps.add(this.parsePathArgument(XPathParser.getChild((ParseTree)id, instanceIdentifierParser.PathArgumentContext.class, i)));
        }
        return new InstanceIdentifierLiteralExpr(text, steps);
    }

    private YangLocationPath.Step parsePathArgument(instanceIdentifierParser.PathArgumentContext expr) {
        QName qname = this.parseInstanceIdentifierQName(XPathParser.getChild((ParseTree)expr, instanceIdentifierParser.NodeIdentifierContext.class, 0));
        switch (expr.getChildCount()) {
            case 1: {
                return YangXPathAxis.CHILD.asStep(qname, (Collection)ImmutableSet.of());
            }
            case 2: {
                return YangXPathAxis.CHILD.asStep(qname, this.parsePathArgumentPredicate(XPathParser.getChild((ParseTree)expr, instanceIdentifierParser.PredicateContext.class, 1)));
            }
        }
        throw XPathParser.illegalShape((ParseTree)expr);
    }

    private Collection<YangExpr> parsePathArgumentPredicate(instanceIdentifierParser.PredicateContext expr) {
        ParseTree first = expr.getChild(0);
        if (first instanceof instanceIdentifierParser.LeafListPredicateContext) {
            return ImmutableSet.of((Object)YangBinaryOperator.EQUALS.exprWith((YangExpr)YangLocationPath.self(), (YangExpr)this.parseEqStringValue(XPathParser.getChild(((instanceIdentifierParser.LeafListPredicateContext)first).getChild(instanceIdentifierParser.LeafListPredicateExprContext.class, 0), instanceIdentifierParser.EqQuotedStringContext.class, 1))));
        }
        if (first instanceof instanceIdentifierParser.PosContext) {
            return ImmutableSet.of((Object)YangBinaryOperator.EQUALS.exprWith((YangExpr)Functions.POSITION, this.createNumber(((instanceIdentifierParser.PosContext)first).getToken(10, 0).getText())));
        }
        int length = expr.getChildCount();
        ArrayList<YangExpr> ret = new ArrayList<YangExpr>(length);
        for (int i = 0; i < length; ++i) {
            instanceIdentifierParser.KeyPredicateExprContext pred = (instanceIdentifierParser.KeyPredicateExprContext)XPathParser.getChild((ParseTree)expr, instanceIdentifierParser.KeyPredicateContext.class, i).getChild(instanceIdentifierParser.KeyPredicateExprContext.class, 0);
            ret.add((YangExpr)YangBinaryOperator.EQUALS.exprWith((YangExpr)YangQNameExpr.of((QName)this.parseInstanceIdentifierQName(XPathParser.getChild((ParseTree)pred, instanceIdentifierParser.NodeIdentifierContext.class, 0))), (YangExpr)this.parseEqStringValue(XPathParser.getChild((ParseTree)pred, instanceIdentifierParser.EqQuotedStringContext.class, 1))));
        }
        return ret;
    }

    private YangLiteralExpr parseEqStringValue(instanceIdentifierParser.EqQuotedStringContext expr) {
        return this.parseLiteral(XPathParser.verifyToken((ParseTree)XPathParser.getChild((ParseTree)expr, instanceIdentifierParser.QuotedStringContext.class, expr.getChildCount() - 1), 1, 11).getText());
    }

    private QName parseInstanceIdentifierQName(instanceIdentifierParser.NodeIdentifierContext expr) {
        return this.qnameSupport.createQName(XPathParser.verifyToken((ParseTree)expr, 0, 9).getText(), XPathParser.verifyToken((ParseTree)expr, 2, 9).getText());
    }

    private YangLiteralExpr parseQNameLiteral(String text) {
        Optional<QNameModule> optNamespace;
        int secondColon;
        int firstColon = text.indexOf(58);
        if (firstColon != -1 && (secondColon = text.indexOf(58, firstColon + 1)) == -1 && (optNamespace = this.qnameSupport.resolvePrefix(text.substring(0, firstColon))).isPresent()) {
            try {
                return new QNameLiteralExpr(text, QName.create((QNameModule)optNamespace.get(), (String)text.substring(firstColon + 1)));
            }
            catch (IllegalArgumentException e) {
                LOG.trace("Cannot interpret {} as a QName", (Object)text, (Object)e);
                return YangLiteralExpr.of((String)text);
            }
        }
        return YangLiteralExpr.of((String)text);
    }

    private YangExpr parseUnary(xpathParser.UnaryExprNoRootContext expr) {
        int size = XPathParser.verifyAtLeastChildren((ParseTree)expr, 1);
        YangExpr ret = this.parseUnion(XPathParser.getChild((ParseTree)expr, xpathParser.UnionExprNoRootContext.class, size - 1));
        if (size % 2 != 0) {
            return ret;
        }
        return ret instanceof YangNumberExpr ? this.negateNumber((YangNumberExpr)ret) : YangNegateExpr.of((YangExpr)ret);
    }

    private YangExpr parseUnion(xpathParser.UnionExprNoRootContext expr) {
        YangLocationPath path;
        ParseTree first = expr.getChild(0);
        if (first instanceof xpathParser.PathExprNoRootContext) {
            path = this.parsePathExpr((xpathParser.PathExprNoRootContext)first);
            if (expr.getChildCount() == 1) {
                return path;
            }
        } else {
            path = YangLocationPath.root();
        }
        XPathParser.verifyChildCount((ParseTree)expr, 3);
        YangExpr union = this.parseUnion(XPathParser.getChild((ParseTree)expr, xpathParser.UnionExprNoRootContext.class, 2));
        LinkedHashSet<Object> expressions = new LinkedHashSet<Object>();
        expressions.add(path);
        if (union instanceof YangNaryExpr) {
            YangNaryExpr nary = (YangNaryExpr)union;
            if (nary.getOperator() == YangNaryOperator.UNION) {
                expressions.addAll(nary.getExpressions());
            } else {
                expressions.add(union);
            }
        } else {
            expressions.add(union);
        }
        return YangNaryOperator.UNION.exprWith(expressions);
    }

    private YangExpr parseAdditiveExpr(YangExpr left, Iterator<ParseTree> it) {
        YangExpr ret = left;
        do {
            YangExpr right;
            YangBinaryOperator operator;
            Optional<YangExpr> simple;
            Object object = ret = (simple = this.simplifyNumbers(operator = XPathParser.nextOperator(it), (N)ret, (N)(right = this.parseMultiplicative(XPathParser.nextContext(it, xpathParser.MultiplicativeExprContext.class))))).isPresent() ? simple.get() : operator.exprWith(ret, right);
        } while (it.hasNext());
        return ret;
    }

    private Optional<YangExpr> simplifyNumbers(YangBinaryOperator operator, YangExpr left, YangExpr right) {
        if (left instanceof YangNumberExpr && right instanceof YangNumberExpr) {
            return this.simplifyNumbers(operator, (YangNumberExpr)left, (YangNumberExpr)right);
        }
        return Optional.empty();
    }

    Optional<YangExpr> simplifyNumbers(YangBinaryOperator operator, N left, N right) {
        switch (operator) {
            case EQUALS: {
                return Optional.of(YangBooleanConstantExpr.of((boolean)left.getNumber().equals(right.getNumber())));
            }
            case NOT_EQUALS: {
                return Optional.of(YangBooleanConstantExpr.of((!left.getNumber().equals(right.getNumber()) ? 1 : 0) != 0));
            }
        }
        return Optional.empty();
    }

    private YangExpr parseEqualityExpr(YangExpr left, Iterator<ParseTree> it) {
        YangExpr ret = left;
        do {
            Optional<YangExpr> simple;
            YangBinaryOperator operator = XPathParser.nextOperator(it);
            YangExpr right = this.parseRelational(XPathParser.nextContext(it, xpathParser.RelationalExprContext.class));
            if (left.equals(right)) {
                switch (operator) {
                    case EQUALS: {
                        return YangBooleanConstantExpr.TRUE;
                    }
                    case NOT_EQUALS: {
                        return YangBooleanConstantExpr.FALSE;
                    }
                }
            }
            Object object = ret = (simple = this.simplifyNumbers(operator, (N)ret, (N)right)).isPresent() ? simple.get() : operator.exprWith(ret, right);
        } while (it.hasNext());
        return ret;
    }

    private YangExpr parseRelationalExpr(YangExpr left, Iterator<ParseTree> it) {
        YangExpr ret = left;
        do {
            YangExpr right;
            YangBinaryOperator operator;
            Optional<YangExpr> simple;
            Object object = ret = (simple = this.simplifyNumbers(operator = XPathParser.nextOperator(it), (N)ret, (N)(right = this.parseAdditive(XPathParser.nextContext(it, xpathParser.AdditiveExprContext.class))))).isPresent() ? simple.get() : XPathParser.nextOperator(it).exprWith(ret, right);
        } while (it.hasNext());
        return ret;
    }

    private QName parseQName(xpathParser.QNameContext expr) {
        switch (expr.getChildCount()) {
            case 1: {
                return this.qnameSupport.createQName(XPathParser.getChild((ParseTree)expr, xpathParser.NCNameContext.class, 0).getText());
            }
            case 3: {
                return this.qnameSupport.createQName(XPathParser.getChild((ParseTree)expr, xpathParser.NCNameContext.class, 0).getText(), XPathParser.getChild((ParseTree)expr, xpathParser.NCNameContext.class, 2).getText());
            }
        }
        throw XPathParser.illegalShape((ParseTree)expr);
    }

    private YangLocationPath.Step parseStep(xpathParser.StepContext expr) {
        if (expr.getChildCount() == 1) {
            xpathParser.AbbreviatedStepContext abbrev = XPathParser.getChild((ParseTree)expr, xpathParser.AbbreviatedStepContext.class, 0);
            XPathParser.verifyChildCount((ParseTree)abbrev, 1);
            switch (XPathParser.getTerminalType((ParseTree)abbrev, 0)) {
                case 20: {
                    return YangXPathAxis.SELF.asStep();
                }
                case 22: {
                    return YangXPathAxis.PARENT.asStep();
                }
            }
            throw XPathParser.illegalShape((ParseTree)abbrev);
        }
        int size = XPathParser.verifyAtLeastChildren((ParseTree)expr, 2);
        ArrayList<YangExpr> predicates = new ArrayList<YangExpr>(size - 2);
        for (int i = 2; i < size; ++i) {
            predicates.add(this.parsePredicate(XPathParser.getChild((ParseTree)expr, xpathParser.PredicateContext.class, i)));
        }
        YangXPathAxis axis = XPathParser.parseAxis(XPathParser.getChild((ParseTree)expr, xpathParser.AxisSpecifierContext.class, 0));
        xpathParser.NodeTestContext nodeTest = XPathParser.getChild((ParseTree)expr, xpathParser.NodeTestContext.class, 1);
        switch (nodeTest.getChildCount()) {
            case 1: {
                xpathParser.NameTestContext nameChild = XPathParser.getChild((ParseTree)nodeTest, xpathParser.NameTestContext.class, 0);
                ParseTree first = nameChild.getChild(0);
                if (first instanceof TerminalNode) {
                    Verify.verify((((TerminalNode)first).getSymbol().getType() == 21 ? 1 : 0) != 0);
                    return axis.asStep(predicates);
                }
                return axis.asStep(this.parseQName(XPathParser.verifyTree(xpathParser.QNameContext.class, first)), predicates);
            }
            case 3: {
                return axis.asStep(XPathParser.parseNodeType(nodeTest.getChild(0)), predicates);
            }
            case 4: {
                String text = XPathParser.verifyToken((ParseTree)nodeTest, 2, 34).getText();
                return axis.asStep(text.substring(1, text.length() - 1), predicates);
            }
        }
        throw XPathParser.illegalShape((ParseTree)nodeTest);
    }

    private static YangXPathAxis parseAxis(xpathParser.AxisSpecifierContext expr) {
        switch (expr.getChildCount()) {
            case 0: {
                return YangXPathAxis.CHILD;
            }
            case 1: {
                Verify.verify((XPathParser.getTerminalType((ParseTree)expr, 0) == 23 ? 1 : 0) != 0, (String)"Unhandled axis specifier shape %s", (Object)((Object)expr));
                return YangXPathAxis.ATTRIBUTE;
            }
            case 2: {
                String str = XPathParser.verifyTerminal(expr.getChild(0)).getText();
                return (YangXPathAxis)Verify.verifyNotNull((Object)XPATH_AXES.get(str), (String)"Unhandled axis %s", (Object[])new Object[]{str});
            }
        }
        throw XPathParser.illegalShape((ParseTree)expr);
    }

    private static <T extends ParserRuleContext> T nextContext(Iterator<ParseTree> it, Class<T> type) {
        return (T)((ParserRuleContext)XPathParser.verifyTree(type, it.next()));
    }

    private static YangBinaryOperator nextOperator(Iterator<ParseTree> it) {
        return XPathParser.parseOperator(it.next());
    }

    private static <T extends ParseTree> T getChild(ParseTree parent, Class<T> type, int offset) {
        return XPathParser.verifyTree(type, parent.getChild(offset));
    }

    private static Token verifyToken(ParseTree parent, int offset, int expected) {
        TerminalNode node = XPathParser.verifyTerminal(parent.getChild(offset));
        Token ret = node.getSymbol();
        int type = ret.getType();
        Verify.verify((type == expected ? 1 : 0) != 0, (String)"Item %s has type %s, expected %s", (Object)node, (Object)type, (Object)expected);
        return ret;
    }

    private static int getTerminalType(ParseTree parent, int offset) {
        return XPathParser.verifyTerminal(parent.getChild(offset)).getSymbol().getType();
    }

    private static YangXPathNodeType parseNodeType(ParseTree tree) {
        String str = XPathParser.verifyTerminal(tree).getText();
        return (YangXPathNodeType)Verify.verifyNotNull((Object)NODE_TYPES.get(str), (String)"Unhandled node type %s", (Object[])new Object[]{str});
    }

    private static YangBinaryOperator parseOperator(ParseTree tree) {
        String str = XPathParser.verifyTerminal(tree).getText();
        return (YangBinaryOperator)Verify.verifyNotNull((Object)BINARY_OPERATORS.get(str), (String)"Unhandled operator %s", (Object[])new Object[]{str});
    }

    private static void verifyChildCount(ParseTree tree, int expected) {
        if (tree.getChildCount() != expected) {
            throw XPathParser.illegalShape(tree);
        }
    }

    private static int verifyAtLeastChildren(ParseTree tree, int expected) {
        int count = tree.getChildCount();
        if (count < expected) {
            throw XPathParser.illegalShape(tree);
        }
        return count;
    }

    private static TerminalNode verifyTerminal(ParseTree tree) {
        if (tree instanceof TerminalNode) {
            return (TerminalNode)tree;
        }
        throw new VerifyException(String.format("'%s' is not a terminal node", tree.getText()));
    }

    private static <T extends ParseTree> T verifyTree(Class<T> type, ParseTree tree) {
        if (type.isInstance(tree)) {
            return (T)((ParseTree)type.cast(tree));
        }
        throw new VerifyException(String.format("'%s' does not have expected type %s", tree.getText(), type));
    }

    private static VerifyException illegalShape(ParseTree tree) {
        return new VerifyException(String.format("Invalid parser shape of '%s'", tree.getText()));
    }
}

