/*
 * Decompiled with CFR 0.152.
 */
package org.openfolder.kotlinasyncapi.mavenplugin;

import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.openfolder.kotlinasyncapi.mavenplugin.AsyncApiFileWriter;
import org.openfolder.kotlinasyncapi.mavenplugin.AsyncApiScriptRunner;
import org.openfolder.kotlinasyncapi.model.AsyncApi;
import org.openfolder.kotlinasyncapi.model.channel.ReferencableChannelsMap;
import org.openfolder.kotlinasyncapi.model.info.Info;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00148\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00148\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lorg/openfolder/kotlinasyncapi/mavenplugin/AsyncApiPlugin;", "Lorg/apache/maven/plugin/AbstractMojo;", "scriptRunner", "Lorg/openfolder/kotlinasyncapi/mavenplugin/AsyncApiScriptRunner;", "fileWriter", "Lorg/openfolder/kotlinasyncapi/mavenplugin/AsyncApiFileWriter;", "(Lorg/openfolder/kotlinasyncapi/mavenplugin/AsyncApiScriptRunner;Lorg/openfolder/kotlinasyncapi/mavenplugin/AsyncApiFileWriter;)V", "packageResources", "", "getPackageResources", "()Z", "setPackageResources", "(Z)V", "project", "Lorg/apache/maven/project/MavenProject;", "getProject", "()Lorg/apache/maven/project/MavenProject;", "setProject", "(Lorg/apache/maven/project/MavenProject;)V", "sourcePath", "", "getSourcePath", "()Ljava/lang/String;", "setSourcePath", "(Ljava/lang/String;)V", "targetFileName", "targetPath", "getTargetPath", "setTargetPath", "execute", "", "kotlin-asyncapi-maven-plugin"})
@Mojo(name="generateResources", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresProject=true)
public final class AsyncApiPlugin
extends AbstractMojo {
    @NotNull
    private final AsyncApiScriptRunner scriptRunner;
    @NotNull
    private final AsyncApiFileWriter fileWriter;
    @Parameter(property="sourcePath", defaultValue="build.asyncapi.kts")
    public String sourcePath;
    @Parameter(property="targetPath", defaultValue="asyncapi/generated/")
    public String targetPath;
    @Parameter(property="packageResources", defaultValue="true")
    private boolean packageResources;
    @Parameter(property="project", defaultValue="${project}", readonly=true)
    public MavenProject project;
    @NotNull
    private final String targetFileName;

    @Inject
    public AsyncApiPlugin(@NotNull AsyncApiScriptRunner scriptRunner, @NotNull AsyncApiFileWriter fileWriter) {
        Intrinsics.checkNotNullParameter((Object)scriptRunner, (String)"scriptRunner");
        Intrinsics.checkNotNullParameter((Object)fileWriter, (String)"fileWriter");
        this.scriptRunner = scriptRunner;
        this.fileWriter = fileWriter;
        this.packageResources = true;
        this.targetFileName = "asyncapi.json";
    }

    @NotNull
    public final String getSourcePath() {
        String string = this.sourcePath;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sourcePath");
        return null;
    }

    public final void setSourcePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.sourcePath = string;
    }

    @NotNull
    public final String getTargetPath() {
        String string = this.targetPath;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"targetPath");
        return null;
    }

    public final void setTargetPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.targetPath = string;
    }

    public final boolean getPackageResources() {
        return this.packageResources;
    }

    public final void setPackageResources(boolean bl) {
        this.packageResources = bl;
    }

    @NotNull
    public final MavenProject getProject() {
        MavenProject mavenProject = this.project;
        if (mavenProject != null) {
            return mavenProject;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        return null;
    }

    public final void setProject(@NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"<set-?>");
        this.project = mavenProject;
    }

    public void execute() {
        Info info;
        AsyncApi asyncApi;
        AsyncApi.Companion this_$iv = AsyncApi.Companion;
        boolean $i$f$asyncApi = false;
        AsyncApi $this$execute_u24lambda_u2d2 = asyncApi = new AsyncApi();
        boolean bl = false;
        AsyncApi this_$iv2 = $this$execute_u24lambda_u2d2;
        boolean $i$f$info = false;
        Info $this$execute_u24lambda_u2d2_u24lambda_u2d0 = info = new Info();
        boolean bl2 = false;
        String string = this.getProject().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        $this$execute_u24lambda_u2d2_u24lambda_u2d0.title(string);
        String string2 = this.getProject().getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.version");
        $this$execute_u24lambda_u2d2_u24lambda_u2d0.version(string2);
        String string3 = this.getProject().getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"project.description");
        $this$execute_u24lambda_u2d2_u24lambda_u2d0.description(string3);
        Info it$iv = info;
        boolean bl3 = false;
        this_$iv2.setInfo(it$iv);
        this_$iv2 = $this$execute_u24lambda_u2d2;
        boolean $i$f$channels = false;
        Info $this$execute_u24lambda_u2d2_u24lambda_u2d1 = info = new ReferencableChannelsMap();
        boolean bl4 = false;
        it$iv = info;
        boolean bl5 = false;
        this_$iv2.setChannels((ReferencableChannelsMap)it$iv);
        AsyncApi asyncApi2 = asyncApi;
        this.scriptRunner.run(new File(this.getProject().getBasedir(), this.getSourcePath()), asyncApi2);
        File targetDir = new File(this.getProject().getBasedir(), "target/" + this.getTargetPath());
        this.getLog().info((CharSequence)("Writing " + this.targetFileName + " to " + targetDir));
        this.fileWriter.write(asyncApi2, new File(targetDir, this.targetFileName));
        if (this.packageResources) {
            AsyncApi it = asyncApi = new Resource();
            boolean bl6 = false;
            it.setDirectory(targetDir.getPath());
            it.setIncludes(CollectionsKt.listOf((Object)this.targetFileName));
            it.setTargetPath(this.getTargetPath());
            AsyncApi resource = asyncApi;
            this.getLog().info((CharSequence)("Adding " + targetDir + " to resources"));
            this.getProject().addResource((Resource)resource);
        }
    }
}

