/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@JacksonStdImpl
public class CollectionDeserializer
extends ContainerDeserializerBase<Collection<Object>>
implements ContextualDeserializer {
    private static final long serialVersionUID = -1L;
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected final JsonDeserializer<Object> _delegateDeserializer;

    public CollectionDeserializer(JavaType collectionType, JsonDeserializer<Object> valueDeser, TypeDeserializer valueTypeDeser, ValueInstantiator valueInstantiator) {
        this(collectionType, valueDeser, valueTypeDeser, valueInstantiator, null, null, null);
    }

    protected CollectionDeserializer(JavaType collectionType, JsonDeserializer<Object> valueDeser, TypeDeserializer valueTypeDeser, ValueInstantiator valueInstantiator, JsonDeserializer<Object> delegateDeser, NullValueProvider nuller, Boolean unwrapSingle) {
        super(collectionType, nuller, unwrapSingle);
        this._valueDeserializer = valueDeser;
        this._valueTypeDeserializer = valueTypeDeser;
        this._valueInstantiator = valueInstantiator;
        this._delegateDeserializer = delegateDeser;
    }

    protected CollectionDeserializer(CollectionDeserializer src) {
        super(src);
        this._valueDeserializer = src._valueDeserializer;
        this._valueTypeDeserializer = src._valueTypeDeserializer;
        this._valueInstantiator = src._valueInstantiator;
        this._delegateDeserializer = src._delegateDeserializer;
    }

    protected CollectionDeserializer withResolved(JsonDeserializer<?> dd, JsonDeserializer<?> vd, TypeDeserializer vtd, NullValueProvider nuller, Boolean unwrapSingle) {
        return new CollectionDeserializer(this._containerType, vd, vtd, this._valueInstantiator, dd, nuller, unwrapSingle);
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._valueTypeDeserializer == null && this._delegateDeserializer == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Collection;
    }

    public CollectionDeserializer createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> delegateDeser = null;
        if (this._valueInstantiator != null) {
            JavaType delegateType;
            if (this._valueInstantiator.canCreateUsingDelegate()) {
                delegateType = this._valueInstantiator.getDelegateType(ctxt.getConfig());
                if (delegateType == null) {
                    ctxt.reportBadDefinition(this._containerType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'", this._containerType, this._valueInstantiator.getClass().getName()));
                }
                delegateDeser = this.findDeserializer(ctxt, delegateType, property);
            } else if (this._valueInstantiator.canCreateUsingArrayDelegate()) {
                delegateType = this._valueInstantiator.getArrayDelegateType(ctxt.getConfig());
                if (delegateType == null) {
                    ctxt.reportBadDefinition(this._containerType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingArrayDelegate()', but null for 'getArrayDelegateType()'", this._containerType, this._valueInstantiator.getClass().getName()));
                }
                delegateDeser = this.findDeserializer(ctxt, delegateType, property);
            }
        }
        Boolean unwrapSingle = this.findFormatFeature(ctxt, property, Collection.class, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        JsonDeserializer<Object> valueDeser = this._valueDeserializer;
        valueDeser = this.findConvertingContentDeserializer(ctxt, property, valueDeser);
        JavaType vt = this._containerType.getContentType();
        valueDeser = valueDeser == null ? ctxt.findContextualValueDeserializer(vt, property) : ctxt.handleSecondaryContextualization(valueDeser, property, vt);
        TypeDeserializer valueTypeDeser = this._valueTypeDeserializer;
        if (valueTypeDeser != null) {
            valueTypeDeser = valueTypeDeser.forProperty(property);
        }
        NullValueProvider nuller = this.findContentNullProvider(ctxt, property, valueDeser);
        if (!Objects.equals(unwrapSingle, this._unwrapSingle) || nuller != this._nullProvider || delegateDeser != this._delegateDeserializer || valueDeser != this._valueDeserializer || valueTypeDeser != this._valueTypeDeserializer) {
            return this.withResolved(delegateDeser, valueDeser, valueTypeDeser, nuller, unwrapSingle);
        }
        return this;
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public Collection<Object> deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (this._delegateDeserializer != null) {
            return (Collection)this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p2, ctxt));
        }
        if (p2.isExpectedStartArrayToken()) {
            return this._deserializeFromArray(p2, ctxt, this.createDefaultInstance(ctxt));
        }
        if (p2.hasToken(JsonToken.VALUE_STRING)) {
            return this._deserializeFromString(p2, ctxt, p2.getText());
        }
        return this.handleNonArray(p2, ctxt, this.createDefaultInstance(ctxt));
    }

    protected Collection<Object> createDefaultInstance(DeserializationContext ctxt) throws IOException {
        return (Collection)this._valueInstantiator.createUsingDefault(ctxt);
    }

    @Override
    public Collection<Object> deserialize(JsonParser p2, DeserializationContext ctxt, Collection<Object> result2) throws IOException {
        if (p2.isExpectedStartArrayToken()) {
            return this._deserializeFromArray(p2, ctxt, result2);
        }
        return this.handleNonArray(p2, ctxt, result2);
    }

    @Override
    public Object deserializeWithType(JsonParser p2, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(p2, ctxt);
    }

    protected Collection<Object> _deserializeFromString(JsonParser p2, DeserializationContext ctxt, String value2) throws IOException {
        Class<?> rawTargetType = this.handledType();
        if (value2.isEmpty()) {
            CoercionAction act = ctxt.findCoercionAction(this.logicalType(), rawTargetType, CoercionInputShape.EmptyString);
            if ((act = this._checkCoercionFail(ctxt, act, rawTargetType, value2, "empty String (\"\")")) != null) {
                return (Collection)this._deserializeFromEmptyString(p2, ctxt, act, rawTargetType, "empty String (\"\")");
            }
        } else if (CollectionDeserializer._isBlank(value2)) {
            CoercionAction act = ctxt.findCoercionFromBlankString(this.logicalType(), rawTargetType, CoercionAction.Fail);
            return (Collection)this._deserializeFromEmptyString(p2, ctxt, act, rawTargetType, "blank String (all whitespace)");
        }
        return this.handleNonArray(p2, ctxt, this.createDefaultInstance(ctxt));
    }

    protected Collection<Object> _deserializeFromArray(JsonParser p2, DeserializationContext ctxt, Collection<Object> result2) throws IOException {
        JsonToken t;
        p2.setCurrentValue(result2);
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        if (valueDes.getObjectIdReader() != null) {
            return this._deserializeWithObjectId(p2, ctxt, result2);
        }
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        while ((t = p2.nextToken()) != JsonToken.END_ARRAY) {
            try {
                Object value2;
                if (t == JsonToken.VALUE_NULL) {
                    if (this._skipNullValues) continue;
                    value2 = this._nullProvider.getNullValue(ctxt);
                } else {
                    value2 = typeDeser == null ? valueDes.deserialize(p2, ctxt) : valueDes.deserializeWithType(p2, ctxt, typeDeser);
                }
                result2.add(value2);
            }
            catch (Exception e) {
                boolean wrap2;
                boolean bl = wrap2 = ctxt == null || ctxt.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
                if (!wrap2) {
                    ClassUtil.throwIfRTE(e);
                }
                throw JsonMappingException.wrapWithPath((Throwable)e, result2, result2.size());
            }
        }
        return result2;
    }

    protected final Collection<Object> handleNonArray(JsonParser p2, DeserializationContext ctxt, Collection<Object> result2) throws IOException {
        Object value2;
        boolean canWrap;
        boolean bl = canWrap = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (!canWrap) {
            return (Collection)ctxt.handleUnexpectedToken(this._containerType, p2);
        }
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        try {
            if (p2.hasToken(JsonToken.VALUE_NULL)) {
                if (this._skipNullValues) {
                    return result2;
                }
                value2 = this._nullProvider.getNullValue(ctxt);
            } else {
                value2 = typeDeser == null ? valueDes.deserialize(p2, ctxt) : valueDes.deserializeWithType(p2, ctxt, typeDeser);
            }
        }
        catch (Exception e) {
            boolean wrap2 = ctxt.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
            if (!wrap2) {
                ClassUtil.throwIfRTE(e);
            }
            throw JsonMappingException.wrapWithPath((Throwable)e, Object.class, result2.size());
        }
        result2.add(value2);
        return result2;
    }

    protected Collection<Object> _deserializeWithObjectId(JsonParser p2, DeserializationContext ctxt, Collection<Object> result2) throws IOException {
        JsonToken t;
        if (!p2.isExpectedStartArrayToken()) {
            return this.handleNonArray(p2, ctxt, result2);
        }
        p2.setCurrentValue(result2);
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        CollectionReferringAccumulator referringAccumulator = new CollectionReferringAccumulator(this._containerType.getContentType().getRawClass(), result2);
        while ((t = p2.nextToken()) != JsonToken.END_ARRAY) {
            try {
                Object value2;
                if (t == JsonToken.VALUE_NULL) {
                    if (this._skipNullValues) continue;
                    value2 = this._nullProvider.getNullValue(ctxt);
                } else {
                    value2 = typeDeser == null ? valueDes.deserialize(p2, ctxt) : valueDes.deserializeWithType(p2, ctxt, typeDeser);
                }
                referringAccumulator.add(value2);
            }
            catch (UnresolvedForwardReference reference2) {
                ReadableObjectId.Referring ref = referringAccumulator.handleUnresolvedReference(reference2);
                reference2.getRoid().appendReferring(ref);
            }
            catch (Exception e) {
                boolean wrap2;
                boolean bl = wrap2 = ctxt == null || ctxt.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
                if (!wrap2) {
                    ClassUtil.throwIfRTE(e);
                }
                throw JsonMappingException.wrapWithPath((Throwable)e, result2, result2.size());
            }
        }
        return result2;
    }

    private static final class CollectionReferring
    extends ReadableObjectId.Referring {
        private final CollectionReferringAccumulator _parent;
        public final List<Object> next = new ArrayList<Object>();

        CollectionReferring(CollectionReferringAccumulator parent, UnresolvedForwardReference reference2, Class<?> contentType) {
            super(reference2, contentType);
            this._parent = parent;
        }

        @Override
        public void handleResolvedForwardReference(Object id2, Object value2) throws IOException {
            this._parent.resolveForwardReference(id2, value2);
        }
    }

    public static class CollectionReferringAccumulator {
        private final Class<?> _elementType;
        private final Collection<Object> _result;
        private List<CollectionReferring> _accumulator = new ArrayList<CollectionReferring>();

        public CollectionReferringAccumulator(Class<?> elementType, Collection<Object> result2) {
            this._elementType = elementType;
            this._result = result2;
        }

        public void add(Object value2) {
            if (this._accumulator.isEmpty()) {
                this._result.add(value2);
            } else {
                CollectionReferring ref = this._accumulator.get(this._accumulator.size() - 1);
                ref.next.add(value2);
            }
        }

        public ReadableObjectId.Referring handleUnresolvedReference(UnresolvedForwardReference reference2) {
            CollectionReferring id2 = new CollectionReferring(this, reference2, this._elementType);
            this._accumulator.add(id2);
            return id2;
        }

        public void resolveForwardReference(Object id2, Object value2) throws IOException {
            Iterator<CollectionReferring> iterator = this._accumulator.iterator();
            Collection<Object> previous = this._result;
            while (iterator.hasNext()) {
                CollectionReferring ref = iterator.next();
                if (ref.hasId(id2)) {
                    iterator.remove();
                    previous.add(value2);
                    previous.addAll(ref.next);
                    return;
                }
                previous = ref.next;
            }
            throw new IllegalArgumentException("Trying to resolve a forward reference with id [" + id2 + "] that wasn't previously seen as unresolved.");
        }
    }
}

