/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.CollectorBase;
import com.fasterxml.jackson.databind.introspect.MemberKey;
import com.fasterxml.jackson.databind.introspect.MethodGenericTypeResolver;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class AnnotatedCreatorCollector
extends CollectorBase {
    private final TypeResolutionContext _typeContext;
    private final boolean _collectAnnotations;
    private AnnotatedConstructor _defaultConstructor;

    AnnotatedCreatorCollector(AnnotationIntrospector intr, TypeResolutionContext tc, boolean collectAnnotations) {
        super(intr);
        this._typeContext = tc;
        this._collectAnnotations = collectAnnotations;
    }

    public static AnnotatedClass.Creators collectCreators(AnnotationIntrospector intr, TypeFactory typeFactory, TypeResolutionContext tc, JavaType type2, Class<?> primaryMixIn, boolean collectAnnotations) {
        return new AnnotatedCreatorCollector(intr, tc, collectAnnotations |= primaryMixIn != null).collect(typeFactory, type2, primaryMixIn);
    }

    AnnotatedClass.Creators collect(TypeFactory typeFactory, JavaType type2, Class<?> primaryMixIn) {
        List<AnnotatedConstructor> constructors2 = this._findPotentialConstructors(type2, primaryMixIn);
        List<AnnotatedMethod> factories = this._findPotentialFactories(typeFactory, type2, primaryMixIn);
        if (this._collectAnnotations) {
            if (this._defaultConstructor != null && this._intr.hasIgnoreMarker(this._defaultConstructor)) {
                this._defaultConstructor = null;
            }
            int i2 = constructors2.size();
            while (--i2 >= 0) {
                if (!this._intr.hasIgnoreMarker(constructors2.get(i2))) continue;
                constructors2.remove(i2);
            }
            i2 = factories.size();
            while (--i2 >= 0) {
                if (!this._intr.hasIgnoreMarker(factories.get(i2))) continue;
                factories.remove(i2);
            }
        }
        return new AnnotatedClass.Creators(this._defaultConstructor, constructors2, factories);
    }

    private List<AnnotatedConstructor> _findPotentialConstructors(JavaType type2, Class<?> primaryMixIn) {
        int ctorCount;
        List<AnnotatedConstructor> result2;
        ClassUtil.Ctor defaultCtor = null;
        ArrayList<ClassUtil.Ctor> ctors = null;
        if (!type2.isEnumType()) {
            ClassUtil.Ctor[] declaredCtors;
            for (ClassUtil.Ctor ctor : declaredCtors = ClassUtil.getConstructors(type2.getRawClass())) {
                if (!AnnotatedCreatorCollector.isIncludableConstructor(ctor.getConstructor())) continue;
                if (ctor.getParamCount() == 0) {
                    defaultCtor = ctor;
                    continue;
                }
                if (ctors == null) {
                    ctors = new ArrayList<ClassUtil.Ctor>();
                }
                ctors.add(ctor);
            }
        }
        if (ctors == null) {
            result2 = Collections.emptyList();
            if (defaultCtor == null) {
                return result2;
            }
            ctorCount = 0;
        } else {
            ctorCount = ctors.size();
            result2 = new ArrayList<AnnotatedConstructor>(ctorCount);
            for (int i2 = 0; i2 < ctorCount; ++i2) {
                result2.add(null);
            }
        }
        if (primaryMixIn != null) {
            MemberKey[] ctorKeys = null;
            block2: for (ClassUtil.Ctor mixinCtor : ClassUtil.getConstructors(primaryMixIn)) {
                if (mixinCtor.getParamCount() == 0) {
                    if (defaultCtor == null) continue;
                    this._defaultConstructor = this.constructDefaultConstructor(defaultCtor, mixinCtor);
                    defaultCtor = null;
                    continue;
                }
                if (ctors == null) continue;
                if (ctorKeys == null) {
                    ctorKeys = new MemberKey[ctorCount];
                    for (int i3 = 0; i3 < ctorCount; ++i3) {
                        ctorKeys[i3] = new MemberKey(((ClassUtil.Ctor)ctors.get(i3)).getConstructor());
                    }
                }
                MemberKey key2 = new MemberKey(mixinCtor.getConstructor());
                for (int i4 = 0; i4 < ctorCount; ++i4) {
                    if (!key2.equals(ctorKeys[i4])) continue;
                    result2.set(i4, this.constructNonDefaultConstructor((ClassUtil.Ctor)ctors.get(i4), mixinCtor));
                    continue block2;
                }
            }
        }
        if (defaultCtor != null) {
            this._defaultConstructor = this.constructDefaultConstructor(defaultCtor, null);
        }
        for (int i5 = 0; i5 < ctorCount; ++i5) {
            AnnotatedConstructor ctor = result2.get(i5);
            if (ctor != null) continue;
            result2.set(i5, this.constructNonDefaultConstructor((ClassUtil.Ctor)ctors.get(i5), null));
        }
        return result2;
    }

    private List<AnnotatedMethod> _findPotentialFactories(TypeFactory typeFactory, JavaType type2, Class<?> primaryMixIn) {
        ArrayList<Method> candidates = null;
        for (Method m3 : ClassUtil.getClassMethods(type2.getRawClass())) {
            if (!AnnotatedCreatorCollector._isIncludableFactoryMethod(m3)) continue;
            if (candidates == null) {
                candidates = new ArrayList<Method>();
            }
            candidates.add(m3);
        }
        if (candidates == null) {
            return Collections.emptyList();
        }
        TypeResolutionContext initialTypeResCtxt = this._typeContext;
        int factoryCount = candidates.size();
        ArrayList<AnnotatedMethod> result2 = new ArrayList<AnnotatedMethod>(factoryCount);
        for (int i2 = 0; i2 < factoryCount; ++i2) {
            result2.add(null);
        }
        if (primaryMixIn != null) {
            MemberKey[] methodKeys = null;
            block2: for (Method mixinFactory : primaryMixIn.getDeclaredMethods()) {
                if (!AnnotatedCreatorCollector._isIncludableFactoryMethod(mixinFactory)) continue;
                if (methodKeys == null) {
                    methodKeys = new MemberKey[factoryCount];
                    for (int i3 = 0; i3 < factoryCount; ++i3) {
                        methodKeys[i3] = new MemberKey((Method)candidates.get(i3));
                    }
                }
                MemberKey key2 = new MemberKey(mixinFactory);
                for (int i4 = 0; i4 < factoryCount; ++i4) {
                    if (!key2.equals(methodKeys[i4])) continue;
                    result2.set(i4, this.constructFactoryCreator((Method)candidates.get(i4), initialTypeResCtxt, mixinFactory));
                    continue block2;
                }
            }
        }
        for (int i5 = 0; i5 < factoryCount; ++i5) {
            AnnotatedMethod factory = (AnnotatedMethod)result2.get(i5);
            if (factory != null) continue;
            Method candidate = (Method)candidates.get(i5);
            TypeResolutionContext typeResCtxt = MethodGenericTypeResolver.narrowMethodTypeParameters(candidate, type2, typeFactory, initialTypeResCtxt);
            result2.set(i5, this.constructFactoryCreator(candidate, typeResCtxt, null));
        }
        return result2;
    }

    private static boolean _isIncludableFactoryMethod(Method m3) {
        return Modifier.isStatic(m3.getModifiers()) && !m3.isSynthetic();
    }

    protected AnnotatedConstructor constructDefaultConstructor(ClassUtil.Ctor ctor, ClassUtil.Ctor mixin) {
        return new AnnotatedConstructor(this._typeContext, ctor.getConstructor(), this.collectAnnotations(ctor, mixin), NO_ANNOTATION_MAPS);
    }

    protected AnnotatedConstructor constructNonDefaultConstructor(ClassUtil.Ctor ctor, ClassUtil.Ctor mixin) {
        AnnotationMap[] resolvedAnnotations;
        int paramCount = ctor.getParamCount();
        if (this._intr == null) {
            return new AnnotatedConstructor(this._typeContext, ctor.getConstructor(), AnnotatedCreatorCollector._emptyAnnotationMap(), AnnotatedCreatorCollector._emptyAnnotationMaps(paramCount));
        }
        if (paramCount == 0) {
            return new AnnotatedConstructor(this._typeContext, ctor.getConstructor(), this.collectAnnotations(ctor, mixin), NO_ANNOTATION_MAPS);
        }
        Annotation[][] paramAnns = ctor.getParameterAnnotations();
        if (paramCount != paramAnns.length) {
            resolvedAnnotations = null;
            Class<?> dc = ctor.getDeclaringClass();
            if (ClassUtil.isEnumType(dc) && paramCount == paramAnns.length + 2) {
                Annotation[][] old = paramAnns;
                paramAnns = new Annotation[old.length + 2][];
                System.arraycopy(old, 0, paramAnns, 2, old.length);
                resolvedAnnotations = this.collectAnnotations(paramAnns, (Annotation[][])null);
            } else if (dc.isMemberClass() && paramCount == paramAnns.length + 1) {
                Annotation[][] old = paramAnns;
                paramAnns = new Annotation[old.length + 1][];
                System.arraycopy(old, 0, paramAnns, 1, old.length);
                paramAnns[0] = NO_ANNOTATIONS;
                resolvedAnnotations = this.collectAnnotations(paramAnns, (Annotation[][])null);
            }
            if (resolvedAnnotations == null) {
                throw new IllegalStateException(String.format("Internal error: constructor for %s has mismatch: %d parameters; %d sets of annotations", ctor.getDeclaringClass().getName(), paramCount, paramAnns.length));
            }
        } else {
            resolvedAnnotations = this.collectAnnotations(paramAnns, mixin == null ? (Annotation[][])null : mixin.getParameterAnnotations());
        }
        return new AnnotatedConstructor(this._typeContext, ctor.getConstructor(), this.collectAnnotations(ctor, mixin), resolvedAnnotations);
    }

    protected AnnotatedMethod constructFactoryCreator(Method m3, TypeResolutionContext typeResCtxt, Method mixin) {
        int paramCount = m3.getParameterTypes().length;
        if (this._intr == null) {
            return new AnnotatedMethod(typeResCtxt, m3, AnnotatedCreatorCollector._emptyAnnotationMap(), AnnotatedCreatorCollector._emptyAnnotationMaps(paramCount));
        }
        if (paramCount == 0) {
            return new AnnotatedMethod(typeResCtxt, m3, this.collectAnnotations(m3, mixin), NO_ANNOTATION_MAPS);
        }
        return new AnnotatedMethod(typeResCtxt, m3, this.collectAnnotations(m3, mixin), this.collectAnnotations(m3.getParameterAnnotations(), mixin == null ? (Annotation[][])null : mixin.getParameterAnnotations()));
    }

    private AnnotationMap[] collectAnnotations(Annotation[][] mainAnns, Annotation[][] mixinAnns) {
        if (this._collectAnnotations) {
            int count2 = mainAnns.length;
            AnnotationMap[] result2 = new AnnotationMap[count2];
            for (int i2 = 0; i2 < count2; ++i2) {
                AnnotationCollector c = this.collectAnnotations(AnnotationCollector.emptyCollector(), mainAnns[i2]);
                if (mixinAnns != null) {
                    c = this.collectAnnotations(c, mixinAnns[i2]);
                }
                result2[i2] = c.asAnnotationMap();
            }
            return result2;
        }
        return NO_ANNOTATION_MAPS;
    }

    private AnnotationMap collectAnnotations(ClassUtil.Ctor main2, ClassUtil.Ctor mixin) {
        if (this._collectAnnotations) {
            AnnotationCollector c = this.collectAnnotations(main2.getDeclaredAnnotations());
            if (mixin != null) {
                c = this.collectAnnotations(c, mixin.getDeclaredAnnotations());
            }
            return c.asAnnotationMap();
        }
        return AnnotatedCreatorCollector._emptyAnnotationMap();
    }

    private final AnnotationMap collectAnnotations(AnnotatedElement main2, AnnotatedElement mixin) {
        AnnotationCollector c = this.collectAnnotations(main2.getDeclaredAnnotations());
        if (mixin != null) {
            c = this.collectAnnotations(c, mixin.getDeclaredAnnotations());
        }
        return c.asAnnotationMap();
    }

    private static boolean isIncludableConstructor(Constructor<?> c) {
        return !c.isSynthetic();
    }
}

