/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class InetSocketAddressSerializer
extends StdScalarSerializer<InetSocketAddress> {
    public InetSocketAddressSerializer() {
        super(InetSocketAddress.class);
    }

    @Override
    public void serialize(InetSocketAddress value2, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        InetAddress addr2 = value2.getAddress();
        String str = addr2 == null ? value2.getHostName() : addr2.toString().trim();
        int ix = str.indexOf(47);
        if (ix >= 0) {
            str = ix == 0 ? (addr2 instanceof Inet6Address ? "[" + str.substring(1) + "]" : str.substring(1)) : str.substring(0, ix);
        }
        jgen.writeString(str + ":" + value2.getPort());
    }

    @Override
    public void serializeWithType(InetSocketAddress value2, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId((Object)value2, InetSocketAddress.class, JsonToken.VALUE_STRING));
        this.serialize(value2, g2, provider);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }
}

