/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.AnySchema;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.BooleanSchema;
import com.fasterxml.jackson.module.jsonSchema.types.IntegerSchema;
import com.fasterxml.jackson.module.jsonSchema.types.NullSchema;
import com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import java.lang.reflect.Type;
import java.util.Arrays;

public class JsonSchemaIdResolver
extends TypeIdResolverBase {
    @Override
    public String idFromValue(Object value2) {
        if (value2 instanceof JsonSchema) {
            return ((JsonSchema)value2).getType().value();
        }
        return null;
    }

    @Override
    public String idFromValueAndType(Object value2, Class<?> suggestedType) {
        return this.idFromValue(value2);
    }

    @Override
    public JavaType typeFromId(DatabindContext ctxt, String id2) {
        JsonFormatTypes stdType = JsonFormatTypes.forValue(id2);
        if (stdType != null) {
            switch (stdType) {
                case ARRAY: {
                    return ctxt.constructType((Type)((Object)ArraySchema.class));
                }
                case BOOLEAN: {
                    return ctxt.constructType((Type)((Object)BooleanSchema.class));
                }
                case INTEGER: {
                    return ctxt.constructType((Type)((Object)IntegerSchema.class));
                }
                case NULL: {
                    return ctxt.constructType((Type)((Object)NullSchema.class));
                }
                case NUMBER: {
                    return ctxt.constructType((Type)((Object)NumberSchema.class));
                }
                case OBJECT: {
                    return ctxt.constructType((Type)((Object)ObjectSchema.class));
                }
                case STRING: {
                    return ctxt.constructType((Type)((Object)StringSchema.class));
                }
            }
            return ctxt.constructType((Type)((Object)AnySchema.class));
        }
        throw new IllegalArgumentException("Can not resolve JsonSchema 'type' id of \"" + id2 + "\", not recognized as one of standard values: " + Arrays.asList(JsonFormatTypes.values()));
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    @Override
    public void init(JavaType baseType) {
    }

    @Override
    public String idFromBaseType() {
        return null;
    }
}

