/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.customProperties;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.annotation.JsonHyperSchema;
import com.fasterxml.jackson.module.jsonSchema.annotation.Link;
import com.fasterxml.jackson.module.jsonSchema.factories.ArrayVisitor;
import com.fasterxml.jackson.module.jsonSchema.factories.ObjectVisitor;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import com.fasterxml.jackson.module.jsonSchema.types.LinkDescriptionObject;
import com.fasterxml.jackson.module.jsonSchema.types.ReferenceSchema;
import com.fasterxml.jackson.module.jsonSchema.types.SimpleTypeSchema;

public class HyperSchemaFactoryWrapper
extends SchemaFactoryWrapper {
    private boolean ignoreDefaults = true;

    public HyperSchemaFactoryWrapper() {
        super(new HyperSchemaFactoryWrapperFactory());
    }

    public HyperSchemaFactoryWrapper(SerializerProvider p2) {
        super(p2, new HyperSchemaFactoryWrapperFactory());
    }

    @Override
    public JsonObjectFormatVisitor expectObjectFormat(JavaType convertedType) {
        ObjectVisitor visitor = (ObjectVisitor)super.expectObjectFormat(convertedType);
        this.addHyperlinks(visitor.getSchema(), convertedType);
        return visitor;
    }

    @Override
    public JsonArrayFormatVisitor expectArrayFormat(JavaType convertedType) {
        ArrayVisitor visitor = (ArrayVisitor)super.expectArrayFormat(convertedType);
        this.addHyperlinks(visitor.getSchema(), convertedType);
        return visitor;
    }

    public void setIgnoreDefaults(boolean ignoreDefaults) {
        this.ignoreDefaults = ignoreDefaults;
    }

    private void addHyperlinks(JsonSchema schema, JavaType type2) {
        if (!schema.isSimpleTypeSchema()) {
            throw new RuntimeException("given non simple type schema: " + (Object)((Object)schema.getType()));
        }
        Class<?> rawClass = type2.getRawClass();
        if (rawClass.isAnnotationPresent(JsonHyperSchema.class)) {
            JsonHyperSchema hyperSchema = rawClass.getAnnotation(JsonHyperSchema.class);
            String pathStart = hyperSchema.pathStart();
            Link[] links = hyperSchema.links();
            LinkDescriptionObject[] linkDescriptionObjects = new LinkDescriptionObject[links.length];
            for (int i2 = 0; i2 < links.length; ++i2) {
                Link link2 = links[i2];
                linkDescriptionObjects[i2] = new LinkDescriptionObject().setHref(pathStart + link2.href()).setRel(link2.rel()).setMethod((String)(this.ignoreDefaults && "GET".equals(link2.method()) ? null : link2.method())).setEnctype((String)(this.ignoreDefaults && "application/json".equals(link2.enctype()) ? null : link2.enctype())).setTargetSchema(this.fetchSchema(link2.targetSchema())).setSchema(this.fetchSchema(link2.schema())).setMediaType((String)(this.ignoreDefaults && "application/json".equals(link2.mediaType()) ? null : link2.mediaType())).setTitle(link2.title());
            }
            SimpleTypeSchema simpleTypeSchema = schema.asSimpleTypeSchema();
            simpleTypeSchema.setLinks(linkDescriptionObjects);
            if (pathStart != null && pathStart.length() != 0) {
                simpleTypeSchema.setPathStart(pathStart);
            }
        }
    }

    private JsonSchema fetchSchema(Class<?> targetSchema) {
        if (this.provider instanceof DefaultSerializerProvider && targetSchema != Void.TYPE) {
            JavaType targetType = this.provider.constructType(targetSchema);
            try {
                String seenSchemaUri;
                if (this.visitorContext != null && (seenSchemaUri = this.visitorContext.getSeenSchemaUri(targetType)) != null) {
                    return new ReferenceSchema(seenSchemaUri);
                }
                HyperSchemaFactoryWrapper targetVisitor = new HyperSchemaFactoryWrapper();
                targetVisitor.setVisitorContext(this.visitorContext);
                ((DefaultSerializerProvider)this.provider).acceptJsonFormatVisitor(targetType, targetVisitor);
                return targetVisitor.finalSchema();
            }
            catch (JsonMappingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static class HyperSchemaFactoryWrapperFactory
    extends WrapperFactory {
        private HyperSchemaFactoryWrapperFactory() {
        }

        @Override
        public SchemaFactoryWrapper getWrapper(SerializerProvider p2) {
            return new HyperSchemaFactoryWrapper(p2);
        }

        @Override
        public SchemaFactoryWrapper getWrapper(SerializerProvider p2, VisitorContext rvc) {
            return new HyperSchemaFactoryWrapper(p2).setVisitorContext(rvc);
        }
    }
}

