/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.customProperties;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.ArrayVisitor;
import com.fasterxml.jackson.module.jsonSchema.factories.ObjectVisitor;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;

public class TitleSchemaFactoryWrapper
extends SchemaFactoryWrapper {
    public TitleSchemaFactoryWrapper() {
        super(new TitleSchemaFactoryWrapperFactory());
    }

    @Override
    public JsonObjectFormatVisitor expectObjectFormat(JavaType convertedType) {
        ObjectVisitor visitor = (ObjectVisitor)super.expectObjectFormat(convertedType);
        this.addTitle(visitor.getSchema(), convertedType);
        return visitor;
    }

    @Override
    public JsonArrayFormatVisitor expectArrayFormat(JavaType convertedType) {
        ArrayVisitor visitor = (ArrayVisitor)super.expectArrayFormat(convertedType);
        this.addTitle(visitor.getSchema(), convertedType);
        return visitor;
    }

    private void addTitle(JsonSchema schema, JavaType type2) {
        if (!schema.isSimpleTypeSchema()) {
            throw new RuntimeException("given non simple type schema: " + (Object)((Object)schema.getType()));
        }
        schema.asSimpleTypeSchema().setTitle(type2.getGenericSignature());
    }

    private static class TitleSchemaFactoryWrapperFactory
    extends WrapperFactory {
        private TitleSchemaFactoryWrapperFactory() {
        }

        @Override
        public SchemaFactoryWrapper getWrapper(SerializerProvider p2) {
            TitleSchemaFactoryWrapper wrapper = new TitleSchemaFactoryWrapper();
            if (p2 != null) {
                wrapper.setProvider(p2);
            }
            return wrapper;
        }

        @Override
        public SchemaFactoryWrapper getWrapper(SerializerProvider p2, VisitorContext rvc) {
            TitleSchemaFactoryWrapper wrapper = new TitleSchemaFactoryWrapper();
            if (p2 != null) {
                wrapper.setProvider(p2);
            }
            wrapper.setVisitorContext(rvc);
            return wrapper;
        }
    }
}

