/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(@Nullable String string2) {
        return Platform.nullToEmpty(string2);
    }

    public static @Nullable String emptyToNull(@Nullable String string2) {
        return Platform.emptyToNull(string2);
    }

    public static boolean isNullOrEmpty(@Nullable String string2) {
        return Platform.stringIsNullOrEmpty(string2);
    }

    public static String padStart(String string2, int minLength, char padChar) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= minLength) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i2 = string2.length(); i2 < minLength; ++i2) {
            sb.append(padChar);
        }
        sb.append(string2);
        return sb.toString();
    }

    public static String padEnd(String string2, int minLength, char padChar) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= minLength) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(string2);
        for (int i2 = string2.length(); i2 < minLength; ++i2) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String repeat(String string2, int count2) {
        int n;
        Preconditions.checkNotNull(string2);
        if (count2 <= 1) {
            Preconditions.checkArgument(count2 >= 0, "invalid count: %s", count2);
            return count2 == 0 ? "" : string2;
        }
        int len = string2.length();
        long longSize = (long)len * (long)count2;
        int size2 = (int)longSize;
        if ((long)size2 != longSize) {
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(51).append("Required array size too large: ").append(longSize).toString());
        }
        char[] array2 = new char[size2];
        string2.getChars(0, len, array2, 0);
        for (n = len; n < size2 - n; n <<= 1) {
            System.arraycopy(array2, 0, array2, n, n);
        }
        System.arraycopy(array2, 0, array2, n, size2 - n);
        return new String(array2);
    }

    public static String commonPrefix(CharSequence a, CharSequence b2) {
        int p2;
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b2);
        int maxPrefixLength = Math.min(a.length(), b2.length());
        for (p2 = 0; p2 < maxPrefixLength && a.charAt(p2) == b2.charAt(p2); ++p2) {
        }
        if (Strings.validSurrogatePairAt(a, p2 - 1) || Strings.validSurrogatePairAt(b2, p2 - 1)) {
            --p2;
        }
        return a.subSequence(0, p2).toString();
    }

    public static String commonSuffix(CharSequence a, CharSequence b2) {
        int s2;
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b2);
        int maxSuffixLength = Math.min(a.length(), b2.length());
        for (s2 = 0; s2 < maxSuffixLength && a.charAt(a.length() - s2 - 1) == b2.charAt(b2.length() - s2 - 1); ++s2) {
        }
        if (Strings.validSurrogatePairAt(a, a.length() - s2 - 1) || Strings.validSurrogatePairAt(b2, b2.length() - s2 - 1)) {
            --s2;
        }
        return a.subSequence(a.length() - s2, a.length()).toString();
    }

    @VisibleForTesting
    static boolean validSurrogatePairAt(CharSequence string2, int index2) {
        return index2 >= 0 && index2 <= string2.length() - 2 && Character.isHighSurrogate(string2.charAt(index2)) && Character.isLowSurrogate(string2.charAt(index2 + 1));
    }

    public static String lenientFormat(@Nullable String template, Object ... args2) {
        int placeholderStart;
        template = String.valueOf(template);
        if (args2 == null) {
            args2 = new Object[]{"(Object[])null"};
        } else {
            for (int i2 = 0; i2 < args2.length; ++i2) {
                args2[i2] = Strings.lenientToString(args2[i2]);
            }
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args2.length);
        int templateStart = 0;
        int i3 = 0;
        while (i3 < args2.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args2[i3++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i3 < args2.length) {
            builder.append(" [");
            builder.append(args2[i3++]);
            while (i3 < args2.length) {
                builder.append(", ");
                builder.append(args2[i3++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private static String lenientToString(@Nullable Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString();
        }
        catch (Exception e) {
            String string2 = o.getClass().getName();
            String string3 = Integer.toHexString(System.identityHashCode(o));
            String objectToString = new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append('@').append(string3).toString();
            String string4 = String.valueOf(objectToString);
            Logger.getLogger("com.google.common.base.Strings").log(Level.WARNING, string4.length() != 0 ? "Exception during lenientFormat for ".concat(string4) : new String("Exception during lenientFormat for "), e);
            string2 = e.getClass().getName();
            return new StringBuilder(9 + String.valueOf(objectToString).length() + String.valueOf(string2).length()).append("<").append(objectToString).append(" threw ").append(string2).append(">").toString();
        }
    }
}

