/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@CanIgnoreReturnValue
abstract class AbstractByteHasher
extends AbstractHasher {
    private final ByteBuffer scratch = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);

    AbstractByteHasher() {
    }

    protected abstract void update(byte var1);

    protected void update(byte[] b2) {
        this.update(b2, 0, b2.length);
    }

    protected void update(byte[] b2, int off, int len) {
        for (int i2 = off; i2 < off + len; ++i2) {
            this.update(b2[i2]);
        }
    }

    protected void update(ByteBuffer b2) {
        if (b2.hasArray()) {
            this.update(b2.array(), b2.arrayOffset() + b2.position(), b2.remaining());
            Java8Compatibility.position(b2, b2.limit());
        } else {
            for (int remaining = b2.remaining(); remaining > 0; --remaining) {
                this.update(b2.get());
            }
        }
    }

    private Hasher update(int bytes2) {
        try {
            this.update(this.scratch.array(), 0, bytes2);
        }
        finally {
            Java8Compatibility.clear(this.scratch);
        }
        return this;
    }

    @Override
    public Hasher putByte(byte b2) {
        this.update(b2);
        return this;
    }

    @Override
    public Hasher putBytes(byte[] bytes2) {
        Preconditions.checkNotNull(bytes2);
        this.update(bytes2);
        return this;
    }

    @Override
    public Hasher putBytes(byte[] bytes2, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, bytes2.length);
        this.update(bytes2, off, len);
        return this;
    }

    @Override
    public Hasher putBytes(ByteBuffer bytes2) {
        this.update(bytes2);
        return this;
    }

    @Override
    public Hasher putShort(short s2) {
        this.scratch.putShort(s2);
        return this.update(2);
    }

    @Override
    public Hasher putInt(int i2) {
        this.scratch.putInt(i2);
        return this.update(4);
    }

    @Override
    public Hasher putLong(long l) {
        this.scratch.putLong(l);
        return this.update(8);
    }

    @Override
    public Hasher putChar(char c) {
        this.scratch.putChar(c);
        return this.update(2);
    }
}

