/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import com.google.errorprone.annotations.Immutable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@Immutable
abstract class AbstractCompositeHashFunction
extends AbstractHashFunction {
    final HashFunction[] functions;
    private static final long serialVersionUID = 0L;

    AbstractCompositeHashFunction(HashFunction ... functions) {
        for (HashFunction function : functions) {
            Preconditions.checkNotNull(function);
        }
        this.functions = functions;
    }

    abstract HashCode makeHash(Hasher[] var1);

    @Override
    public Hasher newHasher() {
        Hasher[] hashers = new Hasher[this.functions.length];
        for (int i2 = 0; i2 < hashers.length; ++i2) {
            hashers[i2] = this.functions[i2].newHasher();
        }
        return this.fromHashers(hashers);
    }

    @Override
    public Hasher newHasher(int expectedInputSize) {
        Preconditions.checkArgument(expectedInputSize >= 0);
        Hasher[] hashers = new Hasher[this.functions.length];
        for (int i2 = 0; i2 < hashers.length; ++i2) {
            hashers[i2] = this.functions[i2].newHasher(expectedInputSize);
        }
        return this.fromHashers(hashers);
    }

    private Hasher fromHashers(final Hasher[] hashers) {
        return new Hasher(){

            @Override
            public Hasher putByte(byte b2) {
                for (Hasher hasher : hashers) {
                    hasher.putByte(b2);
                }
                return this;
            }

            @Override
            public Hasher putBytes(byte[] bytes2) {
                for (Hasher hasher : hashers) {
                    hasher.putBytes(bytes2);
                }
                return this;
            }

            @Override
            public Hasher putBytes(byte[] bytes2, int off, int len) {
                for (Hasher hasher : hashers) {
                    hasher.putBytes(bytes2, off, len);
                }
                return this;
            }

            @Override
            public Hasher putBytes(ByteBuffer bytes2) {
                int pos2 = bytes2.position();
                for (Hasher hasher : hashers) {
                    Java8Compatibility.position(bytes2, pos2);
                    hasher.putBytes(bytes2);
                }
                return this;
            }

            @Override
            public Hasher putShort(short s2) {
                for (Hasher hasher : hashers) {
                    hasher.putShort(s2);
                }
                return this;
            }

            @Override
            public Hasher putInt(int i2) {
                for (Hasher hasher : hashers) {
                    hasher.putInt(i2);
                }
                return this;
            }

            @Override
            public Hasher putLong(long l) {
                for (Hasher hasher : hashers) {
                    hasher.putLong(l);
                }
                return this;
            }

            @Override
            public Hasher putFloat(float f) {
                for (Hasher hasher : hashers) {
                    hasher.putFloat(f);
                }
                return this;
            }

            @Override
            public Hasher putDouble(double d) {
                for (Hasher hasher : hashers) {
                    hasher.putDouble(d);
                }
                return this;
            }

            @Override
            public Hasher putBoolean(boolean b2) {
                for (Hasher hasher : hashers) {
                    hasher.putBoolean(b2);
                }
                return this;
            }

            @Override
            public Hasher putChar(char c) {
                for (Hasher hasher : hashers) {
                    hasher.putChar(c);
                }
                return this;
            }

            @Override
            public Hasher putUnencodedChars(CharSequence chars2) {
                for (Hasher hasher : hashers) {
                    hasher.putUnencodedChars(chars2);
                }
                return this;
            }

            @Override
            public Hasher putString(CharSequence chars2, Charset charset) {
                for (Hasher hasher : hashers) {
                    hasher.putString(chars2, charset);
                }
                return this;
            }

            @Override
            public <T> Hasher putObject(T instance, Funnel<? super T> funnel) {
                for (Hasher hasher : hashers) {
                    hasher.putObject(instance, funnel);
                }
                return this;
            }

            @Override
            public HashCode hash() {
                return AbstractCompositeHashFunction.this.makeHash(hashers);
            }
        };
    }
}

