/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@CanIgnoreReturnValue
abstract class AbstractHasher
implements Hasher {
    AbstractHasher() {
    }

    @Override
    public final Hasher putBoolean(boolean b2) {
        return this.putByte(b2 ? (byte)1 : 0);
    }

    @Override
    public final Hasher putDouble(double d) {
        return this.putLong(Double.doubleToRawLongBits(d));
    }

    @Override
    public final Hasher putFloat(float f) {
        return this.putInt(Float.floatToRawIntBits(f));
    }

    @Override
    public Hasher putUnencodedChars(CharSequence charSequence) {
        int len = charSequence.length();
        for (int i2 = 0; i2 < len; ++i2) {
            this.putChar(charSequence.charAt(i2));
        }
        return this;
    }

    @Override
    public Hasher putString(CharSequence charSequence, Charset charset) {
        return this.putBytes(charSequence.toString().getBytes(charset));
    }

    @Override
    public Hasher putBytes(byte[] bytes2) {
        return this.putBytes(bytes2, 0, bytes2.length);
    }

    @Override
    public Hasher putBytes(byte[] bytes2, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, bytes2.length);
        for (int i2 = 0; i2 < len; ++i2) {
            this.putByte(bytes2[off + i2]);
        }
        return this;
    }

    @Override
    public Hasher putBytes(ByteBuffer b2) {
        if (b2.hasArray()) {
            this.putBytes(b2.array(), b2.arrayOffset() + b2.position(), b2.remaining());
            Java8Compatibility.position(b2, b2.limit());
        } else {
            for (int remaining = b2.remaining(); remaining > 0; --remaining) {
                this.putByte(b2.get());
            }
        }
        return this;
    }

    @Override
    public Hasher putShort(short s2) {
        this.putByte((byte)s2);
        this.putByte((byte)(s2 >>> 8));
        return this;
    }

    @Override
    public Hasher putInt(int i2) {
        this.putByte((byte)i2);
        this.putByte((byte)(i2 >>> 8));
        this.putByte((byte)(i2 >>> 16));
        this.putByte((byte)(i2 >>> 24));
        return this;
    }

    @Override
    public Hasher putLong(long l) {
        for (int i2 = 0; i2 < 64; i2 += 8) {
            this.putByte((byte)(l >>> i2));
        }
        return this;
    }

    @Override
    public Hasher putChar(char c) {
        this.putByte((byte)c);
        this.putByte((byte)(c >>> 8));
        return this;
    }

    @Override
    public <T> Hasher putObject(T instance, Funnel<? super T> funnel) {
        funnel.funnel(instance, this);
        return this;
    }
}

