/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.primitives.Longs;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

final class LittleEndianByteArray {
    private static final LittleEndianBytes byteArray;

    static long load64(byte[] input, int offset2) {
        assert (input.length >= offset2 + 8);
        return byteArray.getLongLittleEndian(input, offset2);
    }

    static long load64Safely(byte[] input, int offset2, int length2) {
        long result2 = 0L;
        int limit2 = Math.min(length2, 8);
        for (int i2 = 0; i2 < limit2; ++i2) {
            result2 |= ((long)input[offset2 + i2] & 0xFFL) << i2 * 8;
        }
        return result2;
    }

    static void store64(byte[] sink, int offset2, long value2) {
        assert (offset2 >= 0 && offset2 + 8 <= sink.length);
        byteArray.putLongLittleEndian(sink, offset2, value2);
    }

    static int load32(byte[] source2, int offset2) {
        return source2[offset2] & 0xFF | (source2[offset2 + 1] & 0xFF) << 8 | (source2[offset2 + 2] & 0xFF) << 16 | (source2[offset2 + 3] & 0xFF) << 24;
    }

    static boolean usingUnsafe() {
        return byteArray instanceof UnsafeByteArray;
    }

    private LittleEndianByteArray() {
    }

    static {
        Enum theGetter = JavaLittleEndianBytes.INSTANCE;
        try {
            String arch = System.getProperty("os.arch");
            if ("amd64".equals(arch)) {
                theGetter = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? UnsafeByteArray.UNSAFE_LITTLE_ENDIAN : UnsafeByteArray.UNSAFE_BIG_ENDIAN;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        byteArray = theGetter;
    }

    private static enum JavaLittleEndianBytes implements LittleEndianBytes
    {
        INSTANCE{

            @Override
            public long getLongLittleEndian(byte[] source2, int offset2) {
                return Longs.fromBytes(source2[offset2 + 7], source2[offset2 + 6], source2[offset2 + 5], source2[offset2 + 4], source2[offset2 + 3], source2[offset2 + 2], source2[offset2 + 1], source2[offset2]);
            }

            @Override
            public void putLongLittleEndian(byte[] sink, int offset2, long value2) {
                long mask = 255L;
                for (int i2 = 0; i2 < 8; ++i2) {
                    sink[offset2 + i2] = (byte)((value2 & mask) >> i2 * 8);
                    mask <<= 8;
                }
            }
        };

    }

    private static enum UnsafeByteArray implements LittleEndianBytes
    {
        UNSAFE_LITTLE_ENDIAN{

            @Override
            public long getLongLittleEndian(byte[] array2, int offset2) {
                return theUnsafe.getLong(array2, (long)offset2 + (long)BYTE_ARRAY_BASE_OFFSET);
            }

            @Override
            public void putLongLittleEndian(byte[] array2, int offset2, long value2) {
                theUnsafe.putLong(array2, (long)offset2 + (long)BYTE_ARRAY_BASE_OFFSET, value2);
            }
        }
        ,
        UNSAFE_BIG_ENDIAN{

            @Override
            public long getLongLittleEndian(byte[] array2, int offset2) {
                long bigEndian = theUnsafe.getLong(array2, (long)offset2 + (long)BYTE_ARRAY_BASE_OFFSET);
                return Long.reverseBytes(bigEndian);
            }

            @Override
            public void putLongLittleEndian(byte[] array2, int offset2, long value2) {
                long littleEndianValue = Long.reverseBytes(value2);
                theUnsafe.putLong(array2, (long)offset2 + (long)BYTE_ARRAY_BASE_OFFSET, littleEndianValue);
            }
        };

        private static final Unsafe theUnsafe;
        private static final int BYTE_ARRAY_BASE_OFFSET;

        private static Unsafe getUnsafe() {
            try {
                return Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                        @Override
                        public Unsafe run() throws Exception {
                            Class<Unsafe> k = Unsafe.class;
                            for (Field f : k.getDeclaredFields()) {
                                f.setAccessible(true);
                                Object x = f.get(null);
                                if (!k.isInstance(x)) continue;
                                return (Unsafe)k.cast(x);
                            }
                            throw new NoSuchFieldError("the Unsafe");
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Could not initialize intrinsics", e.getCause());
                }
            }
        }

        static {
            theUnsafe = UnsafeByteArray.getUnsafe();
            BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
            if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                throw new AssertionError();
            }
        }
    }

    private static interface LittleEndianBytes {
        public long getLongLittleEndian(byte[] var1, int var2);

        public void putLongLittleEndian(byte[] var1, int var2, long var3);
    }
}

