/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.NativeMethod;
import com.kenai.jffi.Platform;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NativeMethods {
    private static final Map<Class, NativeMethods> registeredMethods = new WeakHashMap<Class, NativeMethods>();
    private final ResourceHolder memory;

    private NativeMethods(ResourceHolder memory) {
        this.memory = memory;
    }

    public static final synchronized void register(Class clazz, List<NativeMethod> methods2) {
        int structSize;
        int stringSize = 0;
        for (NativeMethod m3 : methods2) {
            stringSize += m3.name.getBytes().length + 1;
            stringSize += m3.signature.getBytes().length + 1;
        }
        int ptrSize = Platform.getPlatform().addressSize() / 8;
        MemoryIO mm3 = MemoryIO.getInstance();
        long memory = mm3.allocateMemory((structSize = methods2.size() * 3 * ptrSize) + stringSize, true);
        if (memory == 0L) {
            throw new OutOfMemoryError("could not allocate native memory");
        }
        NativeMethods nm = new NativeMethods(new ResourceHolder(mm3, memory));
        int off = 0;
        int stringOff = structSize;
        for (NativeMethod m4 : methods2) {
            byte[] name2 = m4.name.getBytes();
            long nameAddress = memory + (long)stringOff;
            mm3.putZeroTerminatedByteArray(nameAddress, name2, 0, name2.length);
            byte[] sig = m4.signature.getBytes();
            long sigAddress = memory + (long)(stringOff += name2.length + 1);
            stringOff += sig.length + 1;
            mm3.putZeroTerminatedByteArray(sigAddress, sig, 0, sig.length);
            mm3.putAddress(memory + (long)off, nameAddress);
            mm3.putAddress(memory + (long)(off += ptrSize), sigAddress);
            mm3.putAddress(memory + (long)(off += ptrSize), m4.function);
            off += ptrSize;
        }
        if (Foreign.getInstance().registerNatives(clazz, memory, methods2.size()) != 0) {
            throw new RuntimeException("failed to register native methods");
        }
        registeredMethods.put(clazz, nm);
    }

    public static final synchronized void unregister(Class clazz) {
        if (!registeredMethods.containsKey(clazz)) {
            throw new IllegalArgumentException("methods were not registered on class via NativeMethods.register");
        }
        if (Foreign.getInstance().unregisterNatives(clazz) != 0) {
            throw new RuntimeException("failed to unregister native methods");
        }
        registeredMethods.remove(clazz);
    }

    private static final class ResourceHolder {
        private final MemoryIO mm;
        private final long memory;

        public ResourceHolder(MemoryIO mm3, long memory) {
            this.mm = mm3;
            this.memory = memory;
        }

        protected void finalize() throws Throwable {
            try {
                this.mm.freeMemory(this.memory);
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Exception when freeing native method struct array: %s", t.getLocalizedMessage());
            }
            finally {
                super.finalize();
            }
        }
    }
}

