/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.logging;

import com.sun.istack.NotNull;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class Logger {
    private static final String WS_LOGGING_SUBSYSTEM_NAME_ROOT = "com.sun.metro";
    private static final String ROOT_WS_PACKAGE = "com.sun.xml.ws.";
    private static final Level METHOD_CALL_LEVEL_VALUE = Level.FINEST;
    private final String componentClassName;
    private final java.util.logging.Logger logger;

    protected Logger(String systemLoggerName, String componentName) {
        this.componentClassName = "[" + componentName + "] ";
        this.logger = java.util.logging.Logger.getLogger(systemLoggerName);
    }

    @NotNull
    public static Logger getLogger(@NotNull Class<?> componentClass) {
        return new Logger(Logger.getSystemLoggerName(componentClass), componentClass.getName());
    }

    @NotNull
    public static Logger getLogger(@NotNull String customLoggerName, @NotNull Class<?> componentClass) {
        return new Logger(customLoggerName, componentClass.getName());
    }

    static final String getSystemLoggerName(@NotNull Class<?> componentClass) {
        StringBuilder sb = new StringBuilder(componentClass.getPackage().getName());
        int lastIndexOfWsPackage = sb.lastIndexOf(ROOT_WS_PACKAGE);
        if (lastIndexOfWsPackage > -1) {
            sb.replace(0, lastIndexOfWsPackage + ROOT_WS_PACKAGE.length(), "");
            StringTokenizer st = new StringTokenizer(sb.toString(), ".");
            sb = new StringBuilder(WS_LOGGING_SUBSYSTEM_NAME_ROOT).append(".");
            if (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ("api".equals(token)) {
                    token = st.nextToken();
                }
                sb.append(token);
            }
        }
        return sb.toString();
    }

    public void log(Level level2, String message2) {
        if (!this.logger.isLoggable(level2)) {
            return;
        }
        this.logger.logp(level2, this.componentClassName, Logger.getCallerMethodName(), message2);
    }

    public void log(Level level2, String message2, Object param1) {
        if (!this.logger.isLoggable(level2)) {
            return;
        }
        this.logger.logp(level2, this.componentClassName, Logger.getCallerMethodName(), message2, param1);
    }

    public void log(Level level2, String message2, Object[] params2) {
        if (!this.logger.isLoggable(level2)) {
            return;
        }
        this.logger.logp(level2, this.componentClassName, Logger.getCallerMethodName(), message2, params2);
    }

    public void log(Level level2, String message2, Throwable thrown) {
        if (!this.logger.isLoggable(level2)) {
            return;
        }
        this.logger.logp(level2, this.componentClassName, Logger.getCallerMethodName(), message2, thrown);
    }

    public void finest(String message2) {
        if (!this.logger.isLoggable(Level.FINEST)) {
            return;
        }
        this.logger.logp(Level.FINEST, this.componentClassName, Logger.getCallerMethodName(), message2);
    }

    public void finest(String message2, Object[] params2) {
        if (!this.logger.isLoggable(Level.FINEST)) {
            return;
        }
        this.logger.logp(Level.FINEST, this.componentClassName, Logger.getCallerMethodName(), message2, params2);
    }

    public void finest(String message2, Throwable thrown) {
        if (!this.logger.isLoggable(Level.FINEST)) {
            return;
        }
        this.logger.logp(Level.FINEST, this.componentClassName, Logger.getCallerMethodName(), message2, thrown);
    }

    public void finer(String message2) {
        if (!this.logger.isLoggable(Level.FINER)) {
            return;
        }
        this.logger.logp(Level.FINER, this.componentClassName, Logger.getCallerMethodName(), message2);
    }

    public void finer(String message2, Object[] params2) {
        if (!this.logger.isLoggable(Level.FINER)) {
            return;
        }
        this.logger.logp(Level.FINER, this.componentClassName, Logger.getCallerMethodName(), message2, params2);
    }

    public void finer(String message2, Throwable thrown) {
        if (!this.logger.isLoggable(Level.FINER)) {
            return;
        }
        this.logger.logp(Level.FINER, this.componentClassName, Logger.getCallerMethodName(), message2, thrown);
    }

    public void fine(String message2) {
        if (!this.logger.isLoggable(Level.FINE)) {
            return;
        }
        this.logger.logp(Level.FINE, this.componentClassName, Logger.getCallerMethodName(), message2);
    }

    public void fine(String message2, Throwable thrown) {
        if (!this.logger.isLoggable(Level.FINE)) {
            return;
        }
        this.logger.logp(Level.FINE, this.componentClassName, Logger.getCallerMethodName(), message2, thrown);
    }

    public void info(String message2) {
        if (!this.logger.isLoggable(Level.INFO)) {
            return;
        }
        this.logger.logp(Level.INFO, this.componentClassName, Logger.getCallerMethodName(), message2);
    }

    public void info(String message2, Object[] params2) {
        if (!this.logger.isLoggable(Level.INFO)) {
            return;
        }
        this.logger.logp(Level.INFO, this.componentClassName, Logger.getCallerMethodName(), message2, params2);
    }

    public void info(String message2, Throwable thrown) {
        if (!this.logger.isLoggable(Level.INFO)) {
            return;
        }
        this.logger.logp(Level.INFO, this.componentClassName, Logger.getCallerMethodName(), message2, thrown);
    }

    public void config(String message2) {
        if (!this.logger.isLoggable(Level.CONFIG)) {
            return;
        }
        this.logger.logp(Level.CONFIG, this.componentClassName, Logger.getCallerMethodName(), message2);
    }

    public void config(String message2, Object[] params2) {
        if (!this.logger.isLoggable(Level.CONFIG)) {
            return;
        }
        this.logger.logp(Level.CONFIG, this.componentClassName, Logger.getCallerMethodName(), message2, params2);
    }

    public void config(String message2, Throwable thrown) {
        if (!this.logger.isLoggable(Level.CONFIG)) {
            return;
        }
        this.logger.logp(Level.CONFIG, this.componentClassName, Logger.getCallerMethodName(), message2, thrown);
    }

    public void warning(String message2) {
        if (!this.logger.isLoggable(Level.WARNING)) {
            return;
        }
        this.logger.logp(Level.WARNING, this.componentClassName, Logger.getCallerMethodName(), message2);
    }

    public void warning(String message2, Object[] params2) {
        if (!this.logger.isLoggable(Level.WARNING)) {
            return;
        }
        this.logger.logp(Level.WARNING, this.componentClassName, Logger.getCallerMethodName(), message2, params2);
    }

    public void warning(String message2, Throwable thrown) {
        if (!this.logger.isLoggable(Level.WARNING)) {
            return;
        }
        this.logger.logp(Level.WARNING, this.componentClassName, Logger.getCallerMethodName(), message2, thrown);
    }

    public void severe(String message2) {
        if (!this.logger.isLoggable(Level.SEVERE)) {
            return;
        }
        this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), message2);
    }

    public void severe(String message2, Object[] params2) {
        if (!this.logger.isLoggable(Level.SEVERE)) {
            return;
        }
        this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), message2, params2);
    }

    public void severe(String message2, Throwable thrown) {
        if (!this.logger.isLoggable(Level.SEVERE)) {
            return;
        }
        this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), message2, thrown);
    }

    public boolean isMethodCallLoggable() {
        return this.logger.isLoggable(METHOD_CALL_LEVEL_VALUE);
    }

    public boolean isLoggable(Level level2) {
        return this.logger.isLoggable(level2);
    }

    public void setLevel(Level level2) {
        this.logger.setLevel(level2);
    }

    public void entering() {
        if (!this.logger.isLoggable(METHOD_CALL_LEVEL_VALUE)) {
            return;
        }
        this.logger.entering(this.componentClassName, Logger.getCallerMethodName());
    }

    public void entering(Object ... parameters2) {
        if (!this.logger.isLoggable(METHOD_CALL_LEVEL_VALUE)) {
            return;
        }
        this.logger.entering(this.componentClassName, Logger.getCallerMethodName(), parameters2);
    }

    public void exiting() {
        if (!this.logger.isLoggable(METHOD_CALL_LEVEL_VALUE)) {
            return;
        }
        this.logger.exiting(this.componentClassName, Logger.getCallerMethodName());
    }

    public void exiting(Object result2) {
        if (!this.logger.isLoggable(METHOD_CALL_LEVEL_VALUE)) {
            return;
        }
        this.logger.exiting(this.componentClassName, Logger.getCallerMethodName(), result2);
    }

    public <T extends Throwable> T logSevereException(T exception2, Throwable cause2) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            if (cause2 == null) {
                this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), exception2.getMessage());
            } else {
                exception2.initCause(cause2);
                this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), exception2.getMessage(), cause2);
            }
        }
        return exception2;
    }

    public <T extends Throwable> T logSevereException(T exception2, boolean logCause) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            if (logCause && exception2.getCause() != null) {
                this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), exception2.getMessage(), exception2.getCause());
            } else {
                this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), exception2.getMessage());
            }
        }
        return exception2;
    }

    public <T extends Throwable> T logSevereException(T exception2) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            if (exception2.getCause() == null) {
                this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), exception2.getMessage());
            } else {
                this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), exception2.getMessage(), exception2.getCause());
            }
        }
        return exception2;
    }

    public <T extends Throwable> T logException(T exception2, Throwable cause2, Level level2) {
        if (this.logger.isLoggable(level2)) {
            if (cause2 == null) {
                this.logger.logp(level2, this.componentClassName, Logger.getCallerMethodName(), exception2.getMessage());
            } else {
                exception2.initCause(cause2);
                this.logger.logp(level2, this.componentClassName, Logger.getCallerMethodName(), exception2.getMessage(), cause2);
            }
        }
        return exception2;
    }

    public <T extends Throwable> T logException(T exception2, boolean logCause, Level level2) {
        if (this.logger.isLoggable(level2)) {
            if (logCause && exception2.getCause() != null) {
                this.logger.logp(level2, this.componentClassName, Logger.getCallerMethodName(), exception2.getMessage(), exception2.getCause());
            } else {
                this.logger.logp(level2, this.componentClassName, Logger.getCallerMethodName(), exception2.getMessage());
            }
        }
        return exception2;
    }

    public <T extends Throwable> T logException(T exception2, Level level2) {
        if (this.logger.isLoggable(level2)) {
            if (exception2.getCause() == null) {
                this.logger.logp(level2, this.componentClassName, Logger.getCallerMethodName(), exception2.getMessage());
            } else {
                this.logger.logp(level2, this.componentClassName, Logger.getCallerMethodName(), exception2.getMessage(), exception2.getCause());
            }
        }
        return exception2;
    }

    private static String getCallerMethodName() {
        return Logger.getStackMethodName(5);
    }

    private static String getStackMethodName(int methodIndexInStack) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        String methodName = stack.length > methodIndexInStack + 1 ? stack[methodIndexInStack].getMethodName() : "UNKNOWN METHOD";
        return methodName;
    }
}

