/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.iap;

import com.sun.mail.iap.AString;
import com.sun.mail.iap.Atom;
import com.sun.mail.iap.Literal;
import com.sun.mail.iap.LiteralException;
import com.sun.mail.iap.NString;
import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.util.ASCIIUtility;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class Argument {
    protected List<Object> items = new ArrayList<Object>(1);

    public Argument append(Argument arg2) {
        this.items.addAll(arg2.items);
        return this;
    }

    public Argument writeString(String s2) {
        this.items.add(new AString(ASCIIUtility.getBytes(s2)));
        return this;
    }

    public Argument writeString(String s2, String charset) throws UnsupportedEncodingException {
        if (charset == null) {
            this.writeString(s2);
        } else {
            this.items.add(new AString(s2.getBytes(charset)));
        }
        return this;
    }

    public Argument writeString(String s2, Charset charset) {
        if (charset == null) {
            this.writeString(s2);
        } else {
            this.items.add(new AString(s2.getBytes(charset)));
        }
        return this;
    }

    public Argument writeNString(String s2) {
        if (s2 == null) {
            this.items.add(new NString(null));
        } else {
            this.items.add(new NString(ASCIIUtility.getBytes(s2)));
        }
        return this;
    }

    public Argument writeNString(String s2, String charset) throws UnsupportedEncodingException {
        if (s2 == null) {
            this.items.add(new NString(null));
        } else if (charset == null) {
            this.writeString(s2);
        } else {
            this.items.add(new NString(s2.getBytes(charset)));
        }
        return this;
    }

    public Argument writeNString(String s2, Charset charset) {
        if (s2 == null) {
            this.items.add(new NString(null));
        } else if (charset == null) {
            this.writeString(s2);
        } else {
            this.items.add(new NString(s2.getBytes(charset)));
        }
        return this;
    }

    public Argument writeBytes(byte[] b2) {
        this.items.add(b2);
        return this;
    }

    public Argument writeBytes(ByteArrayOutputStream b2) {
        this.items.add(b2);
        return this;
    }

    public Argument writeBytes(Literal b2) {
        this.items.add(b2);
        return this;
    }

    public Argument writeAtom(String s2) {
        this.items.add(new Atom(s2));
        return this;
    }

    public Argument writeNumber(int i2) {
        this.items.add(i2);
        return this;
    }

    public Argument writeNumber(long i2) {
        this.items.add(i2);
        return this;
    }

    public Argument writeArgument(Argument c) {
        this.items.add(c);
        return this;
    }

    public void write(Protocol protocol2) throws IOException, ProtocolException {
        int size2 = this.items != null ? this.items.size() : 0;
        DataOutputStream os = (DataOutputStream)protocol2.getOutputStream();
        for (int i2 = 0; i2 < size2; ++i2) {
            Object o;
            if (i2 > 0) {
                os.write(32);
            }
            if ((o = this.items.get(i2)) instanceof Atom) {
                os.writeBytes(((Atom)o).string);
                continue;
            }
            if (o instanceof Number) {
                os.writeBytes(((Number)o).toString());
                continue;
            }
            if (o instanceof AString) {
                this.astring(((AString)o).bytes, protocol2);
                continue;
            }
            if (o instanceof NString) {
                this.nstring(((NString)o).bytes, protocol2);
                continue;
            }
            if (o instanceof byte[]) {
                this.literal((byte[])o, protocol2);
                continue;
            }
            if (o instanceof ByteArrayOutputStream) {
                this.literal((ByteArrayOutputStream)o, protocol2);
                continue;
            }
            if (o instanceof Literal) {
                this.literal((Literal)o, protocol2);
                continue;
            }
            if (!(o instanceof Argument)) continue;
            os.write(40);
            ((Argument)o).write(protocol2);
            os.write(41);
        }
    }

    private void astring(byte[] bytes2, Protocol protocol2) throws IOException, ProtocolException {
        this.nastring(bytes2, protocol2, false);
    }

    private void nstring(byte[] bytes2, Protocol protocol2) throws IOException, ProtocolException {
        if (bytes2 == null) {
            DataOutputStream os = (DataOutputStream)protocol2.getOutputStream();
            os.writeBytes("NIL");
        } else {
            this.nastring(bytes2, protocol2, true);
        }
    }

    private void nastring(byte[] bytes2, Protocol protocol2, boolean doQuote) throws IOException, ProtocolException {
        byte b2;
        int i2;
        DataOutputStream os = (DataOutputStream)protocol2.getOutputStream();
        int len = bytes2.length;
        if (len > 1024) {
            this.literal(bytes2, protocol2);
            return;
        }
        boolean quote2 = len == 0 ? true : doQuote;
        boolean escape2 = false;
        boolean utf8 = protocol2.supportsUtf8();
        for (i2 = 0; i2 < len; ++i2) {
            b2 = bytes2[i2];
            if (b2 == 0 || b2 == 13 || b2 == 10 || !utf8 && (b2 & 0xFF) > 127) {
                this.literal(bytes2, protocol2);
                return;
            }
            if (b2 != 42 && b2 != 37 && b2 != 40 && b2 != 41 && b2 != 123 && b2 != 34 && b2 != 92 && (b2 & 0xFF) > 32 && (b2 & 0xFF) <= 127) continue;
            quote2 = true;
            if (b2 != 34 && b2 != 92) continue;
            escape2 = true;
        }
        if (!(quote2 || bytes2.length != 3 || bytes2[0] != 78 && bytes2[0] != 110 || bytes2[1] != 73 && bytes2[1] != 105 || bytes2[2] != 76 && bytes2[2] != 108)) {
            quote2 = true;
        }
        if (quote2) {
            os.write(34);
        }
        if (escape2) {
            for (i2 = 0; i2 < len; ++i2) {
                b2 = bytes2[i2];
                if (b2 == 34 || b2 == 92) {
                    os.write(92);
                }
                os.write(b2);
            }
        } else {
            os.write(bytes2);
        }
        if (quote2) {
            os.write(34);
        }
    }

    private void literal(byte[] b2, Protocol protocol2) throws IOException, ProtocolException {
        this.startLiteral(protocol2, b2.length).write(b2);
    }

    private void literal(ByteArrayOutputStream b2, Protocol protocol2) throws IOException, ProtocolException {
        b2.writeTo(this.startLiteral(protocol2, b2.size()));
    }

    private void literal(Literal b2, Protocol protocol2) throws IOException, ProtocolException {
        b2.writeTo(this.startLiteral(protocol2, b2.size()));
    }

    private OutputStream startLiteral(Protocol protocol2, int size2) throws IOException, ProtocolException {
        DataOutputStream os = (DataOutputStream)protocol2.getOutputStream();
        boolean nonSync = protocol2.supportsNonSyncLiterals();
        os.write(123);
        os.writeBytes(Integer.toString(size2));
        if (nonSync) {
            os.writeBytes("+}\r\n");
        } else {
            os.writeBytes("}\r\n");
        }
        os.flush();
        if (!nonSync) {
            Response r;
            while (!(r = protocol2.readResponse()).isContinuation()) {
                if (!r.isTagged()) continue;
                throw new LiteralException(r);
            }
        }
        return os;
    }
}

