/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.ResyncData;
import com.sun.mail.imap.protocol.MessageSet;
import com.sun.mail.imap.protocol.UIDSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.mail.Message;

public final class Utility {
    private Utility() {
    }

    public static MessageSet[] toMessageSet(Message[] msgs, Condition cond) {
        ArrayList<MessageSet> v = new ArrayList<MessageSet>(1);
        for (int i2 = 0; i2 < msgs.length; ++i2) {
            IMAPMessage msg = (IMAPMessage)msgs[i2];
            if (msg.isExpunged()) continue;
            int current2 = msg.getSequenceNumber();
            if (cond != null && !cond.test(msg)) continue;
            MessageSet set2 = new MessageSet();
            set2.start = current2;
            ++i2;
            while (i2 < msgs.length) {
                msg = (IMAPMessage)msgs[i2];
                if (!msg.isExpunged()) {
                    int next2 = msg.getSequenceNumber();
                    if (cond == null || cond.test(msg)) {
                        if (next2 == current2 + 1) {
                            current2 = next2;
                        } else {
                            --i2;
                            break;
                        }
                    }
                }
                ++i2;
            }
            set2.end = current2;
            v.add(set2);
        }
        if (v.isEmpty()) {
            return null;
        }
        return v.toArray(new MessageSet[v.size()]);
    }

    public static MessageSet[] toMessageSetSorted(Message[] msgs, Condition cond) {
        msgs = (Message[])msgs.clone();
        Arrays.sort(msgs, new Comparator<Message>(){

            @Override
            public int compare(Message msg1, Message msg2) {
                return msg1.getMessageNumber() - msg2.getMessageNumber();
            }
        });
        return Utility.toMessageSet(msgs, cond);
    }

    public static UIDSet[] toUIDSet(Message[] msgs) {
        ArrayList<UIDSet> v = new ArrayList<UIDSet>(1);
        for (int i2 = 0; i2 < msgs.length; ++i2) {
            IMAPMessage msg = (IMAPMessage)msgs[i2];
            if (msg.isExpunged()) continue;
            long current2 = msg.getUID();
            UIDSet set2 = new UIDSet();
            set2.start = current2;
            ++i2;
            while (i2 < msgs.length) {
                msg = (IMAPMessage)msgs[i2];
                if (!msg.isExpunged()) {
                    long next2 = msg.getUID();
                    if (next2 == current2 + 1L) {
                        current2 = next2;
                    } else {
                        --i2;
                        break;
                    }
                }
                ++i2;
            }
            set2.end = current2;
            v.add(set2);
        }
        if (v.isEmpty()) {
            return null;
        }
        return v.toArray(new UIDSet[v.size()]);
    }

    public static UIDSet[] getResyncUIDSet(ResyncData rd) {
        return rd.getUIDSet();
    }

    public static interface Condition {
        public boolean test(IMAPMessage var1);
    }
}

