/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.Argument;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ID {
    private Map<String, String> serverParams = null;

    public ID(Response r) throws ProtocolException {
        r.skipSpaces();
        byte c = r.peekByte();
        if (c == 78 || c == 110) {
            return;
        }
        if (c != 40) {
            throw new ProtocolException("Missing '(' at start of ID");
        }
        this.serverParams = new HashMap<String, String>();
        String[] v = r.readStringList();
        if (v != null) {
            for (int i2 = 0; i2 < v.length; i2 += 2) {
                String name2 = v[i2];
                if (name2 == null) {
                    throw new ProtocolException("ID field name null");
                }
                if (i2 + 1 >= v.length) {
                    throw new ProtocolException("ID field without value: " + name2);
                }
                String value2 = v[i2 + 1];
                this.serverParams.put(name2, value2);
            }
        }
        this.serverParams = Collections.unmodifiableMap(this.serverParams);
    }

    Map<String, String> getServerParams() {
        return this.serverParams;
    }

    static Argument getArgumentList(Map<String, String> clientParams) {
        Argument arg2 = new Argument();
        if (clientParams == null) {
            arg2.writeAtom("NIL");
            return arg2;
        }
        Argument list2 = new Argument();
        for (Map.Entry<String, String> e : clientParams.entrySet()) {
            list2.writeNString(e.getKey());
            list2.writeNString(e.getValue());
        }
        arg2.writeArgument(list2);
        return arg2;
    }
}

