/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.smtp;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.MailLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StreamTokenizer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class DigestMD5 {
    private MailLogger logger;
    private MessageDigest md5;
    private String uri;
    private String clientResponse;
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DigestMD5(MailLogger logger) {
        this.logger = logger.getLogger(this.getClass(), "DEBUG DIGEST-MD5");
        logger.config("DIGEST-MD5 Loaded");
    }

    public byte[] authClient(String host, String user, String passwd2, String realm, String serverChallenge) throws IOException {
        SecureRandom random;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BASE64EncoderStream b64os = new BASE64EncoderStream(bos, Integer.MAX_VALUE);
        try {
            random = new SecureRandom();
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            this.logger.log(Level.FINE, "NoSuchAlgorithmException", ex);
            throw new IOException(ex.toString());
        }
        StringBuilder result2 = new StringBuilder();
        this.uri = "smtp/" + host;
        String nc = "00000001";
        String qop = "auth";
        byte[] bytes2 = new byte[32];
        this.logger.fine("Begin authentication ...");
        Map<String, String> map2 = this.tokenize(serverChallenge);
        if (realm == null) {
            String text = map2.get("realm");
            realm = text != null ? new StringTokenizer(text, ",").nextToken() : host;
        }
        String nonce = map2.get("nonce");
        String charset = map2.get("charset");
        boolean utf8 = charset != null && charset.equalsIgnoreCase("utf-8");
        random.nextBytes(bytes2);
        ((OutputStream)b64os).write(bytes2);
        ((OutputStream)b64os).flush();
        String cnonce = bos.toString("iso-8859-1");
        bos.reset();
        if (utf8) {
            String up = user + ":" + realm + ":" + passwd2;
            this.md5.update(this.md5.digest(up.getBytes(StandardCharsets.UTF_8)));
        } else {
            this.md5.update(this.md5.digest(ASCIIUtility.getBytes(user + ":" + realm + ":" + passwd2)));
        }
        this.md5.update(ASCIIUtility.getBytes(":" + nonce + ":" + cnonce));
        this.clientResponse = DigestMD5.toHex(this.md5.digest()) + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":";
        this.md5.update(ASCIIUtility.getBytes("AUTHENTICATE:" + this.uri));
        this.md5.update(ASCIIUtility.getBytes(this.clientResponse + DigestMD5.toHex(this.md5.digest())));
        result2.append("username=\"" + user + "\"");
        result2.append(",realm=\"" + realm + "\"");
        result2.append(",qop=" + qop);
        result2.append(",nc=" + nc);
        result2.append(",nonce=\"" + nonce + "\"");
        result2.append(",cnonce=\"" + cnonce + "\"");
        result2.append(",digest-uri=\"" + this.uri + "\"");
        if (utf8) {
            result2.append(",charset=\"utf-8\"");
        }
        result2.append(",response=" + DigestMD5.toHex(this.md5.digest()));
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Response => " + result2.toString());
        }
        ((OutputStream)b64os).write(ASCIIUtility.getBytes(result2.toString()));
        ((OutputStream)b64os).flush();
        return bos.toByteArray();
    }

    public boolean authServer(String serverResponse) throws IOException {
        Map<String, String> map2 = this.tokenize(serverResponse);
        this.md5.update(ASCIIUtility.getBytes(":" + this.uri));
        this.md5.update(ASCIIUtility.getBytes(this.clientResponse + DigestMD5.toHex(this.md5.digest())));
        String text = DigestMD5.toHex(this.md5.digest());
        if (!text.equals(map2.get("rspauth"))) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Expected => rspauth=" + text);
            }
            return false;
        }
        return true;
    }

    private Map<String, String> tokenize(String serverResponse) throws IOException {
        int ttype;
        HashMap<String, String> map2 = new HashMap<String, String>();
        byte[] bytes2 = serverResponse.getBytes("iso-8859-1");
        String key2 = null;
        StreamTokenizer tokens = new StreamTokenizer(new InputStreamReader((InputStream)new BASE64DecoderStream(new ByteArrayInputStream(bytes2, 4, bytes2.length - 4)), "iso-8859-1"));
        tokens.ordinaryChars(48, 57);
        tokens.wordChars(48, 57);
        block4: while ((ttype = tokens.nextToken()) != -1) {
            switch (ttype) {
                case -3: {
                    if (key2 == null) {
                        key2 = tokens.sval;
                        continue block4;
                    }
                }
                case 34: {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Received => " + key2 + "='" + tokens.sval + "'");
                    }
                    if (map2.containsKey(key2)) {
                        map2.put(key2, (String)map2.get(key2) + "," + tokens.sval);
                    } else {
                        map2.put(key2, tokens.sval);
                    }
                    key2 = null;
                    continue block4;
                }
            }
        }
        return map2;
    }

    private static String toHex(byte[] bytes2) {
        char[] result2 = new char[bytes2.length * 2];
        int i2 = 0;
        for (int index2 = 0; index2 < bytes2.length; ++index2) {
            int temp = bytes2[index2] & 0xFF;
            result2[i2++] = digits[temp >> 4];
            result2[i2++] = digits[temp & 0xF];
        }
        return new String(result2);
    }
}

