/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASCIIUtility {
    private ASCIIUtility() {
    }

    public static int parseInt(byte[] b2, int start2, int end2, int radix) throws NumberFormatException {
        if (b2 == null) {
            throw new NumberFormatException("null");
        }
        int result2 = 0;
        boolean negative = false;
        int i2 = start2;
        if (end2 > start2) {
            int digit;
            int limit2;
            if (b2[i2] == 45) {
                negative = true;
                limit2 = Integer.MIN_VALUE;
                ++i2;
            } else {
                limit2 = -2147483647;
            }
            int multmin = limit2 / radix;
            if (i2 < end2) {
                if ((digit = Character.digit((char)b2[i2++], radix)) < 0) {
                    throw new NumberFormatException("illegal number: " + ASCIIUtility.toString(b2, start2, end2));
                }
                result2 = -digit;
            }
            while (i2 < end2) {
                if ((digit = Character.digit((char)b2[i2++], radix)) < 0) {
                    throw new NumberFormatException("illegal number");
                }
                if (result2 < multmin) {
                    throw new NumberFormatException("illegal number");
                }
                if ((result2 *= radix) < limit2 + digit) {
                    throw new NumberFormatException("illegal number");
                }
                result2 -= digit;
            }
        } else {
            throw new NumberFormatException("illegal number");
        }
        if (negative) {
            if (i2 > start2 + 1) {
                return result2;
            }
            throw new NumberFormatException("illegal number");
        }
        return -result2;
    }

    public static int parseInt(byte[] b2, int start2, int end2) throws NumberFormatException {
        return ASCIIUtility.parseInt(b2, start2, end2, 10);
    }

    public static long parseLong(byte[] b2, int start2, int end2, int radix) throws NumberFormatException {
        if (b2 == null) {
            throw new NumberFormatException("null");
        }
        long result2 = 0L;
        boolean negative = false;
        int i2 = start2;
        if (end2 > start2) {
            int digit;
            long limit2;
            if (b2[i2] == 45) {
                negative = true;
                limit2 = Long.MIN_VALUE;
                ++i2;
            } else {
                limit2 = -9223372036854775807L;
            }
            long multmin = limit2 / (long)radix;
            if (i2 < end2) {
                if ((digit = Character.digit((char)b2[i2++], radix)) < 0) {
                    throw new NumberFormatException("illegal number: " + ASCIIUtility.toString(b2, start2, end2));
                }
                result2 = -digit;
            }
            while (i2 < end2) {
                if ((digit = Character.digit((char)b2[i2++], radix)) < 0) {
                    throw new NumberFormatException("illegal number");
                }
                if (result2 < multmin) {
                    throw new NumberFormatException("illegal number");
                }
                if ((result2 *= (long)radix) < limit2 + (long)digit) {
                    throw new NumberFormatException("illegal number");
                }
                result2 -= (long)digit;
            }
        } else {
            throw new NumberFormatException("illegal number");
        }
        if (negative) {
            if (i2 > start2 + 1) {
                return result2;
            }
            throw new NumberFormatException("illegal number");
        }
        return -result2;
    }

    public static long parseLong(byte[] b2, int start2, int end2) throws NumberFormatException {
        return ASCIIUtility.parseLong(b2, start2, end2, 10);
    }

    public static String toString(byte[] b2, int start2, int end2) {
        int size2 = end2 - start2;
        char[] theChars = new char[size2];
        int i2 = 0;
        int j = start2;
        while (i2 < size2) {
            theChars[i2++] = (char)(b2[j++] & 0xFF);
        }
        return new String(theChars);
    }

    public static String toString(byte[] b2) {
        return ASCIIUtility.toString(b2, 0, b2.length);
    }

    public static String toString(ByteArrayInputStream is) {
        int size2 = is.available();
        char[] theChars = new char[size2];
        byte[] bytes2 = new byte[size2];
        is.read(bytes2, 0, size2);
        int i2 = 0;
        while (i2 < size2) {
            theChars[i2] = (char)(bytes2[i2++] & 0xFF);
        }
        return new String(theChars);
    }

    public static byte[] getBytes(String s2) {
        char[] chars2 = s2.toCharArray();
        int size2 = chars2.length;
        byte[] bytes2 = new byte[size2];
        int i2 = 0;
        while (i2 < size2) {
            bytes2[i2] = (byte)chars2[i2++];
        }
        return bytes2;
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        byte[] buf;
        int size2 = 1024;
        if (is instanceof ByteArrayInputStream) {
            size2 = is.available();
            buf = new byte[size2];
            int len = is.read(buf, 0, size2);
        } else {
            int len;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            buf = new byte[size2];
            while ((len = is.read(buf, 0, size2)) != -1) {
                bos.write(buf, 0, len);
            }
            buf = bos.toByteArray();
        }
        return buf;
    }
}

