/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.util.Properties;
import javax.mail.Session;

public class PropUtil {
    private PropUtil() {
    }

    public static int getIntProperty(Properties props, String name2, int def) {
        return PropUtil.getInt(PropUtil.getProp(props, name2), def);
    }

    public static boolean getBooleanProperty(Properties props, String name2, boolean def) {
        return PropUtil.getBoolean(PropUtil.getProp(props, name2), def);
    }

    @Deprecated
    public static int getIntSessionProperty(Session session, String name2, int def) {
        return PropUtil.getInt(PropUtil.getProp(session.getProperties(), name2), def);
    }

    @Deprecated
    public static boolean getBooleanSessionProperty(Session session, String name2, boolean def) {
        return PropUtil.getBoolean(PropUtil.getProp(session.getProperties(), name2), def);
    }

    public static boolean getBooleanSystemProperty(String name2, boolean def) {
        try {
            return PropUtil.getBoolean(PropUtil.getProp(System.getProperties(), name2), def);
        }
        catch (SecurityException securityException) {
            try {
                String value2 = System.getProperty(name2);
                if (value2 == null) {
                    return def;
                }
                if (def) {
                    return !value2.equalsIgnoreCase("false");
                }
                return value2.equalsIgnoreCase("true");
            }
            catch (SecurityException sex) {
                return def;
            }
        }
    }

    private static Object getProp(Properties props, String name2) {
        Object val = props.get(name2);
        if (val != null) {
            return val;
        }
        return props.getProperty(name2);
    }

    private static int getInt(Object value2, int def) {
        if (value2 == null) {
            return def;
        }
        if (value2 instanceof String) {
            try {
                return Integer.parseInt((String)value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (value2 instanceof Integer) {
            return (Integer)value2;
        }
        return def;
    }

    private static boolean getBoolean(Object value2, boolean def) {
        if (value2 == null) {
            return def;
        }
        if (value2 instanceof String) {
            if (def) {
                return !((String)value2).equalsIgnoreCase("false");
            }
            return ((String)value2).equalsIgnoreCase("true");
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        return def;
    }
}

