/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectStreamException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.LoggingPermission;

final class LogManagerProperties
extends Properties {
    private static final long serialVersionUID = -2239983349056806252L;
    private static final Method LR_GET_INSTANT;
    private static final Method ZI_SYSTEM_DEFAULT;
    private static final Method ZDT_OF_INSTANT;
    private static volatile String[] REFLECT_NAMES;
    private static final Object LOG_MANAGER;
    private final String prefix;

    private static Object loadLogManager() {
        Object m3;
        try {
            m3 = LogManager.getLogManager();
        }
        catch (LinkageError restricted) {
            m3 = LogManagerProperties.readConfiguration();
        }
        catch (RuntimeException unexpected) {
            m3 = LogManagerProperties.readConfiguration();
        }
        return m3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readConfiguration() {
        Properties props;
        block7: {
            props = new Properties();
            try {
                String n = System.getProperty("java.util.logging.config.file");
                if (n == null) break block7;
                File f = new File(n).getCanonicalFile();
                try (FileInputStream in = new FileInputStream(f);){
                    props.load(in);
                }
            }
            catch (RuntimeException runtimeException) {
            }
            catch (Exception exception2) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
        return props;
    }

    static String fromLogManager(String name2) {
        if (name2 == null) {
            throw new NullPointerException();
        }
        Object m3 = LOG_MANAGER;
        try {
            if (m3 instanceof Properties) {
                return ((Properties)m3).getProperty(name2);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (m3 != null) {
            try {
                if (m3 instanceof LogManager) {
                    return ((LogManager)m3).getProperty(name2);
                }
            }
            catch (LinkageError linkageError) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    static void checkLogManagerAccess() {
        boolean checked = false;
        Object m3 = LOG_MANAGER;
        if (m3 != null) {
            try {
                if (m3 instanceof LogManager) {
                    checked = true;
                    ((LogManager)m3).checkAccess();
                }
            }
            catch (SecurityException notAllowed) {
                if (checked) {
                    throw notAllowed;
                }
            }
            catch (LinkageError linkageError) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (!checked) {
            LogManagerProperties.checkLoggingAccess();
        }
    }

    private static void checkLoggingAccess() {
        SecurityManager sm;
        boolean checked = false;
        Logger global = Logger.getLogger("global");
        try {
            if (Logger.class == global.getClass()) {
                global.removeHandler(null);
                checked = true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (!checked && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new LoggingPermission("control", null));
        }
    }

    static boolean hasLogManager() {
        Object m3 = LOG_MANAGER;
        return m3 != null && !(m3 instanceof Properties);
    }

    static Comparable<?> getZonedDateTime(LogRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        Method m3 = ZDT_OF_INSTANT;
        if (m3 != null) {
            try {
                return (Comparable)m3.invoke(null, LR_GET_INSTANT.invoke((Object)record, new Object[0]), ZI_SYSTEM_DEFAULT.invoke(null, new Object[0]));
            }
            catch (RuntimeException ignore) {
                assert (LR_GET_INSTANT != null && ZI_SYSTEM_DEFAULT != null) : ignore;
            }
            catch (InvocationTargetException ite) {
                Throwable cause2 = ite.getCause();
                if (cause2 instanceof Error) {
                    throw (Error)cause2;
                }
                if (cause2 instanceof RuntimeException) {
                    throw (RuntimeException)cause2;
                }
                throw new UndeclaredThrowableException(ite);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return null;
    }

    static String getLocalHost(Object s2) throws Exception {
        try {
            Method m3 = s2.getClass().getMethod("getLocalHost", new Class[0]);
            if (!Modifier.isStatic(m3.getModifiers()) && m3.getReturnType() == String.class) {
                return (String)m3.invoke(s2, new Object[0]);
            }
            throw new NoSuchMethodException(m3.toString());
        }
        catch (ExceptionInInitializerError EIIE) {
            throw LogManagerProperties.wrapOrThrow(EIIE);
        }
        catch (InvocationTargetException ite) {
            throw LogManagerProperties.paramOrError(ite);
        }
    }

    static long parseDurationToMillis(CharSequence value2) throws Exception {
        try {
            Class<?> k = LogManagerProperties.findClass("java.time.Duration");
            Method parse2 = k.getMethod("parse", CharSequence.class);
            if (!k.isAssignableFrom(parse2.getReturnType()) || !Modifier.isStatic(parse2.getModifiers())) {
                throw new NoSuchMethodException(parse2.toString());
            }
            Method toMillis = k.getMethod("toMillis", new Class[0]);
            if (!Long.TYPE.isAssignableFrom(toMillis.getReturnType()) || Modifier.isStatic(toMillis.getModifiers())) {
                throw new NoSuchMethodException(toMillis.toString());
            }
            return (Long)toMillis.invoke(parse2.invoke(null, value2), new Object[0]);
        }
        catch (ExceptionInInitializerError EIIE) {
            throw LogManagerProperties.wrapOrThrow(EIIE);
        }
        catch (InvocationTargetException ite) {
            throw LogManagerProperties.paramOrError(ite);
        }
    }

    static String toLanguageTag(Locale locale) {
        String l = locale.getLanguage();
        String c = locale.getCountry();
        String v = locale.getVariant();
        char[] b2 = new char[l.length() + c.length() + v.length() + 2];
        int count2 = l.length();
        l.getChars(0, count2, b2, 0);
        if (c.length() != 0 || l.length() != 0 && v.length() != 0) {
            b2[count2] = 45;
            c.getChars(0, c.length(), b2, ++count2);
            count2 += c.length();
        }
        if (v.length() != 0 && (l.length() != 0 || c.length() != 0)) {
            b2[count2] = 45;
            v.getChars(0, v.length(), b2, ++count2);
            count2 += v.length();
        }
        return String.valueOf(b2, 0, count2);
    }

    static Filter newFilter(String name2) throws Exception {
        return LogManagerProperties.newObjectFrom(name2, Filter.class);
    }

    static Formatter newFormatter(String name2) throws Exception {
        return LogManagerProperties.newObjectFrom(name2, Formatter.class);
    }

    static Comparator<? super LogRecord> newComparator(String name2) throws Exception {
        return LogManagerProperties.newObjectFrom(name2, Comparator.class);
    }

    static <T> Comparator<T> reverseOrder(Comparator<T> c) {
        Comparator reverse2;
        block9: {
            if (c == null) {
                throw new NullPointerException();
            }
            reverse2 = null;
            try {
                Method m3 = c.getClass().getMethod("reversed", new Class[0]);
                if (Modifier.isStatic(m3.getModifiers()) || !Comparator.class.isAssignableFrom(m3.getReturnType())) break block9;
                try {
                    reverse2 = (Comparator)m3.invoke(c, new Object[0]);
                }
                catch (ExceptionInInitializerError eiie) {
                    throw LogManagerProperties.wrapOrThrow(eiie);
                }
            }
            catch (NoSuchMethodException m3) {
            }
            catch (IllegalAccessException m3) {
            }
            catch (RuntimeException m3) {
            }
            catch (InvocationTargetException ite) {
                LogManagerProperties.paramOrError(ite);
            }
        }
        if (reverse2 == null) {
            reverse2 = Collections.reverseOrder(c);
        }
        return reverse2;
    }

    static ErrorManager newErrorManager(String name2) throws Exception {
        return LogManagerProperties.newObjectFrom(name2, ErrorManager.class);
    }

    static boolean isStaticUtilityClass(String name2) throws Exception {
        boolean util;
        Method[] methods2;
        Class<Object> obj;
        Class<?> c = LogManagerProperties.findClass(name2);
        if (c != (obj = Object.class) && (methods2 = c.getMethods()).length != 0) {
            util = true;
            for (Method m3 : methods2) {
                if (m3.getDeclaringClass() == obj || Modifier.isStatic(m3.getModifiers())) continue;
                util = false;
                break;
            }
        } else {
            util = false;
        }
        return util;
    }

    static boolean isReflectionClass(String name2) throws Exception {
        String[] names2 = REFLECT_NAMES;
        if (names2 == null) {
            REFLECT_NAMES = names2 = LogManagerProperties.reflectionClassNames();
        }
        for (String rf : names2) {
            if (!name2.equals(rf)) continue;
            return true;
        }
        LogManagerProperties.findClass(name2);
        return false;
    }

    private static String[] reflectionClassNames() throws Exception {
        Class<LogManagerProperties> thisClass = LogManagerProperties.class;
        assert (Modifier.isFinal(thisClass.getModifiers())) : thisClass;
        try {
            HashSet<String> traces = new HashSet<String>();
            Throwable t = (Throwable)Throwable.class.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (StackTraceElement ste : t.getStackTrace()) {
                if (thisClass.getName().equals(ste.getClassName())) break;
                traces.add(ste.getClassName());
            }
            Throwable.class.getMethod("fillInStackTrace", new Class[0]).invoke((Object)t, new Object[0]);
            for (StackTraceElement ste : t.getStackTrace()) {
                if (thisClass.getName().equals(ste.getClassName())) break;
                traces.add(ste.getClassName());
            }
            return traces.toArray(new String[traces.size()]);
        }
        catch (InvocationTargetException ITE) {
            throw LogManagerProperties.paramOrError(ITE);
        }
    }

    static <T> T newObjectFrom(String name2, Class<T> type2) throws Exception {
        try {
            Class<?> clazz = LogManagerProperties.findClass(name2);
            if (type2.isAssignableFrom(clazz)) {
                try {
                    return type2.cast(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (InvocationTargetException ITE) {
                    throw LogManagerProperties.paramOrError(ITE);
                }
            }
            throw new ClassCastException(clazz.getName() + " cannot be cast to " + type2.getName());
        }
        catch (NoClassDefFoundError NCDFE) {
            throw new ClassNotFoundException(NCDFE.toString(), NCDFE);
        }
        catch (ExceptionInInitializerError EIIE) {
            throw LogManagerProperties.wrapOrThrow(EIIE);
        }
    }

    private static Exception paramOrError(InvocationTargetException ite) {
        Throwable cause2 = ite.getCause();
        if (cause2 != null && cause2 instanceof VirtualMachineError | cause2 instanceof ThreadDeath) {
            throw (Error)cause2;
        }
        return ite;
    }

    private static InvocationTargetException wrapOrThrow(ExceptionInInitializerError eiie) {
        if (eiie.getCause() instanceof Error) {
            throw eiie;
        }
        return new InvocationTargetException(eiie);
    }

    private static Class<?> findClass(String name2) throws ClassNotFoundException {
        Class<?> clazz;
        ClassLoader[] loaders = LogManagerProperties.getClassLoaders();
        assert (loaders.length == 2) : loaders.length;
        if (loaders[0] != null) {
            try {
                clazz = Class.forName(name2, false, loaders[0]);
            }
            catch (ClassNotFoundException tryContext) {
                clazz = LogManagerProperties.tryLoad(name2, loaders[1]);
            }
        } else {
            clazz = LogManagerProperties.tryLoad(name2, loaders[1]);
        }
        return clazz;
    }

    private static Class<?> tryLoad(String name2, ClassLoader l) throws ClassNotFoundException {
        if (l != null) {
            return Class.forName(name2, false, l);
        }
        return Class.forName(name2);
    }

    private static ClassLoader[] getClassLoaders() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader[]>(){

            @Override
            public ClassLoader[] run() {
                ClassLoader[] loaders = new ClassLoader[2];
                try {
                    loaders[0] = ClassLoader.getSystemClassLoader();
                }
                catch (SecurityException ignore) {
                    loaders[0] = null;
                }
                try {
                    loaders[1] = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException ignore) {
                    loaders[1] = null;
                }
                return loaders;
            }
        });
    }

    LogManagerProperties(Properties parent, String prefix) {
        super(parent);
        if (parent == null || prefix == null) {
            throw new NullPointerException();
        }
        this.prefix = prefix;
    }

    @Override
    public synchronized Object clone() {
        return this.exportCopy(this.defaults);
    }

    @Override
    public synchronized String getProperty(String key2) {
        String value2 = this.defaults.getProperty(key2);
        if (value2 == null) {
            if (key2.length() > 0) {
                value2 = LogManagerProperties.fromLogManager(this.prefix + '.' + key2);
            }
            if (value2 == null) {
                value2 = LogManagerProperties.fromLogManager(key2);
            }
            if (value2 != null) {
                super.put(key2, value2);
            } else {
                Object v = super.get(key2);
                value2 = v instanceof String ? (String)v : null;
            }
        }
        return value2;
    }

    @Override
    public String getProperty(String key2, String def) {
        String value2 = this.getProperty(key2);
        return value2 == null ? def : value2;
    }

    @Override
    public synchronized Object get(Object key2) {
        Object value2 = key2 instanceof String ? this.getProperty((String)key2) : null;
        if (value2 == null && (value2 = this.defaults.get(key2)) == null && !this.defaults.containsKey(key2)) {
            value2 = super.get(key2);
        }
        return value2;
    }

    @Override
    public synchronized Object put(Object key2, Object value2) {
        if (key2 instanceof String && value2 instanceof String) {
            Object def = this.preWrite(key2);
            Object man = super.put(key2, value2);
            return man == null ? def : man;
        }
        return super.put(key2, value2);
    }

    @Override
    public Object setProperty(String key2, String value2) {
        return this.put(key2, value2);
    }

    @Override
    public synchronized boolean containsKey(Object key2) {
        boolean found;
        boolean bl = found = key2 instanceof String && this.getProperty((String)key2) != null;
        if (!found) {
            found = this.defaults.containsKey(key2) || super.containsKey(key2);
        }
        return found;
    }

    @Override
    public synchronized Object remove(Object key2) {
        Object def = this.preWrite(key2);
        Object man = super.remove(key2);
        return man == null ? def : man;
    }

    @Override
    public Enumeration<?> propertyNames() {
        assert (false);
        return super.propertyNames();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Properties)) {
            return false;
        }
        assert (false) : this.prefix;
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        assert (false) : this.prefix.hashCode();
        return super.hashCode();
    }

    private Object preWrite(Object key2) {
        assert (Thread.holdsLock(this));
        return this.get(key2);
    }

    private Properties exportCopy(Properties parent) {
        Thread.holdsLock(this);
        Properties child = new Properties(parent);
        child.putAll((Map<?, ?>)this);
        return child;
    }

    private synchronized Object writeReplace() throws ObjectStreamException {
        assert (false);
        return this.exportCopy((Properties)this.defaults.clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Method lrgi = null;
        Method zisd = null;
        Method zdtoi = null;
        try {
            lrgi = LogRecord.class.getMethod("getInstant", new Class[0]);
            assert (Comparable.class.isAssignableFrom(lrgi.getReturnType())) : lrgi;
            zisd = LogManagerProperties.findClass("java.time.ZoneId").getMethod("systemDefault", new Class[0]);
            if (!Modifier.isStatic(zisd.getModifiers())) {
                throw new NoSuchMethodException(zisd.toString());
            }
            zdtoi = LogManagerProperties.findClass("java.time.ZonedDateTime").getMethod("ofInstant", LogManagerProperties.findClass("java.time.Instant"), LogManagerProperties.findClass("java.time.ZoneId"));
            if (!Modifier.isStatic(zdtoi.getModifiers())) {
                throw new NoSuchMethodException(zdtoi.toString());
            }
            if (!Comparable.class.isAssignableFrom(zdtoi.getReturnType())) {
                throw new NoSuchMethodException(zdtoi.toString());
            }
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception2) {
        }
        catch (LinkageError linkageError) {
        }
        finally {
            if (lrgi == null || zisd == null || zdtoi == null) {
                lrgi = null;
                zisd = null;
                zdtoi = null;
            }
        }
        LR_GET_INSTANT = lrgi;
        ZI_SYSTEM_DEFAULT = zisd;
        ZDT_OF_INSTANT = zdtoi;
        LOG_MANAGER = LogManagerProperties.loadLogManager();
    }
}

