/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.output;

import com.sun.istack.FinalArrayList;
import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.runtime.output.Encoded;
import com.sun.xml.bind.v2.runtime.output.UTF8XmlOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;

public class C14nXmlOutput
extends UTF8XmlOutput {
    private StaticAttribute[] staticAttributes = new StaticAttribute[8];
    private int len = 0;
    private int[] nsBuf = new int[8];
    private final FinalArrayList<DynamicAttribute> otherAttributes = new FinalArrayList();
    private final boolean namedAttributesAreOrdered;

    public C14nXmlOutput(OutputStream out, Encoded[] localNames, boolean namedAttributesAreOrdered, CharacterEscapeHandler escapeHandler) {
        super(out, localNames, escapeHandler);
        this.namedAttributesAreOrdered = namedAttributesAreOrdered;
        for (int i2 = 0; i2 < this.staticAttributes.length; ++i2) {
            this.staticAttributes[i2] = new StaticAttribute();
        }
    }

    @Override
    public void attribute(Name name2, String value2) throws IOException {
        if (this.staticAttributes.length == this.len) {
            int newLen = this.len * 2;
            StaticAttribute[] newbuf = new StaticAttribute[newLen];
            System.arraycopy(this.staticAttributes, 0, newbuf, 0, this.len);
            for (int i2 = this.len; i2 < newLen; ++i2) {
                this.staticAttributes[i2] = new StaticAttribute();
            }
            this.staticAttributes = newbuf;
        }
        this.staticAttributes[this.len++].set(name2, value2);
    }

    @Override
    public void attribute(int prefix, String localName, String value2) throws IOException {
        this.otherAttributes.add(new DynamicAttribute(prefix, localName, value2));
    }

    @Override
    public void endStartTag() throws IOException {
        if (this.otherAttributes.isEmpty()) {
            if (this.len != 0) {
                if (!this.namedAttributesAreOrdered) {
                    Arrays.sort(this.staticAttributes, 0, this.len);
                }
                for (int i2 = 0; i2 < this.len; ++i2) {
                    this.staticAttributes[i2].write();
                }
                this.len = 0;
            }
        } else {
            for (int i3 = 0; i3 < this.len; ++i3) {
                this.otherAttributes.add(this.staticAttributes[i3].toDynamicAttribute());
            }
            this.len = 0;
            Collections.sort(this.otherAttributes);
            int size2 = this.otherAttributes.size();
            for (int i4 = 0; i4 < size2; ++i4) {
                DynamicAttribute a = (DynamicAttribute)this.otherAttributes.get(i4);
                super.attribute(a.prefix, a.localName, a.value);
            }
            this.otherAttributes.clear();
        }
        super.endStartTag();
    }

    @Override
    protected void writeNsDecls(int base) throws IOException {
        int i2;
        int count2 = this.nsContext.getCurrent().count();
        if (count2 == 0) {
            return;
        }
        if (count2 > this.nsBuf.length) {
            this.nsBuf = new int[count2];
        }
        for (i2 = count2 - 1; i2 >= 0; --i2) {
            this.nsBuf[i2] = base + i2;
        }
        for (i2 = 0; i2 < count2; ++i2) {
            for (int j = i2 + 1; j < count2; ++j) {
                String q;
                String p2 = this.nsContext.getPrefix(this.nsBuf[i2]);
                if (p2.compareTo(q = this.nsContext.getPrefix(this.nsBuf[j])) <= 0) continue;
                int t = this.nsBuf[j];
                this.nsBuf[j] = this.nsBuf[i2];
                this.nsBuf[i2] = t;
            }
        }
        for (i2 = 0; i2 < count2; ++i2) {
            this.writeNsDecl(this.nsBuf[i2]);
        }
    }

    final class DynamicAttribute
    implements Comparable<DynamicAttribute> {
        final int prefix;
        final String localName;
        final String value;

        public DynamicAttribute(int prefix, String localName, String value2) {
            this.prefix = prefix;
            this.localName = localName;
            this.value = value2;
        }

        private String getURI() {
            if (this.prefix == -1) {
                return "";
            }
            return C14nXmlOutput.this.nsContext.getNamespaceURI(this.prefix);
        }

        @Override
        public int compareTo(DynamicAttribute that) {
            int r = this.getURI().compareTo(that.getURI());
            if (r != 0) {
                return r;
            }
            return this.localName.compareTo(that.localName);
        }
    }

    final class StaticAttribute
    implements Comparable<StaticAttribute> {
        Name name;
        String value;

        StaticAttribute() {
        }

        public void set(Name name2, String value2) {
            this.name = name2;
            this.value = value2;
        }

        void write() throws IOException {
            C14nXmlOutput.super.attribute(this.name, this.value);
        }

        DynamicAttribute toDynamicAttribute() {
            short nsUriIndex = this.name.nsUriIndex;
            int prefix = nsUriIndex == -1 ? -1 : C14nXmlOutput.this.nsUriIndex2prefixIndex[nsUriIndex];
            return new DynamicAttribute(prefix, this.name.localName, this.value);
        }

        @Override
        public int compareTo(StaticAttribute that) {
            return this.name.compareTo(that.name);
        }
    }
}

